/*
  File autogenerated by gengetopt version 2.22.6
  generated with the following command:
  gengetopt -i cmdlineEnumNG.ggo -c c.in -H h.in -F cmdlineEnumNG --show-required

  The developers of gengetopt consider the fixed text that goes in all
  gengetopt output files to be in the public domain:
  we make no copyright claims on it.
*/

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifndef FIX_UNUSED
#define FIX_UNUSED(X) (void) (X) /* avoid warnings for unused params */
#endif

#include <getopt.h>

#include "cmdlineEnumNG.h"

const char *gengetopt_args_info_purpose = "";

const char *gengetopt_args_info_usage = "Usage: enumNG [OPTIONS]...";

const char *gengetopt_args_info_versiontext = "The MIT License (MIT)\nCopyright (c) 2019 Horst Goertz Institute for IT-Security\n(Ruhr-University Bochum)";

const char *gengetopt_args_info_description = "enumNG is part of the Ordered Markov ENumerator (OMEN).\nenumNG creates passwords based on the nGrams defined in createConfig.";

const char *gengetopt_args_info_help[] = {
  "  -h, --help                  Print help and exit",
  "  -V, --version               Print version and exit",
  "\nModes:",
  "  -u, --username=FILENAME     Activate username mode using the data in the\n                                given file",
  "  -s, --simAtt=FILENAME       Execute a simulated attack against the given\n                                target file",
  "  -p, --pipeMode              Only print generated Passwords and nothing else\n                                (overrides any other mode!)  (default=off)",
  "\nPassword Generation:",
  "  -a, --alpha=FILENAME        Apply boosting factor alpha. Read alpha values\n                                from filename. Alphas need to be in the same\n                                order as the hints.",
  "  -H, --hint=FILENAME         File containing the hints for alpha boosting.\n                                Need to be in the same order as the alpha\n                                values.",
  "      --boostEP               Controls wether EPs are boosted or not.\n                                (default=off)",
  "  -L, --llFactor=FLOAT        Apply the given level length factor. Factor\n                                should be in range 0.0 to 10.0  (default=`0.0')",
  "  -S, --llSet=INT             Set all length level to the given value. Values\n                                should be in range 0 to 101  (default=`0')",
  "  -O, --optimizedLS           Activate optimized length scheduling\n                                (default=off)",
  "  -l, --fixedLength=INT       Only generate Passwords of the given length\n                                between 3 and 19. Default disabled.\n                                (default=`0')",
  "  -m, --maxattempts=LONGLONG  Set the amount of passwords created. The value\n                                should be in range 1 to 10^15",
  "  -e, --endless               Generate all possible passwords (this may take a\n                                while)  (default=off)",
  "  -E, --ignoreEP              Ignore the endProbs while generating Passwords\n                                (default=off)",
  "\nOutput Modes:",
  "  -v, --verbose               Gain information about settings and results\n                                during run time  (default=off)",
  "  -F, --verboseFile           Stores the generated passwords on hard drive disc\n                                (independent of the used mode)  (default=off)",
  "  -w, --printWarnings         Prints any warning (if verbose mode is active).\n                                (default=off)",
  "\nOthers:",
  "  -C, --config=FILENAME       Change the used config file",
    0
};

typedef enum {ARG_NO
  , ARG_FLAG
  , ARG_STRING
  , ARG_INT
  , ARG_FLOAT
  , ARG_LONGLONG
} cmdline_parser_arg_type;

static
void clear_given (struct gengetopt_args_info *args_info);
static
void clear_args (struct gengetopt_args_info *args_info);

static int
cmdline_parser_internal (int argc, char **argv, struct gengetopt_args_info *args_info,
                        struct cmdline_parser_params *params, const char *additional_error);


static char *
gengetopt_strdup (const char *s);

static
void clear_given (struct gengetopt_args_info *args_info)
{
  args_info->help_given = 0 ;
  args_info->version_given = 0 ;
  args_info->username_given = 0 ;
  args_info->simAtt_given = 0 ;
  args_info->pipeMode_given = 0 ;
  args_info->alpha_given = 0 ;
  args_info->hint_given = 0 ;
  args_info->boostEP_given = 0 ;
  args_info->llFactor_given = 0 ;
  args_info->llSet_given = 0 ;
  args_info->optimizedLS_given = 0 ;
  args_info->fixedLength_given = 0 ;
  args_info->maxattempts_given = 0 ;
  args_info->endless_given = 0 ;
  args_info->ignoreEP_given = 0 ;
  args_info->verbose_given = 0 ;
  args_info->verboseFile_given = 0 ;
  args_info->printWarnings_given = 0 ;
  args_info->config_given = 0 ;
}

static
void clear_args (struct gengetopt_args_info *args_info)
{
  FIX_UNUSED (args_info);
  args_info->username_arg = NULL;
  args_info->username_orig = NULL;
  args_info->simAtt_arg = NULL;
  args_info->simAtt_orig = NULL;
  args_info->pipeMode_flag = 0;
  args_info->alpha_arg = NULL;
  args_info->alpha_orig = NULL;
  args_info->hint_arg = NULL;
  args_info->hint_orig = NULL;
  args_info->boostEP_flag = 0;
  args_info->llFactor_arg = 0.0;
  args_info->llFactor_orig = NULL;
  args_info->llSet_arg = 0;
  args_info->llSet_orig = NULL;
  args_info->optimizedLS_flag = 0;
  args_info->fixedLength_arg = 0;
  args_info->fixedLength_orig = NULL;
  args_info->maxattempts_orig = NULL;
  args_info->endless_flag = 0;
  args_info->ignoreEP_flag = 0;
  args_info->verbose_flag = 0;
  args_info->verboseFile_flag = 0;
  args_info->printWarnings_flag = 0;
  args_info->config_arg = NULL;
  args_info->config_orig = NULL;

}

static
void init_args_info(struct gengetopt_args_info *args_info)
{


  args_info->help_help = gengetopt_args_info_help[0] ;
  args_info->version_help = gengetopt_args_info_help[1] ;
  args_info->username_help = gengetopt_args_info_help[3] ;
  args_info->simAtt_help = gengetopt_args_info_help[4] ;
  args_info->pipeMode_help = gengetopt_args_info_help[5] ;
  args_info->alpha_help = gengetopt_args_info_help[7] ;
  args_info->hint_help = gengetopt_args_info_help[8] ;
  args_info->boostEP_help = gengetopt_args_info_help[9] ;
  args_info->llFactor_help = gengetopt_args_info_help[10] ;
  args_info->llSet_help = gengetopt_args_info_help[11] ;
  args_info->optimizedLS_help = gengetopt_args_info_help[12] ;
  args_info->fixedLength_help = gengetopt_args_info_help[13] ;
  args_info->maxattempts_help = gengetopt_args_info_help[14] ;
  args_info->endless_help = gengetopt_args_info_help[15] ;
  args_info->ignoreEP_help = gengetopt_args_info_help[16] ;
  args_info->verbose_help = gengetopt_args_info_help[18] ;
  args_info->verboseFile_help = gengetopt_args_info_help[19] ;
  args_info->printWarnings_help = gengetopt_args_info_help[20] ;
  args_info->config_help = gengetopt_args_info_help[22] ;

}

void
cmdline_parser_print_version (void)
{
  printf ("%s %s\n",
     (strlen(CMDLINE_PARSER_PACKAGE_NAME) ? CMDLINE_PARSER_PACKAGE_NAME : CMDLINE_PARSER_PACKAGE),
     CMDLINE_PARSER_VERSION);

  if (strlen(gengetopt_args_info_versiontext) > 0)
    printf("\n%s\n", gengetopt_args_info_versiontext);
}

static void print_help_common(void) {
  cmdline_parser_print_version ();

  if (strlen(gengetopt_args_info_purpose) > 0)
    printf("\n%s\n", gengetopt_args_info_purpose);

  if (strlen(gengetopt_args_info_usage) > 0)
    printf("\n%s\n", gengetopt_args_info_usage);

  printf("\n");

  if (strlen(gengetopt_args_info_description) > 0)
    printf("%s\n\n", gengetopt_args_info_description);
}

void
cmdline_parser_print_help (void)
{
  int i = 0;
  print_help_common();
  while (gengetopt_args_info_help[i])
    printf("%s\n", gengetopt_args_info_help[i++]);
}

void
cmdline_parser_init (struct gengetopt_args_info *args_info)
{
  clear_given (args_info);
  clear_args (args_info);
  init_args_info (args_info);
}

void
cmdline_parser_params_init(struct cmdline_parser_params *params)
{
  if (params)
    {
      params->override = 0;
      params->initialize = 1;
      params->check_required = 1;
      params->check_ambiguity = 0;
      params->print_errors = 1;
    }
}

struct cmdline_parser_params *
cmdline_parser_params_create(void)
{
  struct cmdline_parser_params *params =
    (struct cmdline_parser_params *)malloc(sizeof(struct cmdline_parser_params));
  cmdline_parser_params_init(params);
  return params;
}

static void
free_string_field (char **s)
{
  if (*s)
    {
      free (*s);
      *s = 0;
    }
}


static void
cmdline_parser_release (struct gengetopt_args_info *args_info)
{

  free_string_field (&(args_info->username_arg));
  free_string_field (&(args_info->username_orig));
  free_string_field (&(args_info->simAtt_arg));
  free_string_field (&(args_info->simAtt_orig));
  free_string_field (&(args_info->alpha_arg));
  free_string_field (&(args_info->alpha_orig));
  free_string_field (&(args_info->hint_arg));
  free_string_field (&(args_info->hint_orig));
  free_string_field (&(args_info->llFactor_orig));
  free_string_field (&(args_info->llSet_orig));
  free_string_field (&(args_info->fixedLength_orig));
  free_string_field (&(args_info->maxattempts_orig));
  free_string_field (&(args_info->config_arg));
  free_string_field (&(args_info->config_orig));



  clear_given (args_info);
}


static void
write_into_file(FILE *outfile, const char *opt, const char *arg, const char *values[])
{
  FIX_UNUSED (values);
  if (arg) {
    fprintf(outfile, "%s=\"%s\"\n", opt, arg);
  } else {
    fprintf(outfile, "%s\n", opt);
  }
}


int
cmdline_parser_dump(FILE *outfile, struct gengetopt_args_info *args_info)
{
  int i = 0;

  if (!outfile)
    {
      fprintf (stderr, "%s: cannot dump options to stream\n", CMDLINE_PARSER_PACKAGE);
      return EXIT_FAILURE;
    }

  if (args_info->help_given)
    write_into_file(outfile, "help", 0, 0 );
  if (args_info->version_given)
    write_into_file(outfile, "version", 0, 0 );
  if (args_info->username_given)
    write_into_file(outfile, "username", args_info->username_orig, 0);
  if (args_info->simAtt_given)
    write_into_file(outfile, "simAtt", args_info->simAtt_orig, 0);
  if (args_info->pipeMode_given)
    write_into_file(outfile, "pipeMode", 0, 0 );
  if (args_info->alpha_given)
    write_into_file(outfile, "alpha", args_info->alpha_orig, 0);
  if (args_info->hint_given)
    write_into_file(outfile, "hint", args_info->hint_orig, 0);
  if (args_info->boostEP_given)
    write_into_file(outfile, "boostEP", 0, 0 );
  if (args_info->llFactor_given)
    write_into_file(outfile, "llFactor", args_info->llFactor_orig, 0);
  if (args_info->llSet_given)
    write_into_file(outfile, "llSet", args_info->llSet_orig, 0);
  if (args_info->optimizedLS_given)
    write_into_file(outfile, "optimizedLS", 0, 0 );
  if (args_info->fixedLength_given)
    write_into_file(outfile, "fixedLength", args_info->fixedLength_orig, 0);
  if (args_info->maxattempts_given)
    write_into_file(outfile, "maxattempts", args_info->maxattempts_orig, 0);
  if (args_info->endless_given)
    write_into_file(outfile, "endless", 0, 0 );
  if (args_info->ignoreEP_given)
    write_into_file(outfile, "ignoreEP", 0, 0 );
  if (args_info->verbose_given)
    write_into_file(outfile, "verbose", 0, 0 );
  if (args_info->verboseFile_given)
    write_into_file(outfile, "verboseFile", 0, 0 );
  if (args_info->printWarnings_given)
    write_into_file(outfile, "printWarnings", 0, 0 );
  if (args_info->config_given)
    write_into_file(outfile, "config", args_info->config_orig, 0);


  i = EXIT_SUCCESS;
  return i;
}

int
cmdline_parser_file_save(const char *filename, struct gengetopt_args_info *args_info)
{
  FILE *outfile;
  int i = 0;

  outfile = fopen(filename, "w");

  if (!outfile)
    {
      fprintf (stderr, "%s: cannot open file for writing: %s\n", CMDLINE_PARSER_PACKAGE, filename);
      return EXIT_FAILURE;
    }

  i = cmdline_parser_dump(outfile, args_info);
  fclose (outfile);

  return i;
}

void
cmdline_parser_free (struct gengetopt_args_info *args_info)
{
  cmdline_parser_release (args_info);
}

/** @brief replacement of strdup, which is not standard */
char *
gengetopt_strdup (const char *s)
{
  char *result = 0;
  if (!s)
    return result;

  result = (char*)malloc(strlen(s) + 1);
  if (result == (char*)0)
    return (char*)0;
  strcpy(result, s);
  return result;
}

int
cmdline_parser (int argc, char **argv, struct gengetopt_args_info *args_info)
{
  return cmdline_parser2 (argc, argv, args_info, 0, 1, 1);
}

int
cmdline_parser_ext (int argc, char **argv, struct gengetopt_args_info *args_info,
                   struct cmdline_parser_params *params)
{
  int result;
  result = cmdline_parser_internal (argc, argv, args_info, params, 0);

  if (result == EXIT_FAILURE)
    {
      cmdline_parser_free (args_info);
      exit (EXIT_FAILURE);
    }

  return result;
}

int
cmdline_parser2 (int argc, char **argv, struct gengetopt_args_info *args_info, int override, int initialize, int check_required)
{
  int result;
  struct cmdline_parser_params params;

  params.override = override;
  params.initialize = initialize;
  params.check_required = check_required;
  params.check_ambiguity = 0;
  params.print_errors = 1;

  result = cmdline_parser_internal (argc, argv, args_info, &params, 0);

  if (result == EXIT_FAILURE)
    {
      cmdline_parser_free (args_info);
      exit (EXIT_FAILURE);
    }

  return result;
}

int
cmdline_parser_required (struct gengetopt_args_info *args_info, const char *prog_name)
{
  FIX_UNUSED (args_info);
  FIX_UNUSED (prog_name);
  return EXIT_SUCCESS;
}


static char *package_name = 0;

/**
 * @brief updates an option
 * @param field the generic pointer to the field to update
 * @param orig_field the pointer to the orig field
 * @param field_given the pointer to the number of occurrence of this option
 * @param prev_given the pointer to the number of occurrence already seen
 * @param value the argument for this option (if null no arg was specified)
 * @param possible_values the possible values for this option (if specified)
 * @param default_value the default value (in case the option only accepts fixed values)
 * @param arg_type the type of this option
 * @param check_ambiguity @see cmdline_parser_params.check_ambiguity
 * @param override @see cmdline_parser_params.override
 * @param no_free whether to free a possible previous value
 * @param multiple_option whether this is a multiple option
 * @param long_opt the corresponding long option
 * @param short_opt the corresponding short option (or '-' if none)
 * @param additional_error possible further error specification
 */
static
int update_arg(void *field, char **orig_field,
               unsigned int *field_given, unsigned int *prev_given,
               char *value, const char *possible_values[],
               const char *default_value,
               cmdline_parser_arg_type arg_type,
               int check_ambiguity, int override,
               int no_free, int multiple_option,
               const char *long_opt, char short_opt,
               const char *additional_error)
{
  char *stop_char = 0;
  const char *val = value;
  int found;
  char **string_field;
  FIX_UNUSED (field);
  FIX_UNUSED (stop_char);
  FIX_UNUSED (val);

  found = 0;

  if (!multiple_option && prev_given && (*prev_given || (check_ambiguity && *field_given)))
    {
      if (short_opt != '-')
        fprintf (stderr, "%s: `--%s' (`-%c') option given more than once%s\n",
               package_name, long_opt, short_opt,
               (additional_error ? additional_error : ""));
      else
        fprintf (stderr, "%s: `--%s' option given more than once%s\n",
               package_name, long_opt,
               (additional_error ? additional_error : ""));
      return 1; /* failure */
    }

  FIX_UNUSED (default_value);

  if (field_given && *field_given && ! override)
    return 0;
  if (prev_given)
    (*prev_given)++;
  if (field_given)
    (*field_given)++;
  if (possible_values)
    val = possible_values[found];

  switch(arg_type) {
  case ARG_FLAG:
    *((int *)field) = !*((int *)field);
    break;
  case ARG_INT:
    if (val) *((int *)field) = strtol (val, &stop_char, 0);
    break;
  case ARG_FLOAT:
    if (val) *((float *)field) = (float)strtod (val, &stop_char);
    break;
  case ARG_LONGLONG:
#if defined(HAVE_LONG_LONG) || defined(HAVE_LONG_LONG_INT)
    if (val) *((long long int*)field) = (long long int) strtoll (val, &stop_char, 0);
#else
    if (val) *((long *)field) = (long)strtol (val, &stop_char, 0);
#endif
    break;
  case ARG_STRING:
    if (val) {
      string_field = (char **)field;
      if (!no_free && *string_field)
        free (*string_field); /* free previous string */
      *string_field = gengetopt_strdup (val);
    }
    break;
  default:
    break;
  };

  /* check numeric conversion */
  switch(arg_type) {
  case ARG_INT:
  case ARG_FLOAT:
  case ARG_LONGLONG:
    if (val && !(stop_char && *stop_char == '\0')) {
      fprintf(stderr, "%s: invalid numeric value: %s\n", package_name, val);
      return 1; /* failure */
    }
    break;
  default:
    ;
  };

  /* store the original value */
  switch(arg_type) {
  case ARG_NO:
  case ARG_FLAG:
    break;
  default:
    if (value && orig_field) {
      if (no_free) {
        *orig_field = value;
      } else {
        if (*orig_field)
          free (*orig_field); /* free previous string */
        *orig_field = gengetopt_strdup (value);
      }
    }
  };

  return 0; /* OK */
}


int
cmdline_parser_internal (
  int argc, char **argv, struct gengetopt_args_info *args_info,
                        struct cmdline_parser_params *params, const char *additional_error)
{
  int c;	/* Character of the parsed option.  */

  int error_occurred = 0;
  struct gengetopt_args_info local_args_info;

  int override;
  int initialize;
  int check_required;
  int check_ambiguity;

  package_name = argv[0];

  override = params->override;
  initialize = params->initialize;
  check_required = params->check_required;
  check_ambiguity = params->check_ambiguity;

  if (initialize)
    cmdline_parser_init (args_info);

  cmdline_parser_init (&local_args_info);

  optarg = 0;
  optind = 0;
  opterr = params->print_errors;
  optopt = '?';

  while (1)
    {
      int option_index = 0;

      static struct option long_options[] = {
        { "help",	0, NULL, 'h' },
        { "version",	0, NULL, 'V' },
        { "username",	1, NULL, 'u' },
        { "simAtt",	1, NULL, 's' },
        { "pipeMode",	0, NULL, 'p' },
        { "alpha",	1, NULL, 'a' },
        { "hint",	1, NULL, 'H' },
        { "boostEP",	0, NULL, 0 },
        { "llFactor",	1, NULL, 'L' },
        { "llSet",	1, NULL, 'S' },
        { "optimizedLS",	0, NULL, 'O' },
        { "fixedLength",	1, NULL, 'l' },
        { "maxattempts",	1, NULL, 'm' },
        { "endless",	0, NULL, 'e' },
        { "ignoreEP",	0, NULL, 'E' },
        { "verbose",	0, NULL, 'v' },
        { "verboseFile",	0, NULL, 'F' },
        { "printWarnings",	0, NULL, 'w' },
        { "config",	1, NULL, 'C' },
        { 0,  0, 0, 0 }
      };

      c = getopt_long (argc, argv, "hVu:s:pa:H:L:S:Ol:m:eEvFwC:", long_options, &option_index);

      if (c == -1) break;	/* Exit from `while (1)' loop.  */

      switch (c)
        {
        case 'h':	/* Print help and exit.  */
          cmdline_parser_print_help ();
          cmdline_parser_free (&local_args_info);
          exit (EXIT_SUCCESS);

        case 'V':	/* Print version and exit.  */
          cmdline_parser_print_version ();
          cmdline_parser_free (&local_args_info);
          exit (EXIT_SUCCESS);

        case 'u':	/* Activate username mode using the data in the given file.  */


          if (update_arg( (void *)&(args_info->username_arg),
               &(args_info->username_orig), &(args_info->username_given),
              &(local_args_info.username_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "username", 'u',
              additional_error))
            goto failure;

          break;
        case 's':	/* Execute a simulated attack against the given target file.  */


          if (update_arg( (void *)&(args_info->simAtt_arg),
               &(args_info->simAtt_orig), &(args_info->simAtt_given),
              &(local_args_info.simAtt_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "simAtt", 's',
              additional_error))
            goto failure;

          break;
        case 'p':	/* Only print generated Passwords and nothing else (overrides any other mode!).  */


          if (update_arg((void *)&(args_info->pipeMode_flag), 0, &(args_info->pipeMode_given),
              &(local_args_info.pipeMode_given), optarg, 0, 0, ARG_FLAG,
              check_ambiguity, override, 1, 0, "pipeMode", 'p',
              additional_error))
            goto failure;

          break;
        case 'a':	/* Apply boosting factor alpha. Read alpha values from filename. Alphas need to be in the same order as the hints..  */


          if (update_arg( (void *)&(args_info->alpha_arg),
               &(args_info->alpha_orig), &(args_info->alpha_given),
              &(local_args_info.alpha_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "alpha", 'a',
              additional_error))
            goto failure;

          break;
        case 'H':	/* File containing the hints for alpha boosting. Need to be in the same order as the alpha values..  */


          if (update_arg( (void *)&(args_info->hint_arg),
               &(args_info->hint_orig), &(args_info->hint_given),
              &(local_args_info.hint_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "hint", 'H',
              additional_error))
            goto failure;

          break;
        case 'L':	/* Apply the given level length factor. Factor should be in range 0.0 to 10.0.  */


          if (update_arg( (void *)&(args_info->llFactor_arg),
               &(args_info->llFactor_orig), &(args_info->llFactor_given),
              &(local_args_info.llFactor_given), optarg, 0, "0.0", ARG_FLOAT,
              check_ambiguity, override, 0, 0,
              "llFactor", 'L',
              additional_error))
            goto failure;

          break;
        case 'S':	/* Set all length level to the given value. Values should be in range 0 to 101.  */


          if (update_arg( (void *)&(args_info->llSet_arg),
               &(args_info->llSet_orig), &(args_info->llSet_given),
              &(local_args_info.llSet_given), optarg, 0, "0", ARG_INT,
              check_ambiguity, override, 0, 0,
              "llSet", 'S',
              additional_error))
            goto failure;

          break;
        case 'O':	/* Activate optimized length scheduling.  */


          if (update_arg((void *)&(args_info->optimizedLS_flag), 0, &(args_info->optimizedLS_given),
              &(local_args_info.optimizedLS_given), optarg, 0, 0, ARG_FLAG,
              check_ambiguity, override, 1, 0, "optimizedLS", 'O',
              additional_error))
            goto failure;

          break;
        case 'l':	/* Only generate Passwords of the given length between 3 and 19. Default disabled..  */


          if (update_arg( (void *)&(args_info->fixedLength_arg),
               &(args_info->fixedLength_orig), &(args_info->fixedLength_given),
              &(local_args_info.fixedLength_given), optarg, 0, "0", ARG_INT,
              check_ambiguity, override, 0, 0,
              "fixedLength", 'l',
              additional_error))
            goto failure;

          break;
        case 'm':	/* Set the amount of passwords created. The value should be in range 1 to 10^15.  */


          if (update_arg( (void *)&(args_info->maxattempts_arg),
               &(args_info->maxattempts_orig), &(args_info->maxattempts_given),
              &(local_args_info.maxattempts_given), optarg, 0, 0, ARG_LONGLONG,
              check_ambiguity, override, 0, 0,
              "maxattempts", 'm',
              additional_error))
            goto failure;

          break;
        case 'e':	/* Generate all possible passwords (this may take a while).  */


          if (update_arg((void *)&(args_info->endless_flag), 0, &(args_info->endless_given),
              &(local_args_info.endless_given), optarg, 0, 0, ARG_FLAG,
              check_ambiguity, override, 1, 0, "endless", 'e',
              additional_error))
            goto failure;

          break;
        case 'E':	/* Ignore the endProbs while generating Passwords.  */


          if (update_arg((void *)&(args_info->ignoreEP_flag), 0, &(args_info->ignoreEP_given),
              &(local_args_info.ignoreEP_given), optarg, 0, 0, ARG_FLAG,
              check_ambiguity, override, 1, 0, "ignoreEP", 'E',
              additional_error))
            goto failure;

          break;
        case 'v':	/* Gain information about settings and results during run time.  */


          if (update_arg((void *)&(args_info->verbose_flag), 0, &(args_info->verbose_given),
              &(local_args_info.verbose_given), optarg, 0, 0, ARG_FLAG,
              check_ambiguity, override, 1, 0, "verbose", 'v',
              additional_error))
            goto failure;

          break;
        case 'F':	/* Stores the generated passwords on hard drive disc (independent of the used mode).  */


          if (update_arg((void *)&(args_info->verboseFile_flag), 0, &(args_info->verboseFile_given),
              &(local_args_info.verboseFile_given), optarg, 0, 0, ARG_FLAG,
              check_ambiguity, override, 1, 0, "verboseFile", 'F',
              additional_error))
            goto failure;

          break;
        case 'w':	/* Prints any warning (if verbose mode is active)..  */


          if (update_arg((void *)&(args_info->printWarnings_flag), 0, &(args_info->printWarnings_given),
              &(local_args_info.printWarnings_given), optarg, 0, 0, ARG_FLAG,
              check_ambiguity, override, 1, 0, "printWarnings", 'w',
              additional_error))
            goto failure;

          break;
        case 'C':	/* Change the used config file.  */


          if (update_arg( (void *)&(args_info->config_arg),
               &(args_info->config_orig), &(args_info->config_given),
              &(local_args_info.config_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "config", 'C',
              additional_error))
            goto failure;

          break;

        case 0:	/* Long option with no short option */
          /* Controls wether EPs are boosted or not..  */
          if (strcmp (long_options[option_index].name, "boostEP") == 0)
          {


            if (update_arg((void *)&(args_info->boostEP_flag), 0, &(args_info->boostEP_given),
                &(local_args_info.boostEP_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "boostEP", '-',
                additional_error))
              goto failure;

          }

          break;
        case '?':	/* Invalid option.  */
          /* `getopt_long' already printed an error message.  */
          goto failure;

        default:	/* bug: option not considered.  */
          fprintf (stderr, "%s: option unknown: %c%s\n", CMDLINE_PARSER_PACKAGE, c, (additional_error ? additional_error : ""));
          abort ();
        } /* switch */
    } /* while */



  FIX_UNUSED (check_required);

  cmdline_parser_release (&local_args_info);

  if ( error_occurred )
    return (EXIT_FAILURE);

  return 0;

failure:

  cmdline_parser_release (&local_args_info);
  return (EXIT_FAILURE);
}
