/*
  File autogenerated by gengetopt version 2.22.6
  generated with the following command:
  gengetopt -i cmdlineCreateNG.ggo -c c.in -H h.in -F cmdlineCreateNG --show-required

  The developers of gengetopt consider the fixed text that goes in all
  gengetopt output files to be in the public domain:
  we make no copyright claims on it.
*/

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifndef FIX_UNUSED
#define FIX_UNUSED(X) (void) (X) /* avoid warnings for unused params */
#endif

#include <getopt.h>

#include "cmdlineCreateNG.h"

const char *gengetopt_args_info_purpose = "";

const char *gengetopt_args_info_usage = "Usage: createNG [OPTIONS]...";

const char *gengetopt_args_info_versiontext = "The MIT License (MIT)\nCopyright (c) 2019 Horst Goertz Institute for IT-Security\n(Ruhr-University Bochum)";

const char *gengetopt_args_info_description = "createNG is part of the Ordered Markov ENumerator (OMEN).\ncreateNG creates nGram based on the given password list.";

const char *gengetopt_args_info_help[] = {
  "  -h, --help                Print help and exit",
  "  -V, --version             Print version and exit",
  "\nInput Files:",
  "      --iPwdList=FILENAME   Password list to create nGrams. (mandatory)",
  "\nOutput Filenames:",
  "  -c, --cPout=FILENAME      Changes output filename for conditional\n                              probabilities.  (default=`CP')",
  "  -i, --iPout=FILENAME      Changes output filename for initial probabilities.\n                              (default=`IP')",
  "  -e, --ePout=FILENAME      Changes output filename for end probabilities\n                              (default=`EP')",
  "  -l, --lenout=FILENAME     Changes output filename for password lengths levels\n                              (default=`LN')",
  "  -C, --config=FILENAME     Changes config filename  (default=`createConfig')",
  "  -p, --prefix=STRING       Adds given prefix to all output files",
  "  -s, --suffix=STRING       Adds given suffix to all output files",
  "  -d, --datefix             Adds the current date and time as suffix to all\n                              output files  (default=off)",
  "\nnGram Calculation:",
  "  -n, --ngram=INT           Changes the size of the nGram n  (possible\n                              values=\"2\", \"3\", \"4\", \"5\" default=`4')",
  "  -m, --maxLevel=INT        Changes the maximum level in range 2 to 101\n                              (default=`11')",
  "  -a, --alphabet=STRING     Changes the used alphabet to the given <string>",
  "  -A, --fAlphabet=FILENAME  Changes the used alphabet to the alphabet found in\n                              <filename>.",
  "  -S, --smoothing=FILENAME  Changes the used smoothing function to the one\n                              defined in <filename>.",
  "\nOutput Modes:",
  "  -v, --verbose             Gain information about settings and results during\n                              run time.  (default=off)",
  "  -F, --verboseFile         Gain detailed information in the output files.\n                              (default=off)",
  "  -w, --printWarnings       Prints any warning (if verbose mode is active).\n                              (default=off)",
  "\nOthers:",
  "  -u, --withCount           The given password list is counted (like this:\n                              #count password).  (default=off)",
    0
};

typedef enum {ARG_NO
  , ARG_FLAG
  , ARG_STRING
  , ARG_INT
} cmdline_parser_arg_type;

static
void clear_given (struct gengetopt_args_info *args_info);
static
void clear_args (struct gengetopt_args_info *args_info);

static int
cmdline_parser_internal (int argc, char **argv, struct gengetopt_args_info *args_info,
                        struct cmdline_parser_params *params, const char *additional_error);

static int
cmdline_parser_required2 (struct gengetopt_args_info *args_info, const char *prog_name, const char *additional_error);

const char *cmdline_parser_ngram_values[] = {"2", "3", "4", "5", 0}; /*< Possible values for ngram. */

static char *
gengetopt_strdup (const char *s);

static
void clear_given (struct gengetopt_args_info *args_info)
{
  args_info->help_given = 0 ;
  args_info->version_given = 0 ;
  args_info->iPwdList_given = 0 ;
  args_info->cPout_given = 0 ;
  args_info->iPout_given = 0 ;
  args_info->ePout_given = 0 ;
  args_info->lenout_given = 0 ;
  args_info->config_given = 0 ;
  args_info->prefix_given = 0 ;
  args_info->suffix_given = 0 ;
  args_info->datefix_given = 0 ;
  args_info->ngram_given = 0 ;
  args_info->maxLevel_given = 0 ;
  args_info->alphabet_given = 0 ;
  args_info->fAlphabet_given = 0 ;
  args_info->smoothing_given = 0 ;
  args_info->verbose_given = 0 ;
  args_info->verboseFile_given = 0 ;
  args_info->printWarnings_given = 0 ;
  args_info->withCount_given = 0 ;
}

static
void clear_args (struct gengetopt_args_info *args_info)
{
  FIX_UNUSED (args_info);
  args_info->iPwdList_arg = NULL;
  args_info->iPwdList_orig = NULL;
  args_info->cPout_arg = gengetopt_strdup ("CP");
  args_info->cPout_orig = NULL;
  args_info->iPout_arg = gengetopt_strdup ("IP");
  args_info->iPout_orig = NULL;
  args_info->ePout_arg = gengetopt_strdup ("EP");
  args_info->ePout_orig = NULL;
  args_info->lenout_arg = gengetopt_strdup ("LN");
  args_info->lenout_orig = NULL;
  args_info->config_arg = gengetopt_strdup ("createConfig");
  args_info->config_orig = NULL;
  args_info->prefix_arg = NULL;
  args_info->prefix_orig = NULL;
  args_info->suffix_arg = NULL;
  args_info->suffix_orig = NULL;
  args_info->datefix_flag = 0;
  args_info->ngram_arg = 4;
  args_info->ngram_orig = NULL;
  args_info->maxLevel_arg = 11;
  args_info->maxLevel_orig = NULL;
  args_info->alphabet_arg = NULL;
  args_info->alphabet_orig = NULL;
  args_info->fAlphabet_arg = NULL;
  args_info->fAlphabet_orig = NULL;
  args_info->smoothing_arg = NULL;
  args_info->smoothing_orig = NULL;
  args_info->verbose_flag = 0;
  args_info->verboseFile_flag = 0;
  args_info->printWarnings_flag = 0;
  args_info->withCount_flag = 0;

}

static
void init_args_info(struct gengetopt_args_info *args_info)
{


  args_info->help_help = gengetopt_args_info_help[0] ;
  args_info->version_help = gengetopt_args_info_help[1] ;
  args_info->iPwdList_help = gengetopt_args_info_help[3] ;
  args_info->cPout_help = gengetopt_args_info_help[5] ;
  args_info->iPout_help = gengetopt_args_info_help[6] ;
  args_info->ePout_help = gengetopt_args_info_help[7] ;
  args_info->lenout_help = gengetopt_args_info_help[8] ;
  args_info->config_help = gengetopt_args_info_help[9] ;
  args_info->prefix_help = gengetopt_args_info_help[10] ;
  args_info->suffix_help = gengetopt_args_info_help[11] ;
  args_info->datefix_help = gengetopt_args_info_help[12] ;
  args_info->ngram_help = gengetopt_args_info_help[14] ;
  args_info->maxLevel_help = gengetopt_args_info_help[15] ;
  args_info->alphabet_help = gengetopt_args_info_help[16] ;
  args_info->fAlphabet_help = gengetopt_args_info_help[17] ;
  args_info->smoothing_help = gengetopt_args_info_help[18] ;
  args_info->verbose_help = gengetopt_args_info_help[20] ;
  args_info->verboseFile_help = gengetopt_args_info_help[21] ;
  args_info->printWarnings_help = gengetopt_args_info_help[22] ;
  args_info->withCount_help = gengetopt_args_info_help[24] ;

}

void
cmdline_parser_print_version (void)
{
  printf ("%s %s\n",
     (strlen(CMDLINE_PARSER_PACKAGE_NAME) ? CMDLINE_PARSER_PACKAGE_NAME : CMDLINE_PARSER_PACKAGE),
     CMDLINE_PARSER_VERSION);

  if (strlen(gengetopt_args_info_versiontext) > 0)
    printf("\n%s\n", gengetopt_args_info_versiontext);
}

static void print_help_common(void) {
  cmdline_parser_print_version ();

  if (strlen(gengetopt_args_info_purpose) > 0)
    printf("\n%s\n", gengetopt_args_info_purpose);

  if (strlen(gengetopt_args_info_usage) > 0)
    printf("\n%s\n", gengetopt_args_info_usage);

  printf("\n");

  if (strlen(gengetopt_args_info_description) > 0)
    printf("%s\n\n", gengetopt_args_info_description);
}

void
cmdline_parser_print_help (void)
{
  int i = 0;
  print_help_common();
  while (gengetopt_args_info_help[i])
    printf("%s\n", gengetopt_args_info_help[i++]);
}

void
cmdline_parser_init (struct gengetopt_args_info *args_info)
{
  clear_given (args_info);
  clear_args (args_info);
  init_args_info (args_info);
}

void
cmdline_parser_params_init(struct cmdline_parser_params *params)
{
  if (params)
    {
      params->override = 0;
      params->initialize = 1;
      params->check_required = 1;
      params->check_ambiguity = 0;
      params->print_errors = 1;
    }
}

struct cmdline_parser_params *
cmdline_parser_params_create(void)
{
  struct cmdline_parser_params *params =
    (struct cmdline_parser_params *)malloc(sizeof(struct cmdline_parser_params));
  cmdline_parser_params_init(params);
  return params;
}

static void
free_string_field (char **s)
{
  if (*s)
    {
      free (*s);
      *s = 0;
    }
}


static void
cmdline_parser_release (struct gengetopt_args_info *args_info)
{

  free_string_field (&(args_info->iPwdList_arg));
  free_string_field (&(args_info->iPwdList_orig));
  free_string_field (&(args_info->cPout_arg));
  free_string_field (&(args_info->cPout_orig));
  free_string_field (&(args_info->iPout_arg));
  free_string_field (&(args_info->iPout_orig));
  free_string_field (&(args_info->ePout_arg));
  free_string_field (&(args_info->ePout_orig));
  free_string_field (&(args_info->lenout_arg));
  free_string_field (&(args_info->lenout_orig));
  free_string_field (&(args_info->config_arg));
  free_string_field (&(args_info->config_orig));
  free_string_field (&(args_info->prefix_arg));
  free_string_field (&(args_info->prefix_orig));
  free_string_field (&(args_info->suffix_arg));
  free_string_field (&(args_info->suffix_orig));
  free_string_field (&(args_info->ngram_orig));
  free_string_field (&(args_info->maxLevel_orig));
  free_string_field (&(args_info->alphabet_arg));
  free_string_field (&(args_info->alphabet_orig));
  free_string_field (&(args_info->fAlphabet_arg));
  free_string_field (&(args_info->fAlphabet_orig));
  free_string_field (&(args_info->smoothing_arg));
  free_string_field (&(args_info->smoothing_orig));



  clear_given (args_info);
}

/**
 * @param val the value to check
 * @param values the possible values
 * @return the index of the matched value:
 * -1 if no value matched,
 * -2 if more than one value has matched
 */
static int
check_possible_values(const char *val, const char *values[])
{
  int i, found, last;
  size_t len;

  if (!val)   /* otherwise strlen() crashes below */
    return -1; /* -1 means no argument for the option */

  found = last = 0;

  for (i = 0, len = strlen(val); values[i]; ++i)
    {
      if (strncmp(val, values[i], len) == 0)
        {
          ++found;
          last = i;
          if (strlen(values[i]) == len)
            return i; /* exact macth no need to check more */
        }
    }

  if (found == 1) /* one match: OK */
    return last;

  return (found ? -2 : -1); /* return many values or none matched */
}


static void
write_into_file(FILE *outfile, const char *opt, const char *arg, const char *values[])
{
  int found = -1;
  if (arg) {
    if (values) {
      found = check_possible_values(arg, values);
    }
    if (found >= 0)
      fprintf(outfile, "%s=\"%s\" # %s\n", opt, arg, values[found]);
    else
      fprintf(outfile, "%s=\"%s\"\n", opt, arg);
  } else {
    fprintf(outfile, "%s\n", opt);
  }
}


int
cmdline_parser_dump(FILE *outfile, struct gengetopt_args_info *args_info)
{
  int i = 0;

  if (!outfile)
    {
      fprintf (stderr, "%s: cannot dump options to stream\n", CMDLINE_PARSER_PACKAGE);
      return EXIT_FAILURE;
    }

  if (args_info->help_given)
    write_into_file(outfile, "help", 0, 0 );
  if (args_info->version_given)
    write_into_file(outfile, "version", 0, 0 );
  if (args_info->iPwdList_given)
    write_into_file(outfile, "iPwdList", args_info->iPwdList_orig, 0);
  if (args_info->cPout_given)
    write_into_file(outfile, "cPout", args_info->cPout_orig, 0);
  if (args_info->iPout_given)
    write_into_file(outfile, "iPout", args_info->iPout_orig, 0);
  if (args_info->ePout_given)
    write_into_file(outfile, "ePout", args_info->ePout_orig, 0);
  if (args_info->lenout_given)
    write_into_file(outfile, "lenout", args_info->lenout_orig, 0);
  if (args_info->config_given)
    write_into_file(outfile, "config", args_info->config_orig, 0);
  if (args_info->prefix_given)
    write_into_file(outfile, "prefix", args_info->prefix_orig, 0);
  if (args_info->suffix_given)
    write_into_file(outfile, "suffix", args_info->suffix_orig, 0);
  if (args_info->datefix_given)
    write_into_file(outfile, "datefix", 0, 0 );
  if (args_info->ngram_given)
    write_into_file(outfile, "ngram", args_info->ngram_orig, cmdline_parser_ngram_values);
  if (args_info->maxLevel_given)
    write_into_file(outfile, "maxLevel", args_info->maxLevel_orig, 0);
  if (args_info->alphabet_given)
    write_into_file(outfile, "alphabet", args_info->alphabet_orig, 0);
  if (args_info->fAlphabet_given)
    write_into_file(outfile, "fAlphabet", args_info->fAlphabet_orig, 0);
  if (args_info->smoothing_given)
    write_into_file(outfile, "smoothing", args_info->smoothing_orig, 0);
  if (args_info->verbose_given)
    write_into_file(outfile, "verbose", 0, 0 );
  if (args_info->verboseFile_given)
    write_into_file(outfile, "verboseFile", 0, 0 );
  if (args_info->printWarnings_given)
    write_into_file(outfile, "printWarnings", 0, 0 );
  if (args_info->withCount_given)
    write_into_file(outfile, "withCount", 0, 0 );


  i = EXIT_SUCCESS;
  return i;
}

int
cmdline_parser_file_save(const char *filename, struct gengetopt_args_info *args_info)
{
  FILE *outfile;
  int i = 0;

  outfile = fopen(filename, "w");

  if (!outfile)
    {
      fprintf (stderr, "%s: cannot open file for writing: %s\n", CMDLINE_PARSER_PACKAGE, filename);
      return EXIT_FAILURE;
    }

  i = cmdline_parser_dump(outfile, args_info);
  fclose (outfile);

  return i;
}

void
cmdline_parser_free (struct gengetopt_args_info *args_info)
{
  cmdline_parser_release (args_info);
}

/** @brief replacement of strdup, which is not standard */
char *
gengetopt_strdup (const char *s)
{
  char *result = 0;
  if (!s)
    return result;

  result = (char*)malloc(strlen(s) + 1);
  if (result == (char*)0)
    return (char*)0;
  strcpy(result, s);
  return result;
}

int
cmdline_parser (int argc, char **argv, struct gengetopt_args_info *args_info)
{
  return cmdline_parser2 (argc, argv, args_info, 0, 1, 1);
}

int
cmdline_parser_ext (int argc, char **argv, struct gengetopt_args_info *args_info,
                   struct cmdline_parser_params *params)
{
  int result;
  result = cmdline_parser_internal (argc, argv, args_info, params, 0);

  if (result == EXIT_FAILURE)
    {
      cmdline_parser_free (args_info);
      exit (EXIT_FAILURE);
    }

  return result;
}

int
cmdline_parser2 (int argc, char **argv, struct gengetopt_args_info *args_info, int override, int initialize, int check_required)
{
  int result;
  struct cmdline_parser_params params;

  params.override = override;
  params.initialize = initialize;
  params.check_required = check_required;
  params.check_ambiguity = 0;
  params.print_errors = 1;

  result = cmdline_parser_internal (argc, argv, args_info, &params, 0);

  if (result == EXIT_FAILURE)
    {
      cmdline_parser_free (args_info);
      exit (EXIT_FAILURE);
    }

  return result;
}

int
cmdline_parser_required (struct gengetopt_args_info *args_info, const char *prog_name)
{
  int result = EXIT_SUCCESS;

  if (cmdline_parser_required2(args_info, prog_name, 0) > 0)
    result = EXIT_FAILURE;

  if (result == EXIT_FAILURE)
    {
      cmdline_parser_free (args_info);
      exit (EXIT_FAILURE);
    }

  return result;
}

int
cmdline_parser_required2 (struct gengetopt_args_info *args_info, const char *prog_name, const char *additional_error)
{
  int error_occurred = 0;
  FIX_UNUSED (additional_error);

  /* checks for required options */
  if (! args_info->iPwdList_given)
    {
      fprintf (stderr, "%s: '--iPwdList' option required%s\n", prog_name, (additional_error ? additional_error : ""));
      error_occurred = 1;
    }


  /* checks for dependences among options */

  return error_occurred;
}


static char *package_name = 0;

/**
 * @brief updates an option
 * @param field the generic pointer to the field to update
 * @param orig_field the pointer to the orig field
 * @param field_given the pointer to the number of occurrence of this option
 * @param prev_given the pointer to the number of occurrence already seen
 * @param value the argument for this option (if null no arg was specified)
 * @param possible_values the possible values for this option (if specified)
 * @param default_value the default value (in case the option only accepts fixed values)
 * @param arg_type the type of this option
 * @param check_ambiguity @see cmdline_parser_params.check_ambiguity
 * @param override @see cmdline_parser_params.override
 * @param no_free whether to free a possible previous value
 * @param multiple_option whether this is a multiple option
 * @param long_opt the corresponding long option
 * @param short_opt the corresponding short option (or '-' if none)
 * @param additional_error possible further error specification
 */
static
int update_arg(void *field, char **orig_field,
               unsigned int *field_given, unsigned int *prev_given,
               char *value, const char *possible_values[],
               const char *default_value,
               cmdline_parser_arg_type arg_type,
               int check_ambiguity, int override,
               int no_free, int multiple_option,
               const char *long_opt, char short_opt,
               const char *additional_error)
{
  char *stop_char = 0;
  const char *val = value;
  int found;
  char **string_field;
  FIX_UNUSED (field);
  FIX_UNUSED (stop_char);
  FIX_UNUSED (val);

  found = 0;

  if (!multiple_option && prev_given && (*prev_given || (check_ambiguity && *field_given)))
    {
      if (short_opt != '-')
        fprintf (stderr, "%s: `--%s' (`-%c') option given more than once%s\n",
               package_name, long_opt, short_opt,
               (additional_error ? additional_error : ""));
      else
        fprintf (stderr, "%s: `--%s' option given more than once%s\n",
               package_name, long_opt,
               (additional_error ? additional_error : ""));
      return 1; /* failure */
    }

  if (possible_values && (found = check_possible_values((value ? value : default_value), possible_values)) < 0)
    {
      if (short_opt != '-')
        fprintf (stderr, "%s: %s argument, \"%s\", for option `--%s' (`-%c')%s\n",
          package_name, (found == -2) ? "ambiguous" : "invalid", value, long_opt, short_opt,
          (additional_error ? additional_error : ""));
      else
        fprintf (stderr, "%s: %s argument, \"%s\", for option `--%s'%s\n",
          package_name, (found == -2) ? "ambiguous" : "invalid", value, long_opt,
          (additional_error ? additional_error : ""));
      return 1; /* failure */
    }

  if (field_given && *field_given && ! override)
    return 0;
  if (prev_given)
    (*prev_given)++;
  if (field_given)
    (*field_given)++;
  if (possible_values)
    val = possible_values[found];

  switch(arg_type) {
  case ARG_FLAG:
    *((int *)field) = !*((int *)field);
    break;
  case ARG_INT:
    if (val) *((int *)field) = strtol (val, &stop_char, 0);
    break;
  case ARG_STRING:
    if (val) {
      string_field = (char **)field;
      if (!no_free && *string_field)
        free (*string_field); /* free previous string */
      *string_field = gengetopt_strdup (val);
    }
    break;
  default:
    break;
  };

  /* check numeric conversion */
  switch(arg_type) {
  case ARG_INT:
    if (val && !(stop_char && *stop_char == '\0')) {
      fprintf(stderr, "%s: invalid numeric value: %s\n", package_name, val);
      return 1; /* failure */
    }
    break;
  default:
    ;
  };

  /* store the original value */
  switch(arg_type) {
  case ARG_NO:
  case ARG_FLAG:
    break;
  default:
    if (value && orig_field) {
      if (no_free) {
        *orig_field = value;
      } else {
        if (*orig_field)
          free (*orig_field); /* free previous string */
        *orig_field = gengetopt_strdup (value);
      }
    }
  };

  return 0; /* OK */
}


int
cmdline_parser_internal (
  int argc, char **argv, struct gengetopt_args_info *args_info,
                        struct cmdline_parser_params *params, const char *additional_error)
{
  int c;	/* Character of the parsed option.  */

  int error_occurred = 0;
  struct gengetopt_args_info local_args_info;

  int override;
  int initialize;
  int check_required;
  int check_ambiguity;

  package_name = argv[0];

  override = params->override;
  initialize = params->initialize;
  check_required = params->check_required;
  check_ambiguity = params->check_ambiguity;

  if (initialize)
    cmdline_parser_init (args_info);

  cmdline_parser_init (&local_args_info);

  optarg = 0;
  optind = 0;
  opterr = params->print_errors;
  optopt = '?';

  while (1)
    {
      int option_index = 0;

      static struct option long_options[] = {
        { "help",	0, NULL, 'h' },
        { "version",	0, NULL, 'V' },
        { "iPwdList",	1, NULL, 0 },
        { "cPout",	1, NULL, 'c' },
        { "iPout",	1, NULL, 'i' },
        { "ePout",	1, NULL, 'e' },
        { "lenout",	1, NULL, 'l' },
        { "config",	1, NULL, 'C' },
        { "prefix",	1, NULL, 'p' },
        { "suffix",	1, NULL, 's' },
        { "datefix",	0, NULL, 'd' },
        { "ngram",	1, NULL, 'n' },
        { "maxLevel",	1, NULL, 'm' },
        { "alphabet",	1, NULL, 'a' },
        { "fAlphabet",	1, NULL, 'A' },
        { "smoothing",	1, NULL, 'S' },
        { "verbose",	0, NULL, 'v' },
        { "verboseFile",	0, NULL, 'F' },
        { "printWarnings",	0, NULL, 'w' },
        { "withCount",	0, NULL, 'u' },
        { 0,  0, 0, 0 }
      };

      c = getopt_long (argc, argv, "hVc:i:e:l:C:p:s:dn:m:a:A:S:vFwu", long_options, &option_index);

      if (c == -1) break;	/* Exit from `while (1)' loop.  */

      switch (c)
        {
        case 'h':	/* Print help and exit.  */
          cmdline_parser_print_help ();
          cmdline_parser_free (&local_args_info);
          exit (EXIT_SUCCESS);

        case 'V':	/* Print version and exit.  */
          cmdline_parser_print_version ();
          cmdline_parser_free (&local_args_info);
          exit (EXIT_SUCCESS);

        case 'c':	/* Changes output filename for conditional probabilities..  */


          if (update_arg( (void *)&(args_info->cPout_arg),
               &(args_info->cPout_orig), &(args_info->cPout_given),
              &(local_args_info.cPout_given), optarg, 0, "CP", ARG_STRING,
              check_ambiguity, override, 0, 0,
              "cPout", 'c',
              additional_error))
            goto failure;

          break;
        case 'i':	/* Changes output filename for initial probabilities..  */


          if (update_arg( (void *)&(args_info->iPout_arg),
               &(args_info->iPout_orig), &(args_info->iPout_given),
              &(local_args_info.iPout_given), optarg, 0, "IP", ARG_STRING,
              check_ambiguity, override, 0, 0,
              "iPout", 'i',
              additional_error))
            goto failure;

          break;
        case 'e':	/* Changes output filename for end probabilities.  */


          if (update_arg( (void *)&(args_info->ePout_arg),
               &(args_info->ePout_orig), &(args_info->ePout_given),
              &(local_args_info.ePout_given), optarg, 0, "EP", ARG_STRING,
              check_ambiguity, override, 0, 0,
              "ePout", 'e',
              additional_error))
            goto failure;

          break;
        case 'l':	/* Changes output filename for password lengths levels.  */


          if (update_arg( (void *)&(args_info->lenout_arg),
               &(args_info->lenout_orig), &(args_info->lenout_given),
              &(local_args_info.lenout_given), optarg, 0, "LN", ARG_STRING,
              check_ambiguity, override, 0, 0,
              "lenout", 'l',
              additional_error))
            goto failure;

          break;
        case 'C':	/* Changes config filename.  */


          if (update_arg( (void *)&(args_info->config_arg),
               &(args_info->config_orig), &(args_info->config_given),
              &(local_args_info.config_given), optarg, 0, "createConfig", ARG_STRING,
              check_ambiguity, override, 0, 0,
              "config", 'C',
              additional_error))
            goto failure;

          break;
        case 'p':	/* Adds given prefix to all output files.  */


          if (update_arg( (void *)&(args_info->prefix_arg),
               &(args_info->prefix_orig), &(args_info->prefix_given),
              &(local_args_info.prefix_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "prefix", 'p',
              additional_error))
            goto failure;

          break;
        case 's':	/* Adds given suffix to all output files.  */


          if (update_arg( (void *)&(args_info->suffix_arg),
               &(args_info->suffix_orig), &(args_info->suffix_given),
              &(local_args_info.suffix_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "suffix", 's',
              additional_error))
            goto failure;

          break;
        case 'd':	/* Adds the current date and time as suffix to all output files.  */


          if (update_arg((void *)&(args_info->datefix_flag), 0, &(args_info->datefix_given),
              &(local_args_info.datefix_given), optarg, 0, 0, ARG_FLAG,
              check_ambiguity, override, 1, 0, "datefix", 'd',
              additional_error))
            goto failure;

          break;
        case 'n':	/* Changes the size of the nGram n.  */


          if (update_arg( (void *)&(args_info->ngram_arg),
               &(args_info->ngram_orig), &(args_info->ngram_given),
              &(local_args_info.ngram_given), optarg, cmdline_parser_ngram_values, "4", ARG_INT,
              check_ambiguity, override, 0, 0,
              "ngram", 'n',
              additional_error))
            goto failure;

          break;
        case 'm':	/* Changes the maximum level in range 2 to 101.  */


          if (update_arg( (void *)&(args_info->maxLevel_arg),
               &(args_info->maxLevel_orig), &(args_info->maxLevel_given),
              &(local_args_info.maxLevel_given), optarg, 0, "11", ARG_INT,
              check_ambiguity, override, 0, 0,
              "maxLevel", 'm',
              additional_error))
            goto failure;

          break;
        case 'a':	/* Changes the used alphabet to the given <string>.  */


          if (update_arg( (void *)&(args_info->alphabet_arg),
               &(args_info->alphabet_orig), &(args_info->alphabet_given),
              &(local_args_info.alphabet_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "alphabet", 'a',
              additional_error))
            goto failure;

          break;
        case 'A':	/* Changes the used alphabet to the alphabet found in <filename>..  */


          if (update_arg( (void *)&(args_info->fAlphabet_arg),
               &(args_info->fAlphabet_orig), &(args_info->fAlphabet_given),
              &(local_args_info.fAlphabet_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "fAlphabet", 'A',
              additional_error))
            goto failure;

          break;
        case 'S':	/* Changes the used smoothing function to the one defined in <filename>..  */


          if (update_arg( (void *)&(args_info->smoothing_arg),
               &(args_info->smoothing_orig), &(args_info->smoothing_given),
              &(local_args_info.smoothing_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "smoothing", 'S',
              additional_error))
            goto failure;

          break;
        case 'v':	/* Gain information about settings and results during run time..  */


          if (update_arg((void *)&(args_info->verbose_flag), 0, &(args_info->verbose_given),
              &(local_args_info.verbose_given), optarg, 0, 0, ARG_FLAG,
              check_ambiguity, override, 1, 0, "verbose", 'v',
              additional_error))
            goto failure;

          break;
        case 'F':	/* Gain detailed information in the output files..  */


          if (update_arg((void *)&(args_info->verboseFile_flag), 0, &(args_info->verboseFile_given),
              &(local_args_info.verboseFile_given), optarg, 0, 0, ARG_FLAG,
              check_ambiguity, override, 1, 0, "verboseFile", 'F',
              additional_error))
            goto failure;

          break;
        case 'w':	/* Prints any warning (if verbose mode is active)..  */


          if (update_arg((void *)&(args_info->printWarnings_flag), 0, &(args_info->printWarnings_given),
              &(local_args_info.printWarnings_given), optarg, 0, 0, ARG_FLAG,
              check_ambiguity, override, 1, 0, "printWarnings", 'w',
              additional_error))
            goto failure;

          break;
        case 'u':	/* The given password list is counted (like this: #count password)..  */


          if (update_arg((void *)&(args_info->withCount_flag), 0, &(args_info->withCount_given),
              &(local_args_info.withCount_given), optarg, 0, 0, ARG_FLAG,
              check_ambiguity, override, 1, 0, "withCount", 'u',
              additional_error))
            goto failure;

          break;

        case 0:	/* Long option with no short option */
          /* Password list to create nGrams..  */
          if (strcmp (long_options[option_index].name, "iPwdList") == 0)
          {


            if (update_arg( (void *)&(args_info->iPwdList_arg),
                 &(args_info->iPwdList_orig), &(args_info->iPwdList_given),
                &(local_args_info.iPwdList_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "iPwdList", '-',
                additional_error))
              goto failure;

          }

          break;
        case '?':	/* Invalid option.  */
          /* `getopt_long' already printed an error message.  */
          goto failure;

        default:	/* bug: option not considered.  */
          fprintf (stderr, "%s: option unknown: %c%s\n", CMDLINE_PARSER_PACKAGE, c, (additional_error ? additional_error : ""));
          abort ();
        } /* switch */
    } /* while */



  if (check_required)
    {
      error_occurred += cmdline_parser_required2 (args_info, argv[0], additional_error);
    }

  cmdline_parser_release (&local_args_info);

  if ( error_occurred )
    return (EXIT_FAILURE);

  return 0;

failure:

  cmdline_parser_release (&local_args_info);
  return (EXIT_FAILURE);
}
