/*
 * Decompiled with CFR 0.152.
 */
package websphinx.workbench;

import java.awt.Event;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.MemoryImageSource;
import java.util.Hashtable;
import java.util.Vector;
import rcm.awt.ClosableFrame;
import rcm.awt.Colors;
import symantec.itools.awt.TreeNode;
import symantec.itools.awt.TreeView;
import websphinx.CrawlEvent;
import websphinx.CrawlListener;
import websphinx.Crawler;
import websphinx.Link;
import websphinx.LinkEvent;
import websphinx.LinkListener;
import websphinx.Page;
import websphinx.workbench.LinkViewEvent;
import websphinx.workbench.LinkViewListener;
import websphinx.workbench.WorkbenchControlPanel;

public class WebOutline
extends TreeView
implements CrawlListener,
LinkListener {
    Hashtable links = new Hashtable();
    static final int NO_LINKS = 0;
    static final int RETRIEVED_LINKS = 1;
    static final int WALKED_LINKS = 2;
    static final int TREE_LINKS = 3;
    static final int ALL_LINKS = 4;
    int defaultFilter = 1;
    static final int TITLE = 0;
    static final int ABSOLUTE_URL = 1;
    static final int RELATIVE_URL = 2;
    int defaultRendering = 0;
    private Vector listeners = new Vector();
    Hashtable icons = new Hashtable();
    Image pageIcon;
    Image linkIcon;
    Image retrievingIcon;
    Image errorIcon;
    public static Image defaultPageIcon;
    public static Image defaultLinkIcon;
    public static Image defaultRetrievingIcon;
    public static Image defaultErrorIcon;
    static int errorWidth;
    static int errorHeight;
    static int[] errorData;
    static int linkWidth;
    static int linkHeight;
    static int[] linkData;
    static int retrieveWidth;
    static int retrieveHeight;
    static int[] retrieveData;
    static int pageWidth;
    static int pageHeight;
    static int[] pageData;

    public WebOutline() {
        this.setPageIcon(defaultPageIcon);
        this.setLinkIcon(defaultRetrievingIcon);
        this.setRetrievingIcon(defaultRetrievingIcon);
        this.setErrorIcon(defaultErrorIcon);
    }

    public void showControlPanel() {
        new WorkbenchControlPanel(null, this).show();
    }

    public synchronized void clear() {
        super.clear();
        this.links.clear();
    }

    public void started(CrawlEvent event) {
    }

    public void stopped(CrawlEvent event) {
    }

    public void cleared(CrawlEvent event) {
        this.clear();
    }

    public void timedOut(CrawlEvent event) {
    }

    public void paused(CrawlEvent event) {
    }

    public void crawled(LinkEvent event) {
        this.update(event.getLink());
    }

    synchronized void setLinkFilter(int filter) {
        if (filter == this.defaultFilter) {
            return;
        }
        int old = this.defaultFilter;
        this.defaultFilter = filter;
        this.reFilter(this.getRootNode(), old > filter);
        this.triggerRedraw();
    }

    void reFilter(TreeNode n, boolean restrict) {
        while (n != null) {
            TreeNode c;
            Link link = (Link)n.getDataObject();
            Page page = link.getPage();
            if (page != null) {
                int j;
                Link[] linkarray = page.getLinks();
                if (restrict) {
                    j = 0;
                    while (j < linkarray.length) {
                        TreeNode child;
                        if (!this.shouldDisplay(linkarray[j].getStatus()) && (child = this.findNode(linkarray[j])) != null) {
                            this.remove(child);
                        }
                        ++j;
                    }
                } else {
                    j = 0;
                    while (j < linkarray.length) {
                        this.update(linkarray[j]);
                        ++j;
                    }
                }
            }
            if ((c = n.getChild()) != null) {
                this.reFilter(c, restrict);
            }
            n = n.getSibling();
        }
    }

    boolean shouldDisplay(int status) {
        switch (status) {
            case 3: 
            case 4: {
                return this.defaultFilter > 1;
            }
            case 1: {
                return this.defaultFilter > 2;
            }
            case 2: {
                return false;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    synchronized void setNodeRendering(int r) {
        this.defaultRendering = r;
        this.reRender(this.getRootNode());
        this.triggerRedraw();
    }

    void reRender(TreeNode n) {
        while (n != null) {
            this.update(n);
            TreeNode c = n.getChild();
            if (c != null) {
                this.reRender(c);
            }
            n = n.getSibling();
        }
    }

    public void updateClosure(Link[] links) {
        if (links == null) {
            return;
        }
        int i = 0;
        while (i < links.length) {
            Link link = links[i];
            int status = link.getStatus();
            if (status != 0) {
                Page page;
                this.update(link);
                if ((status == 7 || status == 8) && (page = link.getPage()) != null) {
                    this.updateClosure(page.getLinks());
                }
            }
            ++i;
        }
    }

    public synchronized void update(Link link) {
        if (!this.shouldDisplay(link.getStatus())) {
            return;
        }
        TreeNode n = this.findNode(link);
        if (n == null) {
            this.add(link);
        } else {
            this.update(n);
        }
        this.redraw();
    }

    synchronized void add(Link link) {
        TreeNode n = new TreeNode("");
        n.setDataObject(link);
        Page source = link.getSource();
        Link origin = source.getOrigin();
        TreeNode parent = this.findNode(origin);
        if (parent == null) {
            this.update(n);
            this.append(n);
        } else {
            this.update(n);
            this.insert(n, parent, 0);
            parent.expand();
        }
        this.links.put(link, n);
    }

    void update(TreeNode n) {
        Link link = (Link)n.getDataObject();
        Page page = link.getPage();
        int status = link.getStatus();
        Image icon = this.getIcon(LinkEvent.eventName[status]);
        n.setExpandedImage(icon);
        n.setCollapsedImage(icon);
        if (page == null) {
            String name = "";
            switch (this.defaultRendering) {
                case 0: 
                case 1: {
                    name = link.getURL().toString();
                    break;
                }
                case 2: {
                    Link origin = link.getSource().getOrigin();
                    if (origin != null) {
                        name = Link.relativeTo(origin.getURL(), link.getURL());
                        break;
                    }
                    name = link.getURL().toString();
                    break;
                }
            }
            n.setText(name);
            n.setColor(Colors.parseColor(link.getLabel("Workbench.color")));
        } else {
            String name = "";
            switch (this.defaultRendering) {
                case 0: {
                    name = page.getTitle();
                    if (name != null) break;
                    name = link.getURL().toString();
                    break;
                }
                case 1: {
                    name = link.getURL().toString();
                    break;
                }
                case 2: {
                    Link origin = link.getSource().getOrigin();
                    if (origin != null) {
                        name = Link.relativeTo(origin.getURL(), link.getURL());
                        break;
                    }
                    name = link.getURL().toString();
                    break;
                }
            }
            n.setText(name);
            n.setColor(Colors.parseColor(page.getLabel("Workbench.color")));
        }
    }

    TreeNode findNode(Link l) {
        if (l == null) {
            return null;
        }
        return (TreeNode)this.links.get(l);
    }

    public void addLinkViewListener(LinkViewListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.addElement(listener);
        }
    }

    public void removeLinkViewListener(CrawlListener listener) {
        this.listeners.removeElement(listener);
    }

    void fireEvent(Link link) {
        LinkViewEvent event = new LinkViewEvent(this, link);
        int j = 0;
        int len = this.listeners.size();
        while (j < len) {
            LinkViewListener listen = (LinkViewListener)this.listeners.elementAt(j);
            listen.viewLink(event);
            ++j;
        }
    }

    public boolean handleEvent(Event event) {
        if (event.id == 1001) {
            TreeNode n = this.getSelectedNode();
            if (n != null) {
                this.fireEvent((Link)n.getDataObject());
            }
        } else if (event.id == 501 && event.metaDown()) {
            this.showControlPanel();
        } else {
            return super.handleEvent(event);
        }
        return true;
    }

    public Link getSelectedLink() {
        TreeNode n = this.getSelectedNode();
        if (n != null) {
            return (Link)n.getDataObject();
        }
        return null;
    }

    public static Frame monitor(Crawler crawler) {
        ClosableFrame win = new ClosableFrame("Outline: " + crawler.getName());
        WebOutline g = new WebOutline();
        crawler.addCrawlListener(g);
        crawler.addLinkListener(g);
        win.add("Center", g);
        win.pack();
        win.show();
        return win;
    }

    public Image getIcon(String name) {
        return (Image)this.icons.get(name);
    }

    public void setIcon(String name, Image icon) {
        if (icon != null) {
            this.icons.put(name, icon);
        } else {
            this.icons.remove(name);
        }
    }

    public void setPageIcon(Image icon) {
        this.pageIcon = icon;
        this.setIcon(LinkEvent.eventName[8], icon);
    }

    public void setLinkIcon(Image icon) {
        this.linkIcon = icon;
        this.setIcon(LinkEvent.eventName[4], icon);
        this.setIcon(LinkEvent.eventName[2], icon);
        this.setIcon(LinkEvent.eventName[1], icon);
    }

    public void setRetrievingIcon(Image icon) {
        this.retrievingIcon = icon;
        this.setIcon(LinkEvent.eventName[5], icon);
        this.setIcon(LinkEvent.eventName[7], icon);
    }

    public void setErrorIcon(Image icon) {
        this.errorIcon = icon;
        this.setIcon(LinkEvent.eventName[6], icon);
    }

    static {
        NO_LINKS = 0;
        RETRIEVED_LINKS = 1;
        WALKED_LINKS = 2;
        TREE_LINKS = 3;
        ALL_LINKS = 4;
        TITLE = 0;
        ABSOLUTE_URL = 1;
        RELATIVE_URL = 2;
        errorWidth = 16;
        errorHeight = 16;
        errorData = new int[]{0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, -261116, -261116, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, -261116, -261116, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, -261116, -261116, -261116, 0xFFFFFF, 0xFFFFFF, -261116, -261116, -261116, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, -261116, -261116, -261116, -261116, -261116, -261116, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, -261116, -261116, -261116, -261116, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, -261116, -261116, -261116, -261116, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, -261116, -261116, -261116, -261116, -261116, -261116, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, -261116, -261116, -261116, 0xFFFFFF, 0xFFFFFF, -261116, -261116, -261116, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, -261116, -261116, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, -261116, -261116, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF};
        linkWidth = 16;
        linkHeight = 16;
        linkData = new int[]{0xFCFCFC, 0xFCFCFC, 0xFCFCFC, 0xFCFCFC, 0xFCFCFC, 0xFCFCFC, 0xFCFCFC, 0xFCFCFC, 0xFCFCFC, 0xFCFCFC, 0xFCFCFC, 0xFCFCFC, 0xFCFCFC, -13355932, -13355932, 0xFCFCFC, 0xFCFCFC, 0xFCFCFC, 0xFCFCFC, 0xFCFCFC, 0xFCFCFC, 0xFCFCFC, 0xFCFCFC, 0xFCFCFC, 0xFCFCFC, 0xFCFCFC, 0xFCFCFC, -13355932, -13355932, -2829060, -3881788, -13355932, 0xFCFCFC, 0xFCFCFC, 0xFCFCFC, 0xFCFCFC, 0xFCFCFC, 0xFCFCFC, 0xFCFCFC, -13355932, -13355932, -13355932, -13355932, -2829060, -2829060, -3881788, -10197812, -13355932, 0xFCFCFC, 0xFCFCFC, 0xFCFCFC, 0xFCFCFC, 0xFCFCFC, 0xFCFCFC, -13355932, -3355396, -8092540, -13355932, -2829060, -8092540, -8092540, -10197812, -13355932, 0xFCFCFC, 0xFCFCFC, 0xFCFCFC, 0xFCFCFC, 0xFCFCFC, -13355932, -13355932, -2829060, -3881788, -13355932, -2829060, -3881788, -10197812, -10197812, -13355932, 0xFCFCFC, 0xFCFCFC, 0xFCFCFC, 0xFCFCFC, 0xFCFCFC, 0xFCFCFC, -13355932, -13355932, -2829060, -3881788, -13355932, -2829060, -3881788, -10197812, -10197812, -13355932, 0xFCFCFC, 0xFCFCFC, 0xFCFCFC, 0xFCFCFC, 0xFCFCFC, -13355932, -3355396, -2829060, -3881788, -13355932, -13355932, -10197812, -10197812, -13355932, -13355932, -13355932, 0xFCFCFC, 0xFCFCFC, 0xFCFCFC, 0xFCFCFC, -13355932, -2829060, -3881788, -3881788, -13355932, 0xFCFCFC, 0xFCFCFC, -13355932, -13355932, -2829060, -3355396, -13355932, 0xFCFCFC, 0xFCFCFC, 0xFCFCFC, -13355932, -3355396, -3881788, -13355932, -13355932, 0xFCFCFC, 0xFCFCFC, -16514044, -13355932, -3355396, -3881788, -3881788, -13355932, 0xFCFCFC, 0xFCFCFC, 0xFCFCFC, -13355932, -16514044, -13355932, -13355932, -13355932, 0xFCFCFC, -16514044, -13355932, -3355396, -3881788, -13355932, -13355932, 0xFCFCFC, 0xFCFCFC, 0xFCFCFC, 0xFCFCFC, -13355932, -13355932, -2829060, -3881788, -3881788, -13355932, -13355932, -3355396, -3881788, -13355932, 0xFCFCFC, 0xFCFCFC, 0xFCFCFC, 0xFCFCFC, 0xFCFCFC, 0xFCFCFC, -13355932, -3355396, -16514044, -10197812, -10197812, -13355932, -3355396, -16514044, -13355932, 0xFCFCFC, 0xFCFCFC, 0xFCFCFC, 0xFCFCFC, 0xFCFCFC, 0xFCFCFC, 0xFCFCFC, -13355932, -3355396, -16514044, -10197812, -10197812, -13355932, -3355396, -16514044, -13355932, 0xFCFCFC, 0xFCFCFC, 0xFCFCFC, 0xFCFCFC, 0xFCFCFC, 0xFCFCFC, -13355932, -3355396, -3881788, -10197812, -13355932, -13355932, -3355396, -3881788, -13355932, 0xFCFCFC, 0xFCFCFC, 0xFCFCFC, 0xFCFCFC, 0xFCFCFC, 0xFCFCFC, 0xFCFCFC, -13355932, -16514044, -10197812, -13355932, -13355932, -13355932, -13355932, -13355932, 0xFCFCFC, 0xFCFCFC, 0xFCFCFC, 0xFCFCFC, 0xFCFCFC, 0xFCFCFC, 0xFCFCFC, 0xFCFCFC, -13355932, -13355932, -13355932, 0xFCFCFC, 0xFCFCFC, 0xFCFCFC, 0xFCFCFC, 0xFCFCFC, 0xFCFCFC, 0xFCFCFC, 0xFCFCFC, 0xFCFCFC, 0xFCFCFC, 0xFCFCFC, 0xFCFCFC, 0xFCFCFC};
        retrieveWidth = 16;
        retrieveHeight = 16;
        retrieveData = new int[]{0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, -16744448, -16744448, -16744448, -16744448, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, -16744448, -16744448, -16744448, -16744448, -16744448, -16744448, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, -16744448, -16744448, -16744448, -16744448, -16744448, -16744448, -16744448, -16744448, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, -16744448, -16744448, -16744448, -16744448, -16744448, -16744448, -16744448, -16744448, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, -16744448, -16744448, -16744448, -16744448, -16744448, -16744448, -16744448, -16744448, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, -16744448, -16744448, -16744448, -16744448, -16744448, -16744448, -16744448, -16744448, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, -16744448, -16744448, -16744448, -16744448, -16744448, -16744448, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, -16744448, -16744448, -16744448, -16744448, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF};
        pageWidth = 16;
        pageHeight = 16;
        pageData = new int[]{65535, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, 65535, 65535, 65535, 65535, 65535, -13355980, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -13355980, -1, -16777216, 65535, 65535, 65535, 65535, -13355980, -197380, -13355980, -13355980, -13355980, -13355980, -13355980, -197380, -197380, -13355980, -1, -1, -13355980, 65535, 65535, 65535, -13355980, -197380, -13355980, -209868, -209868, -10171140, -10171140, -197380, -197380, -13355980, -1, -1, -1, -13355980, 65535, 65535, -13355980, -197380, -13355980, -10171140, -10171140, -10171140, -10171140, -197380, -197380, -16514044, -16514044, -16514044, -16514044, -16514044, 65535, 65535, -13355980, -197380, -13355980, -6527948, -6527948, -6527948, -6527948, -197380, -197380, -197380, -197380, -1, -16777216, -6513508, 65535, 65535, -13355980, -197380, -13355980, -6527948, -6527948, -6527948, -6527948, -197380, -197380, -197380, -197380, -197380, -16777216, -6513508, 65535, 65535, -13355980, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -16777216, -6513508, 65535, 65535, -13355980, -197380, -16514044, -16514044, -16514044, -16514044, -16514044, -16514044, -16514044, -16514044, -16514044, -197380, -16777216, -6513508, 65535, 65535, -13355980, -197380, -1, -1, -1, -1, -1, -1, -1, -1, -1, -197380, -16777216, -6513508, 65535, 65535, -13355980, -1, -1, -197380, -248780, -197380, -16514044, -16514044, -16514044, -16514044, -16514044, -197380, -16777216, -6513508, 65535, 65535, -13355980, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -197380, -16777216, -6513508, 65535, 65535, -13355980, -197380, -197380, -197380, -248780, -197380, -16777216, -16777216, -16514044, -16514044, -16514044, -197380, -16777216, -6513508, 65535, 65535, -13355980, -197380, -197380, -1, -1, -1, -1, -1, -1, -1, -1, -197380, -16777216, -6513508, 65535, 65535, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -6513508, 65535, 65535, 65535, -6513508, -6513508, -6513508, -6513508, -6513508, -6513508, -6513508, -6513508, -6513508, -6513508, -6513508, -6513508, 65535, 65535};
        Toolkit tkit = Toolkit.getDefaultToolkit();
        defaultPageIcon = tkit.createImage(new MemoryImageSource(pageWidth, pageHeight, pageData, 0, pageWidth));
        defaultLinkIcon = tkit.createImage(new MemoryImageSource(linkWidth, linkHeight, linkData, 0, linkWidth));
        defaultRetrievingIcon = tkit.createImage(new MemoryImageSource(retrieveWidth, retrieveHeight, retrieveData, 0, retrieveWidth));
        defaultErrorIcon = tkit.createImage(new MemoryImageSource(errorWidth, errorHeight, errorData, 0, errorWidth));
    }
}

