/*
 * Decompiled with CFR 0.152.
 */
package websphinx.workbench;

import java.awt.Button;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Toolkit;
import java.text.NumberFormat;
import rcm.awt.BorderPanel;
import rcm.awt.ClosableFrame;
import rcm.util.Mem;
import websphinx.CrawlEvent;
import websphinx.CrawlListener;
import websphinx.Crawler;

public class Statistics
extends Panel
implements CrawlListener,
Runnable {
    Crawler crawler;
    Thread thread;
    boolean running = false;
    static final int PAGES_PER_SEC_DECIMAL_PLACES = 1;
    static final NumberFormat fmtPagesPerSec;
    String runningTime;
    String activeThreads;
    String linksTested;
    String pagesVisited;
    String pagesPerSec;
    String pagesLeft;
    String memoryUsed;
    String memoryMaxUsed;
    Button refreshButton;
    long msecTotal;
    long timeLastUpdate = -1L;
    long kbMaxUsed;
    Image offscreen;
    Dimension offSize;
    Graphics offg;
    FontMetrics fm;
    Dimension minSize = new Dimension();
    static final int GUTTER = 5;
    Dimension cached;

    public Statistics() {
        this.setLayout(null);
        this.refreshButton = new Button("Refresh");
        this.add(this.refreshButton);
        this.update();
        this.measureFields();
    }

    public synchronized void layout() {
        Dimension d = this.refreshButton.preferredSize();
        int x = 0;
        int y = this.minSize.height;
        int w = d.width;
        int h = d.height;
        this.refreshButton.reshape(x, y, w, h);
    }

    public Dimension minimumSize() {
        Dimension d = new Dimension(this.minSize);
        d.height += this.refreshButton.preferredSize().height;
        return d;
    }

    public Dimension preferredSize() {
        return this.minimumSize();
    }

    public synchronized void update(Graphics g) {
        this.paint(g);
    }

    void createOffscreenArea(Dimension d) {
        this.offSize = new Dimension(d.width > 0 ? d.width : 1, d.height > 0 ? d.height : 1);
        this.offscreen = this.createImage(this.offSize.width, this.offSize.height);
        this.offg = this.offscreen.getGraphics();
        this.offg.setFont(this.getFont());
        this.fm = this.offg.getFontMetrics();
    }

    int drawField(Graphics g, int y, String caption, String value) {
        int cW = this.fm.stringWidth(caption);
        int vW = this.fm.stringWidth(value);
        this.minSize.width = Math.max(this.minSize.width, cW + vW + 10);
        g.drawString(caption, 0, y += this.fm.getAscent());
        g.drawString(value, this.offSize.width - this.fm.stringWidth(value), y);
        return this.fm.getHeight();
    }

    void drawFields(Graphics g) {
        int y = 0;
        int gutter = 5;
        y += gutter;
        y += this.drawField(this.offg, y, "Running time:", this.runningTime);
        y += this.drawField(this.offg, y, "Active threads:", this.activeThreads);
        y += gutter * 2;
        y += this.drawField(this.offg, y, "Links tested:", this.linksTested);
        y += this.drawField(this.offg, y, "Links in queue:", this.pagesLeft);
        y += gutter * 2;
        y += this.drawField(this.offg, y, "Pages visited:", this.pagesVisited);
        y += this.drawField(this.offg, y, "Pages/sec:", this.pagesPerSec);
        y += gutter * 2;
        y += this.drawField(this.offg, y, "Memory in use:", this.memoryUsed);
        y += this.drawField(this.offg, y, "Max memory used:", this.memoryMaxUsed);
        this.minSize.height = y += gutter;
    }

    int measureField(FontMetrics fm, String caption, String value) {
        int cW = fm.stringWidth(caption);
        int vW = fm.stringWidth("00000000");
        this.minSize.width = Math.max(this.minSize.width, cW + vW + 10);
        return fm.getHeight();
    }

    void measureFields() {
        Font font = this.getFont();
        if (font == null) {
            font = new Font("Helvetica", 0, 12);
        }
        FontMetrics fm = Toolkit.getDefaultToolkit().getFontMetrics(font);
        this.minSize = new Dimension();
        int y = 0;
        y += 5;
        y += this.measureField(fm, "Running time:", this.runningTime);
        y += this.measureField(fm, "Active threads:", this.activeThreads);
        y += 10;
        y += this.measureField(fm, "Links tested:", this.linksTested);
        y += this.measureField(fm, "Links in queue:", this.pagesLeft);
        y += 10;
        y += this.measureField(fm, "Pages visited:", this.pagesVisited);
        y += this.measureField(fm, "Pages/sec:", this.pagesPerSec);
        y += 10;
        y += this.measureField(fm, "Memory in use:", this.memoryUsed);
        y += this.measureField(fm, "Max memory used:", this.memoryMaxUsed);
        this.minSize.height = y += 5;
    }

    public synchronized void paint(Graphics g) {
        Dimension d = this.size();
        if (this.cached == null || d.width != this.cached.width || d.height != this.cached.height) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, d.width, d.height);
            this.cached = d;
        }
        if (this.offscreen == null) {
            this.createOffscreenArea(this.minSize);
        }
        this.offg.setColor(this.getBackground());
        this.offg.fillRect(0, 0, this.offSize.width, this.offSize.height);
        this.offg.setColor(this.getForeground());
        this.drawFields(this.offg);
        g.drawImage(this.offscreen, 0, 0, null);
    }

    public boolean handleEvent(Event event) {
        if (event.target != this.refreshButton || event.id != 1001) {
            return super.handleEvent(event);
        }
        Mem.gc();
        this.update();
        return true;
    }

    public synchronized void clear() {
        this.msecTotal = 0L;
        this.timeLastUpdate = -1L;
        this.update();
    }

    public synchronized void update() {
        int nThreads;
        int pL;
        int pV;
        int lT;
        long now = System.currentTimeMillis();
        if (this.running) {
            if (this.timeLastUpdate != -1L) {
                this.msecTotal += now - this.timeLastUpdate;
            }
            this.timeLastUpdate = now;
        }
        if (this.crawler != null) {
            lT = this.crawler.getLinksTested();
            pV = this.crawler.getPagesVisited();
            pL = this.crawler.getPagesLeft();
            nThreads = this.crawler.getActiveThreads();
        } else {
            lT = 0;
            pV = 0;
            pL = 0;
            nThreads = 0;
        }
        long kbUsed = Mem.used() / 1024L;
        this.kbMaxUsed = Math.max(this.kbMaxUsed, kbUsed);
        double pps = this.msecTotal > 0L ? (double)pV * 1000.0 / (double)this.msecTotal : 0.0;
        this.runningTime = Statistics.formatTime(this.msecTotal);
        this.activeThreads = String.valueOf(nThreads);
        this.linksTested = String.valueOf(lT);
        this.pagesVisited = String.valueOf(pV);
        this.pagesLeft = String.valueOf(pL);
        this.pagesPerSec = Statistics.formatPagesPerSec(pps);
        this.memoryUsed = kbUsed + " KB";
        this.memoryMaxUsed = this.kbMaxUsed + " KB";
        Graphics g = this.getGraphics();
        if (g != null) {
            this.update(g);
        }
    }

    static String formatTime(long time) {
        int s = (int)(time / 1000L);
        int m = s / 60;
        int h = m / 60;
        int d = h / 24;
        return Statistics.formatTime(d, h %= 24, m %= 60, s %= 60);
    }

    static String formatTime(int d, int h, int m, int s) {
        return (d > 0 ? d + "d " : "") + (h < 10 ? "0" : "") + h + ":" + (m < 10 ? "0" : "") + m + ":" + (s < 10 ? "0" : "") + s;
    }

    static String formatPagesPerSec(double x) {
        String result = fmtPagesPerSec.format(x);
        return result;
    }

    public synchronized void start() {
        this.running = true;
        this.thread = new Thread((Runnable)this, "Statistics");
        this.thread.setDaemon(true);
        this.thread.setPriority(1);
        this.thread.start();
    }

    public synchronized void stop() {
        this.running = false;
        this.thread = null;
        this.timeLastUpdate = -1L;
    }

    public void run() {
        while (true) {
            this.update();
            if (!this.running) break;
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void started(CrawlEvent event) {
        this.crawler = event.getCrawler();
        this.start();
    }

    public synchronized void stopped(CrawlEvent event) {
        if (this.running) {
            this.stop();
        }
    }

    public void cleared(CrawlEvent event) {
        this.clear();
    }

    public void timedOut(CrawlEvent event) {
        this.stop();
    }

    public void paused(CrawlEvent event) {
        this.stop();
    }

    public static Frame monitor(Crawler crawler) {
        ClosableFrame win = new ClosableFrame("Statistics: " + crawler.getName());
        Statistics stats = new Statistics();
        crawler.addCrawlListener(stats);
        win.add("Center", BorderPanel.wrap(stats, 5, 5, 5, 5));
        win.pack();
        win.show();
        return win;
    }

    static {
        PAGES_PER_SEC_DECIMAL_PLACES = 1;
        fmtPagesPerSec = NumberFormat.getInstance();
        fmtPagesPerSec.setMinimumFractionDigits(1);
        fmtPagesPerSec.setMaximumFractionDigits(1);
        GUTTER = 5;
    }
}

