/*
 * Decompiled with CFR 0.152.
 */
package websphinx.workbench;

import rcm.awt.PopupDialog;
import websphinx.Action;
import websphinx.Crawler;
import websphinx.Link;
import websphinx.LinkPredicate;
import websphinx.Page;
import websphinx.PagePredicate;
import websphinx.workbench.Context;
import websphinx.workbench.ScriptException;
import websphinx.workbench.ScriptInterpreter;

public class Script
implements Action,
LinkPredicate,
PagePredicate {
    String script;
    boolean asLinkPredicate;
    transient Crawler crawler;
    transient ScriptInterpreter interp;
    transient Object function;
    static String[] argsLink = new String[]{"crawler", "link"};
    static String[] argsPage = new String[]{"crawler", "page"};

    public Script(String script, boolean asLinkPredicate) {
        this.script = script;
        this.asLinkPredicate = asLinkPredicate;
    }

    public String getScript() {
        return this.script;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Script)) {
            return false;
        }
        Script s = (Script)object;
        return s.script.equals(this.script) && s.asLinkPredicate == this.asLinkPredicate;
    }

    public void connected(Crawler crawler) {
        this.crawler = crawler;
        this.interp = Context.getScriptInterpreter();
        if (this.interp != null) {
            try {
                this.function = this.interp.lambda(this.asLinkPredicate ? argsLink : argsPage, this.script);
            }
            catch (ScriptException e) {
                PopupDialog.warn(null, "Script Error", e.toString());
                this.function = null;
            }
        }
    }

    public void disconnected(Crawler crawler) {
        crawler = null;
        this.interp = null;
        this.function = null;
    }

    public boolean shouldVisit(Link link) {
        try {
            if (this.interp == null || this.function == null) {
                throw new ScriptException("Scripting language is not available");
            }
            Object[] args = new Object[]{this.crawler, link};
            return this.toBool(this.interp.apply(this.function, args));
        }
        catch (ScriptException e) {
            System.err.println(e);
            return false;
        }
    }

    public boolean shouldActOn(Page page) {
        try {
            if (this.interp == null || this.function == null) {
                throw new ScriptException("Scripting language is not available");
            }
            Object[] args = new Object[]{this.crawler, page};
            return this.toBool(this.interp.apply(this.function, args));
        }
        catch (ScriptException e) {
            System.err.println(e);
            return false;
        }
    }

    public void visit(Page page) {
        try {
            if (this.interp == null || this.function == null) {
                throw new ScriptException("Scripting language is not available");
            }
            Object[] args = new Object[]{this.crawler, page};
            this.interp.apply(this.function, args);
        }
        catch (ScriptException e) {
            throw new RuntimeException(e.toString());
        }
    }

    boolean toBool(Object obj) {
        if (!(obj instanceof Boolean)) {
            return false;
        }
        return (Boolean)obj;
    }
}

