/*
 * Decompiled with CFR 0.152.
 */
package websphinx.workbench;

import java.io.File;
import java.io.IOException;
import websphinx.Access;
import websphinx.Action;
import websphinx.CrawlEvent;
import websphinx.CrawlListener;
import websphinx.Crawler;
import websphinx.Page;
import websphinx.Pattern;
import websphinx.PatternMatcher;
import websphinx.RecordTransformer;
import websphinx.Region;
import websphinx.workbench.Browser;
import websphinx.workbench.Context;

public class ExtractAction
implements Action,
CrawlListener {
    Pattern pattern;
    String filename;
    boolean useBrowser;
    boolean textOnly;
    transient File file;
    transient RecordTransformer records;
    transient boolean noFields;

    public ExtractAction(Pattern pattern, boolean useBrowser, String filename, boolean textOnly) {
        this.pattern = pattern;
        this.filename = filename;
        this.useBrowser = useBrowser;
        this.textOnly = textOnly;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ExtractAction)) {
            return false;
        }
        ExtractAction a = (ExtractAction)object;
        return this.same(a.filename, this.filename) && a.useBrowser == this.useBrowser && a.pattern.equals(this.pattern) && a.textOnly == this.textOnly;
    }

    private boolean same(String s1, String s2) {
        if (s1 == null || s2 == null) {
            return s1 == s2;
        }
        return s1.equals(s2);
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public boolean getUseBrowser() {
        return this.useBrowser;
    }

    public String getFilename() {
        return this.filename;
    }

    public boolean getTextOnly() {
        return this.textOnly;
    }

    public void connected(Crawler crawler) {
        crawler.addCrawlListener(this);
    }

    public void disconnected(Crawler crawler) {
        crawler.removeCrawlListener(this);
    }

    private void showit() {
        Browser browser = Context.getBrowser();
        if (browser != null) {
            browser.show(this.file);
        }
    }

    public synchronized void visit(Page page) {
        try {
            int n = 0;
            PatternMatcher m = this.pattern.match(page);
            Region r = m.nextMatch();
            while (r != null) {
                Object[] fields = this.noFields ? new Object[]{r} : (Object[])r.getFields("Pattern.groups");
                this.records.writeRecord(fields, this.textOnly);
                ++n;
                r = m.nextMatch();
            }
            if (n > 0) {
                this.records.flush();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e.toString());
        }
    }

    public synchronized void started(CrawlEvent event) {
        if (this.records == null) {
            try {
                this.file = this.filename != null ? new File(this.filename) : Access.getAccess().makeTemporaryFile("extract", ".html");
                this.records = new RecordTransformer(this.file.toString());
                String[] fieldNames = this.pattern.getFieldNames();
                this.noFields = fieldNames.length == 0;
                this.records.setProlog(this.records.getProlog() + this.makeTableHeader(fieldNames));
            }
            catch (IOException e) {
                System.err.println(e);
            }
        }
    }

    private String makeTableHeader(String[] fieldNames) {
        String result = "<TR>\n<TH>\n";
        if (fieldNames.length == 0) {
            result = result + "<TH>\n";
        } else {
            int i = 0;
            while (i < fieldNames.length) {
                result = result + "<TH>" + fieldNames[i] + "\n";
                ++i;
            }
        }
        return result;
    }

    public synchronized void stopped(CrawlEvent event) {
        try {
            if (this.records != null) {
                this.records.close();
                this.records = null;
                if (this.useBrowser) {
                    this.showit();
                }
            }
        }
        catch (IOException e) {
            System.err.println(e);
        }
    }

    public synchronized void cleared(CrawlEvent event) {
        try {
            if (this.records != null) {
                this.records.close();
                this.records = null;
                if (this.useBrowser) {
                    this.showit();
                }
            }
        }
        catch (IOException e) {
            System.err.println(e);
        }
    }

    public synchronized void timedOut(CrawlEvent event) {
        try {
            this.records.close();
            this.records = null;
            if (this.useBrowser) {
                this.showit();
            }
        }
        catch (IOException e) {
            System.err.println(e);
        }
    }

    public synchronized void paused(CrawlEvent event) {
        try {
            this.records.flush();
            if (this.useBrowser) {
                this.showit();
            }
        }
        catch (IOException e) {
            System.err.println(e);
        }
    }
}

