/*
 * Decompiled with CFR 0.152.
 */
package websphinx.workbench;

import java.io.File;
import java.io.IOException;
import websphinx.Access;
import websphinx.Action;
import websphinx.Concatenator;
import websphinx.CrawlEvent;
import websphinx.CrawlListener;
import websphinx.Crawler;
import websphinx.Page;
import websphinx.workbench.Browser;
import websphinx.workbench.Context;

public class ConcatAction
implements Action,
CrawlListener {
    String filename;
    boolean useBrowser;
    String prolog;
    String header;
    String footer;
    String divider;
    String epilog;
    transient File file;
    transient Concatenator concat;
    private transient boolean oldSync;

    public ConcatAction(String filename, boolean useBrowser) {
        this.filename = filename;
        this.useBrowser = useBrowser;
    }

    public ConcatAction(String filename, boolean useBrowser, String prolog, String header, String footer, String divider, String epilog) {
        this(filename, useBrowser);
        this.prolog = prolog;
        this.header = header;
        this.footer = footer;
        this.divider = divider;
        this.epilog = epilog;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ConcatAction)) {
            return false;
        }
        ConcatAction a = (ConcatAction)object;
        return this.same(a.filename, this.filename) && a.useBrowser == this.useBrowser;
    }

    private boolean same(String s1, String s2) {
        if (s1 == null || s2 == null) {
            return s1 == s2;
        }
        return s1.equals(s2);
    }

    public String getFilename() {
        return this.filename;
    }

    public boolean getUseBrowser() {
        return this.useBrowser;
    }

    public void connected(Crawler crawler) {
        this.oldSync = crawler.getSynchronous();
        crawler.setSynchronous(true);
        crawler.addCrawlListener(this);
    }

    public void disconnected(Crawler crawler) {
        crawler.setSynchronous(this.oldSync);
        crawler.removeCrawlListener(this);
    }

    private void showit() {
        Browser browser = Context.getBrowser();
        if (browser != null) {
            browser.show(this.file);
        }
    }

    public synchronized void visit(Page page) {
        try {
            this.concat.writePage(page);
        }
        catch (IOException e) {
            throw new RuntimeException(e.toString());
        }
    }

    public void started(CrawlEvent event) {
        if (this.concat == null) {
            try {
                this.file = this.filename != null ? new File(this.filename) : Access.getAccess().makeTemporaryFile("concat", ".html");
                this.concat = new Concatenator(this.file.toString());
                if (this.prolog != null) {
                    this.concat.setProlog(this.prolog);
                }
                if (this.header != null) {
                    this.concat.setPageHeader(this.header);
                }
                if (this.footer != null) {
                    this.concat.setPageFooter(this.footer);
                }
                if (this.divider != null) {
                    this.concat.setDivider(this.divider);
                }
                if (this.epilog != null) {
                    this.concat.setEpilog(this.epilog);
                }
            }
            catch (IOException e) {
                System.err.println(e);
            }
        }
    }

    public void stopped(CrawlEvent event) {
        if (this.concat != null) {
            try {
                this.concat.close();
                this.concat = null;
                if (this.useBrowser) {
                    this.showit();
                }
            }
            catch (IOException e) {
                System.err.println(e);
            }
        }
    }

    public void cleared(CrawlEvent event) {
        try {
            if (this.concat != null) {
                this.concat.close();
                this.concat = null;
                if (this.useBrowser) {
                    this.showit();
                }
            }
        }
        catch (IOException e) {
            System.err.println(e);
        }
    }

    public void timedOut(CrawlEvent event) {
        try {
            if (this.concat != null) {
                this.concat.close();
                this.concat = null;
                if (this.useBrowser) {
                    this.showit();
                }
            }
        }
        catch (IOException e) {
            System.err.println(e);
        }
    }

    public void paused(CrawlEvent event) {
        try {
            if (this.concat != null) {
                this.concat.rewrite();
                if (this.useBrowser) {
                    this.showit();
                }
            }
        }
        catch (IOException e) {
            System.err.println(e);
        }
    }
}

