/*
 * Decompiled with CFR 0.152.
 */
package websphinx.workbench;

import java.awt.Panel;
import websphinx.Action;
import websphinx.Concatenator;
import websphinx.Tagexp;
import websphinx.workbench.ActionFeatureArgs;
import websphinx.workbench.ConcatAction;
import websphinx.workbench.ExtractAction;
import websphinx.workbench.FeatureChoice;
import websphinx.workbench.HighlightAction;
import websphinx.workbench.MirrorAction;
import websphinx.workbench.Script;

class ActionFeatureChoice
extends FeatureChoice {
    ActionFeatureArgs args = new ActionFeatureArgs();
    static final String NULL_ACTION = "none";
    static final String HIGHLIGHT_ACTION = "highlight";
    static final String MIRROR_ACTION = "save";
    static final String CONCAT_ACTION = "concatenate";
    static final String EXTRACT_ACTION = "extract";
    static final String SCRIPT_ACTION = "script";

    public ActionFeatureChoice() {
        this.addItem(NULL_ACTION);
        this.addItem(MIRROR_ACTION);
        this.addItem(CONCAT_ACTION);
        this.addItem(EXTRACT_ACTION);
        this.addItem(HIGHLIGHT_ACTION);
        this.addItem(SCRIPT_ACTION);
    }

    public void setAction(Action act) {
        if (act == null) {
            this.select(NULL_ACTION);
        } else if (act instanceof HighlightAction) {
            HighlightAction highlight = (HighlightAction)act;
            this.select(HIGHLIGHT_ACTION);
            this.args.setColor(highlight.getColor());
            this.args.setScale(highlight.getScale());
            this.args.setIcon(highlight.getIcon());
        } else if (act instanceof MirrorAction) {
            MirrorAction mirror = (MirrorAction)act;
            this.select(MIRROR_ACTION);
            this.args.setMirrorDirectory(mirror.getDirectory());
            this.args.setMirrorUseBrowser(mirror.getUseBrowser());
        } else if (act instanceof ConcatAction) {
            ConcatAction concat = (ConcatAction)act;
            this.select(CONCAT_ACTION);
            this.args.setConcatFilename(concat.getFilename());
            this.args.setConcatUseBrowser(concat.getUseBrowser());
            this.args.prolog = concat.prolog != null ? concat.prolog : Concatenator.defaultProlog;
            this.args.header = concat.header != null ? concat.header : Concatenator.defaultHeader;
            this.args.footer = concat.footer != null ? concat.footer : Concatenator.defaultFooter;
            this.args.divider = concat.divider != null ? concat.divider : Concatenator.defaultDivider;
            this.args.epilog = concat.epilog != null ? concat.epilog : Concatenator.defaultEpilog;
        } else if (act instanceof ExtractAction) {
            ExtractAction extract = (ExtractAction)act;
            this.select(EXTRACT_ACTION);
            this.args.setExtractFilename(extract.getFilename());
            this.args.setExtractUseBrowser(extract.getUseBrowser());
            this.args.setExtractPattern(extract.getPattern().toString());
            this.args.setTextOnly(extract.getTextOnly());
        } else if (act instanceof Script) {
            Script script = (Script)act;
            this.select(SCRIPT_ACTION);
            this.args.setScript(script.getScript());
        } else {
            this.select(NULL_ACTION);
        }
    }

    public Panel getArgs() {
        return this.args;
    }

    public Action getAction() {
        String actn = this.getSelectedItem();
        if (actn.equals(HIGHLIGHT_ACTION)) {
            return new HighlightAction(this.args.getColor(), this.args.getScale(), this.args.getIcon());
        }
        if (actn.equals(MIRROR_ACTION)) {
            return new MirrorAction(this.args.getMirrorDirectory(), this.args.getMirrorUseBrowser());
        }
        if (actn.equals(CONCAT_ACTION)) {
            return new ConcatAction(this.args.getConcatFilename(), this.args.getConcatUseBrowser(), this.args.prolog, this.args.header, this.args.footer, this.args.divider, this.args.epilog);
        }
        if (actn.equals(EXTRACT_ACTION)) {
            return new ExtractAction(new Tagexp(this.args.getExtractPattern()), this.args.getExtractUseBrowser(), this.args.getExtractFilename(), this.args.getTextOnly());
        }
        if (actn.equals(SCRIPT_ACTION)) {
            return new Script(this.args.getScript(), false);
        }
        return null;
    }

    static {
        NULL_ACTION = NULL_ACTION;
        HIGHLIGHT_ACTION = HIGHLIGHT_ACTION;
        MIRROR_ACTION = MIRROR_ACTION;
        CONCAT_ACTION = CONCAT_ACTION;
        EXTRACT_ACTION = EXTRACT_ACTION;
        SCRIPT_ACTION = SCRIPT_ACTION;
    }
}

