/*
 * Decompiled with CFR 0.152.
 */
package websphinx.searchengine;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import websphinx.Link;
import websphinx.Page;
import websphinx.Pattern;
import websphinx.PatternMatcher;
import websphinx.Regexp;
import websphinx.Region;
import websphinx.Tagexp;
import websphinx.searchengine.Search;
import websphinx.searchengine.SearchEngine;
import websphinx.searchengine.SearchEngineResult;

public class MetaCrawler
implements SearchEngine {
    static Pattern patCount = new Regexp("Collated Results: 1 to \\d+ of (\\d+) references");
    static Pattern patNoHits = new Regexp("Your search did not produce any results");
    static Pattern patResult = new Tagexp("<dt><font color=#000000><b>(?{relevance})</b></font>(?{link}(?{title}<a>.*?</a>))(?{description}<dt>.*?<font>)");
    static Pattern patMoreLink = new Tagexp("<a href=http://*.metacrawler.com/crawler\\?general*></a>");
    public static final float priority = 0.0f;

    public void classify(Page page) {
        String title = page.getTitle();
        if (title != null && title.startsWith("Metacrawler query:")) {
            page.setObjectLabel("searchengine.source", this);
            Region count = patCount.oneMatch(page);
            if (count != null) {
                page.setField("searchengine.count", count.getField("0"));
            }
            Region[] results = patResult.allMatches(page);
            Region[] ser = new SearchEngineResult[results.length];
            int i = 0;
            while (i < results.length) {
                ser[i] = new SearchEngineResult(results[i]);
                ++i;
            }
            page.setFields("searchengine.results", ser);
            PatternMatcher m = patMoreLink.match(page);
            while (m.hasMoreElements()) {
                Link link = (Link)m.nextMatch();
                link.setLabel("searchengine.more-results");
                link.setLabel("hyperlink");
            }
        }
    }

    public float getPriority() {
        return 0.0f;
    }

    public URL makeQuery(String keywords) {
        try {
            return new URL("http://www.metacrawler.com/crawler?general=" + URLEncoder.encode(keywords) + "&method=1&format=1&region=&rpp=20&timeout=15&hpe=10");
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("internal error");
        }
    }

    public int getResultsPerPage() {
        return 20;
    }

    public static Search search(String keywords) {
        return new Search(new MetaCrawler(), keywords);
    }

    public static Search search(String keywords, int maxResults) {
        return new Search(new MetaCrawler(), keywords, maxResults);
    }

    static {
        priority = 0.0f;
    }
}

