/*
 * Decompiled with CFR 0.152.
 */
package websphinx.searchengine;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import websphinx.Link;
import websphinx.Page;
import websphinx.Pattern;
import websphinx.PatternMatcher;
import websphinx.Regexp;
import websphinx.Region;
import websphinx.Tagexp;
import websphinx.searchengine.Search;
import websphinx.searchengine.SearchEngine;
import websphinx.searchengine.SearchEngineResult;

public class Excite
implements SearchEngine {
    static Pattern patCount = new Regexp("<font size=-1 face=\"arial, helvetica\">(?:About )?<b>(\\d+)</b> documents? match your query.");
    static Pattern patNoHits = new Regexp("No documents match the query.");
    static Pattern patResult = new Tagexp("<FONT COLOR=navy><B>(?{score})</B></FONT><B>(?{link}<a>(?{title})</a>)</B><BR><B><I></I></B><BR><B><I></I></B>(?{description})<BR><B><I></I></B><a><p></a>");
    static Pattern patMoreLink = new Tagexp("<INPUT TYPE=submit NAME=next VALUE=\"Next Results\">");
    public static final float priority = 0.0f;

    public void classify(Page page) {
        String title = page.getTitle();
        if (title != null && title.startsWith("Excite Search Results")) {
            page.setObjectLabel("searchengine.source", this);
            Region count = patCount.oneMatch(page);
            if (count != null) {
                page.setField("searchengine.count", count.getField("0"));
            }
            Region[] results = patResult.allMatches(page);
            Region[] ser = new SearchEngineResult[results.length];
            int i = 0;
            while (i < results.length) {
                ser[i] = new SearchEngineResult(results[i]);
                ++i;
            }
            page.setFields("searchengine.results", ser);
            PatternMatcher m = patMoreLink.match(page);
            while (m.hasMoreElements()) {
                Link link = (Link)m.nextMatch();
                link.setLabel("searchengine.more-results");
                link.setLabel("hyperlink");
            }
        }
    }

    public float getPriority() {
        return 0.0f;
    }

    public URL makeQuery(String keywords) {
        try {
            return new URL("http://www.excite.com/search.gw?trace=a&search=" + URLEncoder.encode(keywords));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("internal error");
        }
    }

    public int getResultsPerPage() {
        return 10;
    }

    public static Search search(String keywords) {
        return new Search(new Excite(), keywords);
    }

    public static Search search(String keywords, int maxResults) {
        return new Search(new Excite(), keywords, maxResults);
    }

    static {
        priority = 0.0f;
    }
}

