/*
 * Decompiled with CFR 0.152.
 */
package websphinx;

import org.apache.regexp.RE;
import websphinx.Element;
import websphinx.Page;
import websphinx.PatternMatcher;
import websphinx.Region;
import websphinx.Tag;
import websphinx.Tagexp;

class TagexpMatcher
extends PatternMatcher {
    Tagexp tagexp;
    Region source;
    RE re;
    String canon;
    int pos;

    public TagexpMatcher(Tagexp tagexp, Region source) {
        this.tagexp = tagexp;
        this.source = source;
        this.re = new RE(tagexp.pattern, 0);
        this.canon = source.getSource().substringCanonicalTags(source.getStart(), source.getLength());
        this.pos = 0;
    }

    protected Region findNext() {
        if (this.pos < this.canon.length() && this.re.match(this.canon, this.pos)) {
            this.pos = Math.max(this.pos + 1, this.re.getParenEnd(0));
            Page page = this.source.getSource();
            Region match = TagexpMatcher.mapCanonical2Region(page, this.canon, this.re.getParenStart(0), this.re.getParenEnd(0));
            int n = this.re.getParenCount() - 1;
            Region[] groups = new Region[n];
            int i = 0;
            while (i < n) {
                Region r;
                groups[i] = r = TagexpMatcher.mapCanonical2Region(page, this.canon, this.re.getParenStart(i + 1), this.re.getParenEnd(i + 1));
                match.setField(this.tagexp.fields[i] != null ? this.tagexp.fields[i] : String.valueOf(i), r);
                ++i;
            }
            match.setFields("Pattern.groups", groups);
            return match;
        }
        return null;
    }

    static final Region mapCanonical2Region(Page page, String canon, int start, int end) {
        Region[] tokens = page.getTokens();
        if (start == end) {
            int ft = TagexpMatcher.prevTag(canon, start);
            int lt = TagexpMatcher.nextTag(canon, end);
            if (ft != -1) {
                if (lt != -1) {
                    return new Region(page, tokens[ft].getEnd(), tokens[lt].getStart());
                }
                return new Region(page, tokens[ft].getEnd(), page.getEnd());
            }
            if (lt != -1) {
                return new Region(page, page.getStart(), tokens[lt].getStart());
            }
            return page;
        }
        int ft = TagexpMatcher.nextTag(canon, start);
        int lt = TagexpMatcher.prevTag(canon, end);
        Tag f = (Tag)tokens[ft];
        Tag l = (Tag)tokens[lt];
        Element e = f.getElement();
        if (e != null && e.getStart() == f.getStart() && e.getEnd() == l.getEnd()) {
            return e;
        }
        if (ft == lt) {
            return tokens[ft];
        }
        return tokens[ft].span(tokens[lt]);
    }

    static final int nextTag(String canon, int p) {
        return TagexpMatcher.indexOfTag(canon, canon.indexOf(60, p));
    }

    static final int prevTag(String canon, int p) {
        if (p == 0) {
            return -1;
        }
        return TagexpMatcher.indexOfTag(canon, canon.lastIndexOf(60, p - 1));
    }

    static final int indexOfTag(String canon, int p) {
        if (p == -1) {
            return -1;
        }
        int s = canon.indexOf(35, p);
        if (s == -1) {
            return -1;
        }
        int e = canon.indexOf(35, s + 1);
        if (e == -1) {
            return -1;
        }
        return Integer.parseInt(canon.substring(s + 1, e));
    }
}

