/*
 * Decompiled with CFR 0.152.
 */
package websphinx;

import org.apache.regexp.RE;
import websphinx.Page;
import websphinx.PatternMatcher;
import websphinx.Regexp;
import websphinx.Region;

class RegexpMatcher
extends PatternMatcher {
    Regexp regexp;
    Region source;
    RE re;
    String content;
    int pos;

    public RegexpMatcher(Regexp regexp, Region source) {
        this.regexp = regexp;
        this.source = source;
        this.re = new RE(regexp.pattern, 0);
        this.content = source.toString();
        this.pos = 0;
    }

    protected Region findNext() {
        if (this.pos < this.content.length() && this.re.match(this.content, this.pos)) {
            this.pos = Math.max(this.pos + 1, this.re.getParenEnd(0));
            Page page = this.source.getSource();
            int base = this.source.getStart();
            Region match = new Region(page, base + this.re.getParenStart(0), base + this.re.getParenEnd(0));
            int n = this.re.getParenCount() - 1;
            Region[] groups = new Region[n];
            int i = 0;
            while (i < n) {
                Region r;
                groups[i] = r = new Region(page, base + this.re.getParenStart(i + 1), base + this.re.getParenEnd(i + 1));
                match.setField(this.regexp.fields[i], r);
                ++i;
            }
            match.setFields("Pattern.groups", groups);
            return match;
        }
        this.pos = this.content.length();
        return null;
    }
}

