/*
 * Decompiled with CFR 0.152.
 */
package websphinx;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import websphinx.DownloadParameters;
import websphinx.Element;
import websphinx.Form;
import websphinx.FormButton;
import websphinx.Hashtable2;
import websphinx.Link;
import websphinx.Page;
import websphinx.Region;
import websphinx.Tag;
import websphinx.Text;

public class HTMLParser {
    static final int VALID_HTML_PREFIX = 10000;
    int maxBytes = Integer.MAX_VALUE;
    private static final int START = 0;
    private static final int INWORD = 1;
    private static final int ENTITY = 2;
    private static final int LT = 4;
    private static final int BANG = 5;
    private static final int BANG_DASH = 6;
    private static final int CMT = 7;
    private static final int CMT_DASH = 8;
    private static final int CMT_DASHDASH = 9;
    private static final int DIRECTIVE = 10;
    private static final int STAG = 11;
    private static final int ETAG = 12;
    private static final int ATTR = 13;
    private static final int ATTRNAME = 14;
    private static final int EQ = 15;
    private static final int AFTEREQ = 16;
    private static final int ATTRVAL = 17;
    private static final int ATTRVAL_SQ = 18;
    private static final int ATTRVAL_DQ = 19;
    private static final int DONE = 20;
    private static final int ENTNUM = 21;
    private static final int ENTREF = 22;
    StringBuffer wordBuf = new StringBuffer();
    StringBuffer tagName = new StringBuffer();
    StringBuffer attrName = new StringBuffer();
    StringBuffer attrVal = new StringBuffer();
    Vector attrs = new Vector();
    StringBuffer entity = new StringBuffer();
    private static Hashtable entities;
    Vector vElements = new Vector();
    Vector vLinks = new Vector();
    StringBuffer text = new StringBuffer();
    private static Hashtable empty;
    static Hashtable blocktag;
    private static Hashtable forcesClosed;
    static Hashtable context;
    static Hashtable literal;
    static Hashtable linktag;
    static Hashtable savetext;
    static Hashtable headtag;
    Stack elems = new Stack();
    int[] openElems = new int[20];
    int openPtr = 0;
    Form currentForm;

    public void parse(Page page) throws IOException {
        this.tokenize(page);
        this.buildParseTree(page);
    }

    private void tokenize(Page page) throws IOException {
        int state = 0;
        String content = page.getContent();
        int buflen = content.length();
        int bufptr = 0;
        int bufbase = 0;
        Vector<Region> tokens = new Vector<Region>();
        int wordStart = 0;
        int nWords = 0;
        Region tag = null;
        int tagStart = 0;
        int entnum = 0;
        StringBuffer entityTargetBuf = null;
        int postEntityState = 0;
        boolean isHTML = "text/html".equals(page.getContentType());
        while (bufptr < buflen) {
            if (!isHTML && bufptr >= 10000) {
                return;
            }
            char c = content.charAt(bufptr);
            block0 : switch (state) {
                case 0: {
                    switch (c) {
                        case '<': {
                            ++bufptr;
                            state = 4;
                            break block0;
                        }
                        case '\t': 
                        case '\n': 
                        case '\r': 
                        case ' ': {
                            ++bufptr;
                            break block0;
                        }
                    }
                    this.wordBuf.setLength(0);
                    wordStart = bufbase + bufptr;
                    state = 1;
                    break;
                }
                case 1: {
                    switch (c) {
                        case '<': {
                            tokens.addElement(new Text(page, wordStart, bufbase + bufptr, this.wordBuf.toString()));
                            ++nWords;
                            state = 0;
                            break block0;
                        }
                        case '\t': 
                        case '\n': 
                        case '\r': 
                        case ' ': {
                            tokens.addElement(new Text(page, wordStart, bufbase + bufptr, this.wordBuf.toString()));
                            ++nWords;
                            state = 0;
                            ++bufptr;
                            break block0;
                        }
                        case '&': {
                            ++bufptr;
                            postEntityState = 1;
                            entityTargetBuf = this.wordBuf;
                            state = 2;
                            break block0;
                        }
                    }
                    this.wordBuf.append(c);
                    ++bufptr;
                    break;
                }
                case 2: {
                    if (c == '#') {
                        ++bufptr;
                        entnum = 0;
                        state = 21;
                        break;
                    }
                    if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z') {
                        this.entity.setLength(0);
                        state = 22;
                        break;
                    }
                    entityTargetBuf.append('&');
                    state = postEntityState;
                    break;
                }
                case 22: {
                    if (!Character.isLetterOrDigit(c)) {
                        Character ent = HTMLParser.lookupEntityRef(this.entity.toString());
                        if (ent != null) {
                            entityTargetBuf.append(ent.charValue());
                            if (c == ';') {
                                ++bufptr;
                            }
                        } else {
                            entityTargetBuf.append('&');
                            entityTargetBuf.append(this.entity.toString());
                        }
                        state = postEntityState;
                        break;
                    }
                    ++bufptr;
                    this.entity.append(c);
                    break;
                }
                case 21: {
                    if (c == ';' || !Character.isDigit(c)) {
                        entityTargetBuf.append((char)entnum);
                        if (c == ';') {
                            ++bufptr;
                        }
                        state = postEntityState;
                        break;
                    }
                    entnum = 10 * entnum + (c - 48);
                    ++bufptr;
                    break;
                }
                case 4: {
                    tagStart = bufbase + bufptr - 1;
                    switch (c) {
                        case '/': {
                            ++bufptr;
                            this.tagName.setLength(0);
                            state = 12;
                            break block0;
                        }
                        case '!': {
                            ++bufptr;
                            state = 5;
                            break block0;
                        }
                    }
                    if (Character.isLetter(c)) {
                        this.tagName.setLength(0);
                        state = 11;
                        break;
                    }
                    this.wordBuf.append('<');
                    state = 1;
                    break;
                }
                case 5: {
                    if (c == '-') {
                        ++bufptr;
                        state = 6;
                        break;
                    }
                    state = 10;
                    break;
                }
                case 6: {
                    if (c == '-') {
                        ++bufptr;
                        state = 7;
                        break;
                    }
                    state = 10;
                    break;
                }
                case 7: {
                    if (c == '-') {
                        ++bufptr;
                        state = 8;
                        break;
                    }
                    ++bufptr;
                    break;
                }
                case 8: {
                    if (c == '-') {
                        ++bufptr;
                        state = 9;
                        break;
                    }
                    ++bufptr;
                    state = 7;
                    break;
                }
                case 9: {
                    if (c == '>') {
                        tag = new Tag(page, tagStart, bufbase + ++bufptr, Tag.COMMENT, true);
                        tokens.addElement(tag);
                        state = 0;
                        break;
                    }
                    if (c == '-') {
                        ++bufptr;
                        state = 9;
                        break;
                    }
                    ++bufptr;
                    state = 7;
                    break;
                }
                case 10: {
                    if (c == '>') {
                        tag = new Tag(page, tagStart, bufbase + ++bufptr, Tag.COMMENT, true);
                        tokens.addElement(tag);
                        state = 0;
                        break;
                    }
                    ++bufptr;
                    break;
                }
                case 11: {
                    if (c == '>' || HTMLParser.isWhitespace(c)) {
                        tag = new Tag(page, tagStart, bufbase + bufptr, this.tagName.toString(), true);
                        tokens.addElement(tag);
                        this.attrs.setSize(0);
                        state = 13;
                        isHTML = true;
                        break;
                    }
                    this.tagName.append(c);
                    ++bufptr;
                    break;
                }
                case 12: {
                    if (c == '>') {
                        tag = new Tag(page, tagStart, bufbase + ++bufptr, this.tagName.toString(), false);
                        tokens.addElement(tag);
                        state = 0;
                        break;
                    }
                    this.tagName.append(c);
                    ++bufptr;
                    break;
                }
                case 13: {
                    if (HTMLParser.isWhitespace(c)) {
                        ++bufptr;
                        break;
                    }
                    if (c == '>') {
                        ((Tag)tag).end = bufbase + ++bufptr;
                        if (this.attrs.size() > 0) {
                            ((Tag)tag).htmlAttributes = new String[this.attrs.size()];
                            this.attrs.copyInto(((Tag)tag).htmlAttributes);
                        }
                        state = 0;
                        break;
                    }
                    this.attrName.setLength(0);
                    state = 14;
                    break;
                }
                case 14: {
                    if (c == '>' || c == '=' || HTMLParser.isWhitespace(c)) {
                        state = 15;
                        break;
                    }
                    this.attrName.append(c);
                    ++bufptr;
                    break;
                }
                case 15: {
                    if (HTMLParser.isWhitespace(c)) {
                        ++bufptr;
                        break;
                    }
                    if (c == '=') {
                        ++bufptr;
                        state = 16;
                        break;
                    }
                    String name = Tag.toHTMLAttributeName(this.attrName.toString());
                    tag.setLabel(name);
                    this.attrs.addElement(name);
                    state = 13;
                    break;
                }
                case 16: {
                    String name;
                    if (HTMLParser.isWhitespace(c)) {
                        ++bufptr;
                        break;
                    }
                    switch (c) {
                        case '>': {
                            name = Tag.toHTMLAttributeName(this.attrName.toString());
                            tag.setLabel(name);
                            this.attrs.addElement(name);
                            state = 13;
                            break block0;
                        }
                        case '\'': {
                            ++bufptr;
                            this.attrVal.setLength(0);
                            state = 18;
                            break block0;
                        }
                        case '\"': {
                            ++bufptr;
                            this.attrVal.setLength(0);
                            state = 19;
                            break block0;
                        }
                    }
                    this.attrVal.setLength(0);
                    state = 17;
                    break;
                }
                case 17: {
                    String name;
                    if (c == '>' || HTMLParser.isWhitespace(c)) {
                        name = Tag.toHTMLAttributeName(this.attrName.toString());
                        tag.setLabel(name, this.attrVal.toString());
                        this.attrs.addElement(name);
                        state = 13;
                        break;
                    }
                    if (c == '&') {
                        ++bufptr;
                        postEntityState = 17;
                        entityTargetBuf = this.attrVal;
                        state = 2;
                        break;
                    }
                    ++bufptr;
                    this.attrVal.append(c);
                    break;
                }
                case 18: {
                    String name;
                    if (c == '\'') {
                        ++bufptr;
                        name = Tag.toHTMLAttributeName(this.attrName.toString());
                        tag.setLabel(name, this.attrVal.toString());
                        this.attrs.addElement(name);
                        state = 13;
                        break;
                    }
                    if (c == '&') {
                        ++bufptr;
                        postEntityState = 18;
                        entityTargetBuf = this.attrVal;
                        state = 2;
                        break;
                    }
                    ++bufptr;
                    this.attrVal.append(c);
                    break;
                }
                case 19: {
                    String name;
                    if (c == '\"') {
                        ++bufptr;
                        name = Tag.toHTMLAttributeName(this.attrName.toString());
                        tag.setLabel(name, this.attrVal.toString());
                        this.attrs.addElement(name);
                        state = 13;
                        break;
                    }
                    if (c == '&') {
                        ++bufptr;
                        postEntityState = 19;
                        entityTargetBuf = this.attrVal;
                        state = 2;
                        break;
                    }
                    ++bufptr;
                    this.attrVal.append(c);
                    break;
                }
                default: {
                    throw new RuntimeException("HtmlTokenizer entered illegal state " + state);
                }
            }
        }
        switch (state) {
            case 1: {
                tokens.addElement(new Text(page, wordStart, bufbase + bufptr, this.wordBuf.toString()));
                ++nWords;
                break;
            }
        }
        int nTotal = tokens.size();
        page.tokens = new Region[nTotal];
        tokens.copyInto(page.tokens);
        page.words = new Text[nWords];
        int textnum = 0;
        page.tags = new Tag[nTotal - nWords];
        int tagnum = 0;
        int i = 0;
        while (i < nTotal) {
            if (page.tokens[i] instanceof Tag) {
                page.tags[tagnum++] = (Tag)page.tokens[i];
            } else {
                page.words[textnum++] = (Text)page.tokens[i];
            }
            ++i;
        }
    }

    private static boolean isWhitespace(char c) {
        return Character.isWhitespace(c);
    }

    private static Character lookupEntityRef(String name) {
        return (Character)entities.get(name);
    }

    private static void union(Hashtable map, Object tagname, Hashtable tagset) {
        Hashtable2 currset = (Hashtable2)map.get(tagname);
        if (currset == null) {
            map.put(tagname, tagset);
        } else {
            map.put(tagname, currset.union(tagset));
        }
    }

    private void buildParseTree(Page page) {
        boolean keepText = false;
        this.elems.setSize(0);
        this.openPtr = 0;
        Region[] tokens = page.tokens;
        int t = 0;
        while (t < tokens.length) {
            Region r = tokens[t];
            if (r instanceof Tag) {
                Element e;
                Tag tag = (Tag)r;
                String tagName = tag.getTagName();
                if (tag.isStartTag()) {
                    String href;
                    if (forcesClosed.containsKey(tagName) && (e = this.findOpenElement((Hashtable)context.get(tagName))) != null && ((Hashtable)forcesClosed.get(tagName)).containsKey(e.getTagName())) {
                        this.close(e, tag.start);
                    }
                    e = this.makeElement(page.base, tag);
                    this.open(e);
                    if (empty.containsKey(tagName)) {
                        this.close(e, tag.end);
                    } else if (savetext.containsKey(tagName)) {
                        this.text.setLength(0);
                        keepText = true;
                    }
                    if (tagName == Tag.BASE && (href = tag.getHTMLAttribute("href")) != null) {
                        try {
                            page.base = new URL(page.base, new String(href.toCharArray()));
                        }
                        catch (MalformedURLException ex) {
                        }
                        catch (NullPointerException ex) {}
                    }
                } else {
                    e = this.findOpenElement(tagName);
                    if (e != null) {
                        this.close(e, tag);
                        if (savetext.containsKey(tagName)) {
                            if (tagName == Tag.TITLE) {
                                page.title = this.text.toString();
                            } else if (e instanceof Link) {
                                ((Link)e).setText(this.text.toString());
                            }
                            keepText = false;
                        }
                    }
                }
            } else if (keepText) {
                if (this.text.length() > 0) {
                    this.text.append(' ');
                }
                this.text.append(r.toText());
            }
            ++t;
        }
        this.closeAll(page.end);
        if (!this.elems.empty()) {
            Element c;
            int nElems = this.elems.size();
            page.root = c = (Element)this.elems.elementAt(0);
            int j = 1;
            while (j < nElems) {
                Element d;
                c.sibling = d = (Element)this.elems.elementAt(j);
                c = d;
                ++j;
            }
        }
        page.elements = new Element[this.vElements.size()];
        this.vElements.copyInto(page.elements);
        page.links = new Link[this.vLinks.size()];
        this.vLinks.copyInto(page.links);
    }

    private Element makeElement(URL base, Tag tag) {
        Element e = null;
        String tagName = tag.getTagName();
        String hrefAttr = (String)linktag.get(tagName);
        try {
            String type;
            if (tagName == Tag.FORM) {
                e = new Form(tag, null, base);
                this.vLinks.addElement(e);
            } else if (tagName == Tag.INPUT && (type = tag.getHTMLAttribute("type")) != null && (type.equalsIgnoreCase("submit") || type.equalsIgnoreCase("image"))) {
                e = new FormButton(tag, null, this.currentForm);
                this.vLinks.addElement(e);
            } else if (hrefAttr != null && tag.hasHTMLAttribute(hrefAttr)) {
                e = new Link(tag, null, base);
                this.vLinks.addElement(e);
            }
        }
        catch (MalformedURLException f) {
        }
        catch (NullPointerException ex) {
            // empty catch block
        }
        if (e == null) {
            e = new Element(tag, null);
        }
        this.vElements.addElement(e);
        tag.element = e;
        return e;
    }

    private void open(Element e) {
        e.parent = this.openPtr > 0 ? (Element)this.elems.elementAt(this.openElems[this.openPtr - 1]) : null;
        this.elems.push(e);
        if (e instanceof Form) {
            this.currentForm = (Form)e;
        }
        if (this.openPtr == this.openElems.length) {
            int[] newarr = new int[this.openElems.length + 10];
            System.arraycopy(this.openElems, 0, newarr, 0, this.openElems.length);
            this.openElems = newarr;
        }
        this.openElems[this.openPtr] = this.elems.size() - 1;
        ++this.openPtr;
    }

    private Element findOpenElement(String tagname) {
        int i = this.openPtr - 1;
        while (i >= 0) {
            Element e = (Element)this.elems.elementAt(this.openElems[i]);
            if (tagname == e.getTagName()) {
                return e;
            }
            --i;
        }
        return null;
    }

    private Element findOpenElement(Hashtable tags) {
        int i = this.openPtr - 1;
        while (i >= 0) {
            Element e = (Element)this.elems.elementAt(this.openElems[i]);
            if (tags.containsKey(e.getTagName())) {
                return e;
            }
            --i;
        }
        return null;
    }

    private void close(Element elem, Tag tag) {
        elem.endTag = tag;
        tag.element = elem;
        this.close(elem, tag.start);
        elem.end = tag.end;
    }

    private void close(Element elem, int end) {
        Element e;
        do {
            Element c;
            int nElems;
            int firstChild;
            int v = this.openElems[--this.openPtr];
            e = (Element)this.elems.elementAt(v);
            e.end = end;
            if (e instanceof Form) {
                this.currentForm = null;
            }
            if ((firstChild = v + 1) >= (nElems = this.elems.size())) continue;
            e.child = c = (Element)this.elems.elementAt(firstChild);
            int j = firstChild + 1;
            while (j < nElems) {
                Element d;
                c.sibling = d = (Element)this.elems.elementAt(j);
                c = d;
                ++j;
            }
            this.elems.setSize(firstChild);
        } while (e != elem);
    }

    private void closeAll(int end) {
        if (this.openPtr > 0) {
            this.close((Element)this.elems.elementAt(this.openElems[0]), end);
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 1 || args.length > 2) {
            System.err.println("usage: HTMLParser <URL>");
            System.exit(-1);
        }
        Page page = args.length == 1 ? new Page(new Link(args[0]), new DownloadParameters(), new HTMLParser()) : new Page(new URL(args[0]), args[1], new HTMLParser());
        System.out.println("Tokens: ------------------------------------------");
        Region[] tokens = page.tokens;
        int i = 0;
        while (i < tokens.length) {
            System.out.println("[" + tokens[i].getStart() + "," + tokens[i].getEnd() + "]" + tokens[i]);
            ++i;
        }
        System.out.println("Tags: ------------------------------------------");
        Tag[] tags = page.tags;
        int i2 = 0;
        while (i2 < tags.length) {
            Tag t = tags[i2];
            System.out.print((t.isStartTag() ? "start tag" : "end tag") + " " + t.getTagName());
            Enumeration attrs = t.enumerateHTMLAttributes();
            while (attrs.hasMoreElements()) {
                String name = (String)attrs.nextElement();
                String val = t.getHTMLAttribute(name);
                System.out.print(" " + name + "=\"" + val + "\"");
            }
            System.out.println();
            System.out.println("    " + t);
            ++i2;
        }
        System.out.println("Words: ------------------------------------------");
        Text[] words = page.words;
        int i3 = 0;
        while (i3 < words.length) {
            System.out.println(words[i3]);
            ++i3;
        }
        System.out.println("Elements: ------------------------------------------");
        HTMLParser.printout(page.root, 0);
        System.out.println("Links: ------------------------------------------");
        HTMLParser.printout(page.getLinks(), 0);
    }

    private static String indentation(int indent) {
        StringBuffer s = new StringBuffer();
        int i = 0;
        while (i < indent) {
            s.append("    ");
            ++i;
        }
        return s.toString();
    }

    private static void printout(Element element, int indent) {
        Element e = element;
        while (e != null) {
            Element c = e.getChild();
            System.out.println(HTMLParser.indentation(indent) + e.getStartTag() + "[" + e.getStart() + "," + e.getEnd() + "]");
            if (c != null) {
                HTMLParser.printout(c, indent + 1);
            }
            if (e.getEndTag() != null) {
                System.out.println(HTMLParser.indentation(indent) + e.getEndTag());
            }
            e = e.getSibling();
        }
    }

    private static void printout(Link[] elements, int indent) {
        int i = 0;
        while (i < elements.length) {
            Link e = elements[i];
            System.out.println(HTMLParser.indentation(indent) + e.toDescription());
            ++i;
        }
    }

    static {
        VALID_HTML_PREFIX = 10000;
        START = 0;
        INWORD = 1;
        ENTITY = 2;
        LT = 4;
        BANG = 5;
        BANG_DASH = 6;
        CMT = 7;
        CMT_DASH = 8;
        CMT_DASHDASH = 9;
        DIRECTIVE = 10;
        STAG = 11;
        ETAG = 12;
        ATTR = 13;
        ATTRNAME = 14;
        EQ = 15;
        AFTEREQ = 16;
        ATTRVAL = 17;
        ATTRVAL_SQ = 18;
        ATTRVAL_DQ = 19;
        DONE = 20;
        ENTNUM = 21;
        ENTREF = 22;
        entities = new Hashtable2().add("quot", new Character('\"')).add("amp", new Character('&')).add("lt", new Character('<')).add("gt", new Character('>')).add("nbsp", new Character('\u00a0')).add("iexcl", new Character('\u00a1')).add("cent", new Character('\u00a2')).add("pound", new Character('\u00a3')).add("curren", new Character('\u00a4')).add("yen", new Character('\u00a5')).add("brvbar", new Character('\u00a7')).add("sect", new Character('\u00a7')).add("uml", new Character('\u00a8')).add("copy", new Character('\u00a9')).add("ordf", new Character('\u00aa')).add("laquo", new Character('\u00ab')).add("not", new Character('\u00ac')).add("shy", new Character('\u00ad')).add("reg", new Character('\u00ae')).add("macr", new Character('\u00af')).add("deg", new Character('\u00b0')).add("plusmn", new Character('\u00b1')).add("sup2", new Character('\u00b2')).add("sup3", new Character('\u00b3')).add("acute", new Character('\u00b4')).add("micro", new Character('\u00b5')).add("para", new Character('\u00b6')).add("middot", new Character('\u00b7')).add("cedil", new Character('\u00b8')).add("sup1", new Character('\u00b9')).add("ordm", new Character('\u00ba')).add("raquo", new Character('\u00bb')).add("frac14", new Character('\u00bc')).add("frac12", new Character('\u00bd')).add("frac34", new Character('\u00be')).add("iquest", new Character('\u00bf')).add("Agrave", new Character('\u00c0')).add("Aacute", new Character('\u00c1')).add("Acirc", new Character('\u00c2')).add("Atilde", new Character('\u00c3')).add("Auml", new Character('\u00c4')).add("Aring", new Character('\u00c5')).add("AElig", new Character('\u00c6')).add("Ccedil", new Character('\u00c7')).add("Egrave", new Character('\u00c8')).add("Eacute", new Character('\u00c9')).add("Ecirc", new Character('\u00ca')).add("Euml", new Character('\u00cb')).add("Igrave", new Character('\u00cc')).add("Iacute", new Character('\u00cd')).add("Icirc", new Character('\u00ce')).add("Iuml", new Character('\u00cf')).add("ETH", new Character('\u00d0')).add("Ntilde", new Character('\u00d1')).add("Ograve", new Character('\u00d2')).add("Oacute", new Character('\u00d3')).add("Ocirc", new Character('\u00d4')).add("Otilde", new Character('\u00d5')).add("Ouml", new Character('\u00d6')).add("times", new Character('\u00d7')).add("Oslash", new Character('\u00d8')).add("Ugrave", new Character('\u00d9')).add("Uacute", new Character('\u00da')).add("Ucirc", new Character('\u00db')).add("Uuml", new Character('\u00dc')).add("Yacute", new Character('\u00dd')).add("THORN", new Character('\u00de')).add("szlig", new Character('\u00df')).add("agrave", new Character('\u00e0')).add("aacute", new Character('\u00e1')).add("acirc", new Character('\u00e2')).add("atilde", new Character('\u00e3')).add("auml", new Character('\u00e4')).add("aring", new Character('\u00e5')).add("aelig", new Character('\u00e6')).add("ccedil", new Character('\u00e7')).add("egrave", new Character('\u00e8')).add("eacute", new Character('\u00e9')).add("ecirc", new Character('\u00ea')).add("euml", new Character('\u00eb')).add("igrave", new Character('\u00ec')).add("iacute", new Character('\u00ed')).add("icirc", new Character('\u00ee')).add("iuml", new Character('\u00ef')).add("eth", new Character('\u00f0')).add("ntilde", new Character('\u00f1')).add("ograve", new Character('\u00f2')).add("oacute", new Character('\u00f3')).add("ocirc", new Character('\u00f4')).add("otilde", new Character('\u00f5')).add("ouml", new Character('\u00f6')).add("divide", new Character('\u00f7')).add("oslash", new Character('\u00f8')).add("ugrave", new Character('\u00f9')).add("uacute", new Character('\u00fa')).add("ucirc", new Character('\u00fb')).add("uuml", new Character('\u00fc')).add("yacute", new Character('\u00fd')).add("thorn", new Character('\u00fe')).add("yuml", new Character('\u00ff'));
        empty = new Hashtable2().add(Tag.AREA).add(Tag.BASE).add(Tag.BASEFONT).add(Tag.BGSOUND).add(Tag.BR).add(Tag.COL).add(Tag.COLGROUP).add(Tag.COMMENT).add(Tag.HR).add(Tag.IMG).add(Tag.INPUT).add(Tag.ISINDEX).add(Tag.LINK).add(Tag.META).add(Tag.NEXTID).add(Tag.PARAM).add(Tag.SPACER).add(Tag.WBR);
        blocktag = new Hashtable2().add(Tag.P).add(Tag.UL).add(Tag.OL).add(Tag.DIR).add(Tag.MENU).add(Tag.PRE).add(Tag.XMP).add(Tag.LISTING).add(Tag.DL).add(Tag.DIV).add(Tag.CENTER).add(Tag.BLOCKQUOTE).add(Tag.FORM).add(Tag.ISINDEX).add(Tag.HR).add(Tag.TABLE).add(Tag.H1).add(Tag.H2).add(Tag.H3).add(Tag.H4).add(Tag.H5).add(Tag.H6).add(Tag.ADDRESS);
        forcesClosed = new Hashtable2().add(Tag.DD, new Hashtable2().add(Tag.DD).add(Tag.DT)).add(Tag.DT, new Hashtable2().add(Tag.DD).add(Tag.DT)).add(Tag.LI, new Hashtable2().add(Tag.LI)).add(Tag.OPTION, new Hashtable2().add(Tag.OPTION)).add(Tag.TR, new Hashtable2().add(Tag.TR)).add(Tag.TD, new Hashtable2().add(Tag.TD).add(Tag.TH)).add(Tag.TH, new Hashtable2().add(Tag.TD).add(Tag.TH));
        Hashtable2 p = new Hashtable2().add(Tag.P);
        Enumeration enumeration = blocktag.keys();
        while (enumeration.hasMoreElements()) {
            HTMLParser.union(forcesClosed, enumeration.nextElement(), p);
        }
        context = new Hashtable2().add(Tag.DD, new Hashtable2().add(Tag.DL)).add(Tag.DT, new Hashtable2().add(Tag.DL)).add(Tag.LI, new Hashtable2().add(Tag.OL).add(Tag.UL).add(Tag.MENU).add(Tag.DIR)).add(Tag.OPTION, new Hashtable2().add(Tag.SELECT)).add(Tag.TR, new Hashtable2().add(Tag.TABLE)).add(Tag.TD, new Hashtable2().add(Tag.TR).add(Tag.TABLE)).add(Tag.TH, new Hashtable2().add(Tag.TR).add(Tag.TABLE));
        enum = forcesClosed.keys();
        while (enum.hasMoreElements()) {
            Object tagname = enum.nextElement();
            HTMLParser.union(context, tagname, (Hashtable)forcesClosed.get(tagname));
        }
        literal = new Hashtable2();
        linktag = new Hashtable2().add(Tag.A, "href").add(Tag.AREA, "href").add(Tag.APPLET, "code").add(Tag.EMBED, "src").add(Tag.FRAME, "src").add(Tag.FORM, "action").add(Tag.IMG, "src").add(Tag.LINK, "href").add(Tag.SCRIPT, "src");
        savetext = new Hashtable2().add(Tag.A).add(Tag.TITLE);
        headtag = new Hashtable2().add(Tag.META).add(Tag.TITLE).add(Tag.BASE).add(Tag.LINK).add(Tag.ISINDEX);
    }
}

