/*
 * Decompiled with CFR 0.152.
 */
package websphinx;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import websphinx.Element;
import websphinx.FormButton;
import websphinx.Link;
import websphinx.Tag;

public class Form
extends Link {
    public Form(Tag startTag, Tag endTag, URL base) throws MalformedURLException {
        super(startTag, endTag, base);
    }

    protected URL urlFromHref(Tag tag, URL base) throws MalformedURLException {
        String href = tag.getHTMLAttribute("action");
        if (href == null) {
            return base;
        }
        return new URL(base, href);
    }

    public int getMethod() {
        return this.getHTMLAttribute("method", "GET").equalsIgnoreCase("post") ? 1 : 0;
    }

    public URL makeQuery() {
        return this.makeQuery(null);
    }

    public URL makeQuery(FormButton button) {
        StringBuffer querybuf = new StringBuffer();
        this.makeQuery(this.getChild(), querybuf);
        if (button != null) {
            String type = button.getHTMLAttribute("type", "");
            String name = button.getHTMLAttribute("name", "");
            String value = button.getHTMLAttribute("value", "");
            if (type.equalsIgnoreCase("submit")) {
                this.passArgument(querybuf, name, value);
            } else if (type.equalsIgnoreCase("image")) {
                this.passArgument(querybuf, name + ".x", "0");
                this.passArgument(querybuf, name + ".y", "0");
            }
        }
        String href = this.getURL().toExternalForm() + "?";
        if (querybuf.length() > 0) {
            href = href + querybuf.toString().substring(1);
        }
        try {
            return new URL(href);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("internal error: " + e);
        }
    }

    private void makeQuery(Element elem, StringBuffer query) {
        Element e = elem;
        while (e != null) {
            String tagName = e.getTagName();
            if (tagName == Tag.INPUT) {
                String type = e.getHTMLAttribute("type", "text").toLowerCase();
                if (type.equals("text") || type.equals("password") || type.equals("hidden") || (type.equals("checkbox") || type.equals("radio")) && e.hasHTMLAttribute("checked")) {
                    this.passArgument(query, e.getHTMLAttribute("name", ""), e.getHTMLAttribute("value", ""));
                }
            } else if (tagName == Tag.SELECT) {
                String name = e.getHTMLAttribute("name", "");
                Element opt = e.getChild();
                while (opt != null) {
                    if (opt.getTagName() == Tag.OPTION && opt.hasHTMLAttribute("selected")) {
                        this.passArgument(query, name, opt.getHTMLAttribute("value", ""));
                    }
                    opt = opt.getSibling();
                }
            } else if (tagName == Tag.TEXTAREA) {
                this.passArgument(query, e.getHTMLAttribute("name", ""), e.toText());
            } else {
                this.makeQuery(e.getChild(), query);
            }
            e = e.getSibling();
        }
    }

    private void passArgument(StringBuffer query, String name, String value) {
        query.append('&');
        query.append(URLEncoder.encode(name));
        query.append('=');
        query.append(URLEncoder.encode(value));
    }
}

