/*
 * Decompiled with CFR 0.152.
 */
package websphinx;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Date;
import websphinx.Access;
import websphinx.CrawlEvent;
import websphinx.CrawlListener;
import websphinx.Crawler;
import websphinx.LinkEvent;
import websphinx.LinkListener;

public class EventLog
implements CrawlListener,
LinkListener {
    PrintWriter stream;
    boolean onlyNetworkEvents = true;

    public EventLog() {
        this(System.out);
    }

    public EventLog(OutputStream out) {
        this.stream = new PrintWriter(out, true);
    }

    public EventLog(String filename) throws IOException {
        this.stream = new PrintWriter(Access.getAccess().writeFile(new File(filename), false));
    }

    public void setOnlyNetworkEvents(boolean flag) {
        this.onlyNetworkEvents = flag;
    }

    public boolean getOnlyNetworkEvents() {
        return this.onlyNetworkEvents;
    }

    public void started(CrawlEvent event) {
        this.stream.println(new Date() + ": *** started " + event.getCrawler());
    }

    public void stopped(CrawlEvent event) {
        this.stream.println(new Date() + ": *** finished " + event.getCrawler());
    }

    public void cleared(CrawlEvent event) {
        this.stream.println(new Date() + ": *** cleared " + event.getCrawler());
    }

    public void timedOut(CrawlEvent event) {
        this.stream.println(new Date() + ": *** timed out " + event.getCrawler());
    }

    public void paused(CrawlEvent event) {
        this.stream.println(new Date() + ": *** paused " + event.getCrawler());
    }

    public void crawled(LinkEvent event) {
        switch (event.getID()) {
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            default: {
                if (!this.onlyNetworkEvents) break;
                return;
            }
        }
        this.stream.println(new Date() + ": " + event);
        Throwable exc = event.getException();
        if (exc != null && !(exc instanceof IOException)) {
            exc.printStackTrace(this.stream);
        }
    }

    public static EventLog monitor(Crawler crawler) {
        EventLog logger = new EventLog(System.err);
        crawler.addCrawlListener(logger);
        crawler.addLinkListener(logger);
        return logger;
    }
}

