/*
 * Decompiled with CFR 0.152.
 */
package websphinx;

import java.util.Enumeration;
import websphinx.Region;
import websphinx.Tag;

public class Element
extends Region {
    protected Tag startTag;
    protected Tag endTag;
    protected Element sibling;
    protected Element parent;
    protected Element child;

    public Element(Tag startTag, Tag endTag) {
        super(startTag.source, startTag.start, endTag != null ? endTag.end : startTag.end);
        this.startTag = startTag;
        this.endTag = endTag;
    }

    public Element(Tag startTag, int end) {
        super(startTag.source, startTag.start, end);
        this.startTag = startTag;
        this.endTag = null;
    }

    public String getTagName() {
        return this.startTag.getTagName();
    }

    public Tag getStartTag() {
        return this.startTag;
    }

    public Tag getEndTag() {
        return this.endTag;
    }

    public Element getParent() {
        return this.parent;
    }

    public Element getSibling() {
        return this.sibling;
    }

    public Element getChild() {
        return this.child;
    }

    public Element getNext() {
        if (this.sibling != null) {
            return this.sibling;
        }
        if (this.parent != null) {
            return this.parent.getNext();
        }
        return null;
    }

    public boolean hasHTMLAttribute(String name) {
        return this.startTag.hasHTMLAttribute(name);
    }

    public String getHTMLAttribute(String name) {
        return this.startTag.getHTMLAttribute(name);
    }

    public String getHTMLAttribute(String name, String defaultValue) {
        return this.startTag.getHTMLAttribute(name, defaultValue);
    }

    public Enumeration enumerateHTMLAttributes() {
        return this.startTag.enumerateHTMLAttributes();
    }
}

