/*
 * Decompiled with CFR 0.152.
 */
package websphinx;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import rcm.util.Str;
import websphinx.Access;
import websphinx.Element;
import websphinx.HTMLTransformer;
import websphinx.Link;
import websphinx.Page;
import websphinx.RewritableLinkTransformer;
import websphinx.Tag;

public class Concatenator
extends RewritableLinkTransformer {
    boolean needRewrite = false;
    public static String defaultProlog = "<HTML><HEAD><TITLE>Concatenation</TITLE></HEAD><BODY>\n";
    public static String defaultHeader = "<TABLE WIDTH=\"100%\"><TR>\n<TD ALIGN=left><A NAME=\"%a\">%t [%u]</A>\n<TD ALIGN=right>Page %p</TABLE>\n";
    public static String defaultFooter = "";
    public static String defaultDivider = "\n<DIV STYLE=\"page-break-after: always;\"><HR></DIV>\n";
    public static String defaultEpilog = "\n</BODY></HTML>\n";
    String prolog = defaultProlog;
    String header = defaultHeader;
    String footer = defaultFooter;
    String divider = defaultDivider;
    String epilog = defaultEpilog;
    int nPages = 0;

    public Concatenator(String filename) throws IOException {
        super(Concatenator.makeDirs(filename));
    }

    private static String makeDirs(String filename) throws IOException {
        File file = new File(filename);
        File parent = new File(file.getParent());
        if (parent != null) {
            Access.getAccess().makeDir(parent);
        }
        return filename;
    }

    public synchronized void setProlog(String prolog) {
        this.prolog = prolog;
    }

    public String getProlog() {
        return this.prolog;
    }

    public synchronized void setPageHeader(String header) {
        this.header = header;
    }

    public String getPageHeader() {
        return this.header;
    }

    public synchronized void setPageFooter(String footer) {
        this.footer = footer;
    }

    public String getPageFooter() {
        return this.footer;
    }

    public synchronized void setDivider(String divider) {
        this.divider = divider;
    }

    public String getDivider() {
        return this.divider;
    }

    public synchronized void setEpilog(String epilog) {
        this.epilog = epilog;
    }

    public String getEpilog() {
        return this.epilog;
    }

    public synchronized int getPageCount() {
        return this.nPages;
    }

    public synchronized void rewrite() throws IOException {
        if (this.needRewrite) {
            super.rewrite();
            this.needRewrite = false;
        }
    }

    public synchronized void close() throws IOException {
        if (this.nPages == 0) {
            this.write(this.prolog);
        }
        this.emit(this.epilog);
        this.rewrite();
        super.close();
    }

    public synchronized void writePage(Page page) throws IOException {
        ++this.nPages;
        this.emit(this.nPages == 1 ? this.prolog : this.divider);
        String title = page.getTitle();
        URL url = page.getURL();
        String urlString = url.toExternalForm();
        String anchor = "page" + this.nPages;
        this.map(url, "#" + anchor);
        this.emitTemplate(this.header, title, urlString, anchor, this.nPages);
        if (page.isImage() && page.getURL() != null) {
            super.write("<IMG SRC='" + page.getURL() + "'>");
        } else if (page.isHTML()) {
            super.writePage(page);
        } else {
            super.write(page.toHTML());
        }
        this.emitTemplate(this.footer, title, urlString, anchor, this.nPages);
        this.needRewrite = this.nPages > 1;
    }

    private void emitTemplate(String template, String title, String url, String anchor, int pages) throws IOException {
        if (template == null || template.length() == 0) {
            return;
        }
        template = Str.replace(template, "%t", title != null ? title : "");
        template = Str.replace(template, "%u", url != null ? url : "");
        template = Str.replace(template, "%a", anchor != null ? anchor : "");
        template = Str.replace(template, "%p", String.valueOf(pages));
        this.emit(template);
    }

    protected void handleElement(Element elem) throws IOException {
        String name = elem.getTagName();
        if (name != Tag.TITLE && name != Tag.STYLE && name != Tag.BASE && name != Tag.ISINDEX && name != Tag.FRAMESET && name != Tag.FRAME) {
            if (name == Tag.HTML || name == Tag.HEAD || name == Tag.BODY || name == Tag.NOFRAMES) {
                this.transformContents(elem);
            } else {
                super.handleElement(elem);
            }
        }
    }

    public static void main(String[] args) throws Exception {
        Concatenator out = new Concatenator(args[args.length - 1]);
        int i = 0;
        while (i < args.length - 1) {
            Link link = new Link(args[i]);
            Page page = new Page(link);
            ((HTMLTransformer)out).writePage(page);
            ++i;
        }
        ((HTMLTransformer)out).close();
    }
}

