/*
 * Decompiled with CFR 0.152.
 */
package websphinx;

import java.io.FileInputStream;
import java.io.ObjectInputStream;
import rcm.util.Timer;
import websphinx.Crawler;
import websphinx.EventLog;

public class Chronicle
extends Timer
implements Runnable {
    Crawler crawler;
    int interval;
    boolean running = false;
    boolean triggered = false;

    public Chronicle(Crawler crawler, int interval) {
        this.crawler = crawler;
        this.interval = interval;
    }

    public void start() {
        if (this.running) {
            return;
        }
        this.running = true;
        this.set(this.interval * 1000, true);
        Thread thread = new Thread((Runnable)this, this.crawler.getName());
        thread.start();
    }

    public synchronized void stop() {
        if (!this.running) {
            return;
        }
        this.running = false;
        this.crawler.stop();
        this.notify();
        this.cancel();
    }

    public synchronized void run() {
        try {
            while (this.running) {
                this.crawler.run();
                while (!this.triggered) {
                    this.wait();
                }
                this.triggered = false;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected synchronized void alarm() {
        this.crawler.stop();
        this.triggered = true;
        this.notify();
    }

    public static void main(String[] args) throws Exception {
        ObjectInputStream in = new ObjectInputStream(new FileInputStream(args[0]));
        Crawler loadedCrawler = (Crawler)in.readObject();
        in.close();
        EventLog.monitor(loadedCrawler);
        Chronicle track = new Chronicle(loadedCrawler, Integer.parseInt(args[1]));
        track.start();
    }
}

