/*
 * Decompiled with CFR 0.152.
 */
package websphinx;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Vector;
import websphinx.DownloadParameters;
import websphinx.Link;

public class Access {
    private File tempDir;
    private Vector temps = new Vector();
    private static Access theAccess = new Access();

    public Access() {
        String tempDirName;
        try {
            tempDirName = System.getProperty("websphinx.temp.directory");
        }
        catch (SecurityException e) {
            tempDirName = null;
        }
        if (tempDirName == null) {
            String os = System.getProperty("os.name");
            String string = tempDirName = os.startsWith("Windows") ? "c:\\temp\\" : "/tmp/";
        }
        if (!tempDirName.endsWith("/") && !tempDirName.endsWith(File.separator)) {
            tempDirName = tempDirName + "/";
        }
        this.tempDir = new File(tempDirName);
    }

    public URLConnection openConnection(URL url) throws IOException {
        URLConnection conn = url.openConnection();
        conn.connect();
        return conn;
    }

    public URLConnection openConnection(Link link) throws IOException {
        URL url;
        int method = link.getMethod();
        switch (method) {
            case 0: {
                url = link.getPageURL();
                break;
            }
            case 1: {
                url = link.getServiceURL();
                break;
            }
            default: {
                throw new IOException("Unknown HTTP method " + link.getMethod());
            }
        }
        URLConnection conn = url.openConnection();
        DownloadParameters dp = link.getDownloadParameters();
        if (dp != null) {
            String types;
            conn.setAllowUserInteraction(dp.getInteractive());
            conn.setUseCaches(dp.getUseCaches());
            String userAgent = dp.getUserAgent();
            if (userAgent != null) {
                conn.setRequestProperty("User-Agent", userAgent);
            }
            if ((types = dp.getAcceptedMIMETypes()) != null) {
                conn.setRequestProperty("accept", types);
            }
        }
        if (method == 1) {
            String query;
            if (conn instanceof HttpURLConnection) {
                ((HttpURLConnection)conn).setRequestMethod("POST");
            }
            if ((query = link.getQuery()).startsWith("?")) {
                query = query.substring(1);
            }
            conn.setDoOutput(true);
            conn.setRequestProperty("Content-type", "application/x-www-form-urlencoded");
            conn.setRequestProperty("Content-length", String.valueOf(query.length()));
            PrintStream out = new PrintStream(conn.getOutputStream());
            out.print(query);
            out.flush();
        }
        conn.connect();
        return conn;
    }

    public InputStream readFile(File file) throws IOException {
        return new FileInputStream(file);
    }

    public OutputStream writeFile(File file, boolean append) throws IOException {
        return new FileOutputStream(file.toString(), append);
    }

    public RandomAccessFile readWriteFile(File file) throws IOException {
        return new RandomAccessFile(file, "rw");
    }

    public void makeDir(File file) throws IOException {
        file.mkdirs();
    }

    public File getTemporaryDirectory() {
        return this.tempDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File makeTemporaryFile(String basename, String extension) {
        File f;
        File dir = this.getTemporaryDirectory();
        Vector vector = this.temps;
        synchronized (vector) {
            while (this.temps.contains(f = new File(dir, basename + String.valueOf((int)(Math.random() * 999999.0)) + extension)) || f.exists()) {
            }
            this.temps.addElement(f);
        }
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAllTempFiles() {
        Vector vector = this.temps;
        synchronized (vector) {
            int i = 0;
            while (i < this.temps.size()) {
                File f = (File)this.temps.elementAt(i);
                f.delete();
                ++i;
            }
            this.temps.setSize(0);
        }
    }

    public static Access getAccess() {
        return theAccess;
    }

    public static void setAccess(Access access) {
        theAccess = access;
    }
}

