/*
 * Decompiled with CFR 0.152.
 */
package rcm.util;

public abstract class Mem {
    public static long free() {
        return Runtime.getRuntime().freeMemory();
    }

    public static long used() {
        Runtime r = Runtime.getRuntime();
        return r.totalMemory() - r.freeMemory();
    }

    public static long total() {
        return Runtime.getRuntime().totalMemory();
    }

    public static String getReport() {
        return "Memory: used " + Mem.used() / 1000L + "KB, free " + Mem.free() / 1000L + "KB, total " + Mem.total() / 1000L + "KB";
    }

    public static void gc() {
        Runtime r = Runtime.getRuntime();
        r.runFinalization();
        r.gc();
    }

    public static void dumpThreadInfo() {
        ThreadGroup g = Thread.currentThread().getThreadGroup();
        Thread[] t = new Thread[g.activeCount()];
        g.enumerate(t);
        System.err.println("Active threads in " + g);
        int i = 0;
        while (i < t.length) {
            System.err.println(t[i]);
            ++i;
        }
    }
}

