/*
 * Decompiled with CFR 0.152.
 */
package rcm.util;

import java.util.Enumeration;
import rcm.util.Debug;

public class History {
    public static Debug debug = Debug.QUIET;
    protected Object[] history;
    protected int start;
    protected int end;
    protected int curr;

    public History(int max) {
        this.history = new Object[max + 1];
        this.curr = 0;
        this.end = 0;
        this.start = 0;
    }

    public History(History h) {
        this.history = new Object[h.history.length];
        System.arraycopy(h.history, 0, this.history, 0, h.history.length);
        this.start = h.start;
        this.end = h.end;
        this.curr = h.curr;
    }

    public void clear() {
        int i = 0;
        while (i < this.history.length) {
            this.history[i] = null;
            ++i;
        }
        int s = this.start;
        int e = this.end;
        this.curr = 0;
        this.end = 0;
        this.start = 0;
        if (s != e) {
            this.fireRemoved(s, e > 0 ? e - 1 : this.history.length - 1);
        }
    }

    public void expand() {
        Object[] newHistory = new Object[this.history.length * 2 - 1];
        int i = 0;
        int newCurr = 0;
        int j = this.start;
        while (j != this.end) {
            newHistory[i] = this.history[j];
            if (j == this.curr) {
                newCurr = i;
            }
            j = (j + 1) % this.history.length;
            ++i;
        }
        this.history = newHistory;
        this.start = 0;
        this.end = i;
        this.curr = newCurr;
    }

    public void put(Object obj) {
        int newEnd;
        if (!this.isEmpty() && (newEnd = (this.curr + 1) % this.history.length) != this.end) {
            int e = this.end;
            this.end = newEnd;
            this.fireRemoved(newEnd, e > 0 ? e - 1 : this.history.length - 1);
        }
        this.add(obj);
    }

    public void add(Object obj) {
        if (this.isFull()) {
            this.start = (this.start + 1) % this.history.length;
            this.fireRemoved(this.start, this.start);
        }
        this.history[this.end] = obj;
        this.curr = this.end;
        this.end = (this.end + 1) % this.history.length;
        this.fireAdded(this.curr, this.curr);
        debug.println("after put: start=" + this.start + ", end=" + this.end + ", curr=" + this.curr);
    }

    public Object get() {
        return !this.isEmpty() ? this.history[this.curr] : null;
    }

    public Object peekBack() {
        if (this.curr == this.start) {
            return null;
        }
        int bk = this.curr > 0 ? this.curr - 1 : this.history.length - 1;
        return this.history[bk];
    }

    public Object peekForward() {
        if (this.start == this.end) {
            return null;
        }
        int fw = (this.curr + 1) % this.history.length;
        if (fw == this.end) {
            return null;
        }
        return this.history[fw];
    }

    public void replace(Object obj) {
        if (this.isEmpty()) {
            this.put(obj);
        } else {
            this.history[this.curr] = obj;
            this.fireChanged(this.curr, this.curr);
        }
    }

    public Object back() {
        if (this.curr == this.start) {
            return null;
        }
        this.curr = this.curr > 0 ? this.curr - 1 : this.history.length - 1;
        this.fireChanged(this.curr, this.curr);
        return this.history[this.curr];
    }

    public Object forward() {
        if (this.start == this.end) {
            return null;
        }
        int newCurr = (this.curr + 1) % this.history.length;
        if (newCurr == this.end) {
            return null;
        }
        this.curr = newCurr;
        this.fireChanged(this.curr, this.curr);
        return this.history[this.curr];
    }

    public Object toStart() {
        if (this.curr != this.start) {
            this.curr = this.start;
            this.fireChanged(this.curr, this.curr);
        }
        return this.history[this.curr];
    }

    public Object toEnd() {
        int newCurr;
        if (this.start == this.end) {
            return null;
        }
        int n = newCurr = this.end > 0 ? this.end - 1 : this.history.length - 1;
        if (this.curr != newCurr) {
            this.curr = newCurr;
            this.fireChanged(this.curr, this.curr);
        }
        return this.history[this.curr];
    }

    public boolean canBack() {
        return this.curr != this.start;
    }

    public boolean canForward() {
        return (this.curr + 1) % this.history.length != this.end;
    }

    public boolean isEmpty() {
        return this.start == this.end;
    }

    public boolean isFull() {
        return this.start == (this.end + 1) % this.history.length;
    }

    public boolean contains(Object obj) {
        int i = this.start;
        while (i != this.end) {
            if (this.history[i].equals(obj)) {
                return true;
            }
            i = (i + 1) % this.history.length;
        }
        return false;
    }

    public Enumeration elements() {
        return new HistoryEnumeration(this.start, this.end);
    }

    public Enumeration forwardElements() {
        return this.curr == this.end ? new HistoryEnumeration(this.curr, this.end) : new HistoryEnumeration((this.curr + 1) % this.history.length, this.end);
    }

    public Enumeration backElements() {
        return new HistoryEnumeration(this.start, this.curr);
    }

    protected void fireRemoved(int i, int j) {
    }

    protected void fireAdded(int i, int j) {
    }

    protected void fireChanged(int i, int j) {
    }

    class HistoryEnumeration
    implements Enumeration {
        int p;
        int e;

        public HistoryEnumeration(int start, int end) {
            this.p = start;
            this.e = end;
        }

        public boolean hasMoreElements() {
            return this.p != this.e;
        }

        public Object nextElement() {
            Object obj = History.this.history[this.p];
            this.p = (this.p + 1) % History.this.history.length;
            return obj;
        }
    }
}

