/*
 * Decompiled with CFR 0.152.
 */
package rcm.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;

public class Config
extends Properties {
    File file;
    IOException lastException;

    public Config(String fileBaseName) {
        this(fileBaseName, null);
    }

    public Config(File file) {
        this(file, null);
    }

    public Config(String fileBaseName, Config defaults) {
        this(new File(Config.getHomeDirectory(), fileBaseName), defaults);
    }

    public Config(File file, Config defaults) {
        super(defaults);
        this.file = file;
        try {
            FileInputStream in = new FileInputStream(file);
            this.load(in);
            in.close();
        }
        catch (IOException e) {
            this.lastException = e;
        }
    }

    public IOException getLastException() {
        return this.lastException;
    }

    public void save() {
        try {
            FileOutputStream out = new FileOutputStream(this.file);
            this.save(out, "");
            out.close();
            this.lastException = null;
        }
        catch (IOException e) {
            this.lastException = e;
        }
    }

    public int countKeysStartingWith(String prefix) {
        int n = 0;
        Enumeration<?> e = this.propertyNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            if (!name.startsWith(prefix)) continue;
            ++n;
        }
        return n;
    }

    public void removeAllKeysStartingWith(String prefix) {
        Vector<String> keysToDelete = new Vector<String>();
        Enumeration<?> e = this.propertyNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            if (!name.startsWith(prefix)) continue;
            keysToDelete.addElement(name);
        }
        Enumeration e2 = keysToDelete.elements();
        while (e2.hasMoreElements()) {
            this.remove(e2.nextElement());
        }
    }

    public static File getHomeDirectory() {
        String homedir = System.getProperty("user.home");
        if (homedir == null && (homedir = System.getProperty("user.dir")) == null) {
            homedir = ".";
        }
        return new File(homedir);
    }
}

