/*
 * Decompiled with CFR 0.152.
 */
package rcm.awt;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

public class TabPanel
extends Panel {
    static final int MAX_TABS = 25;
    static final int selUpper = 2;
    static final int lineWidth = 2;
    static final int horRound = 2;
    static final int verRound = 2;
    static final int internalMargin = 4;
    static final int xTabOffset = 2;
    static final int XTitle = 4;
    static final int YTitle = 2;
    Font plainFont;
    Font boldFont;
    FontMetrics fmBoldFont;
    final Color light = new Color(223, 223, 223);
    final Color shadow = new Color(127, 127, 127);
    CardLayout tabLayout = new CardLayout();
    Panel tabPanel = new Panel();
    boolean mustRecalculate = true;
    int Z;
    int W;
    int H;
    Component[] cards = new Component[25];
    String[] arrName = new String[25];
    int[] arrEnd = new int[25];
    int[] arrBeg = new int[25];
    int nbTab = 0;
    int selected = -1;
    static final int BUTTON_GUTTER = 2;

    public TabPanel() {
        this.setLayout(null);
        this.tabPanel.setLayout(this.tabLayout);
        this.add(this.tabPanel);
        this.addMouseListener(new MouseHandler());
    }

    void recalculate() {
        this.plainFont = this.getFont();
        if (this.plainFont == null) {
            this.plainFont = new Font("Helvetica", 0, 12);
        }
        this.boldFont = new Font(this.plainFont.getFamily(), 1, this.plainFont.getSize());
        this.fmBoldFont = this.getFontMetrics(this.boldFont);
        this.Z = this.fmBoldFont.getHeight() + 4 + 4 + 1;
        int i = 0;
        while (i < this.nbTab) {
            this.arrBeg[i] = i == 0 ? 2 : this.arrEnd[i - 1];
            this.arrEnd[i] = this.arrBeg[i] + 8 + this.fmBoldFont.stringWidth(this.arrName[i]) + 4;
            ++i;
        }
        if (this.selected >= 0) {
            int n = this.selected;
            this.arrBeg[n] = this.arrBeg[n] - 2;
            int n2 = this.selected;
            this.arrEnd[n2] = this.arrEnd[n2] + 2;
        }
        this.mustRecalculate = false;
    }

    public void layout() {
        if (this.mustRecalculate) {
            this.recalculate();
        }
        Dimension external = this.getSize();
        this.W = external.width;
        this.H = external.height;
        int x = 6;
        int y = this.Z + 1 + 4;
        int w = this.W - 12;
        int h = this.H - this.Z - 12;
        this.tabPanel.setBounds(x, y, w, h);
        this.tabPanel.validate();
        Component[] c = this.getComponents();
        int bx = external.width;
        int i = c.length - 1;
        while (i >= 0) {
            if (c[i] != this.tabPanel && c[i].isVisible()) {
                Dimension d = c[i].getPreferredSize();
                c[i].setBounds(bx -= d.width, 0, d.width, d.height);
                bx -= 2;
            }
            --i;
        }
    }

    public Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        return new Dimension(d.width + 12, d.height + this.Z + 12);
    }

    public Dimension getMinimumSize() {
        Dimension d = super.getMinimumSize();
        return new Dimension(d.width + 12, d.height + this.Z + 12);
    }

    public void addTabPanel(String name, boolean enabled, Component c) {
        if (c.getParent() == this.tabPanel || this.nbTab >= this.arrBeg.length || c == this) {
            return;
        }
        this.cards[this.nbTab] = c;
        this.arrName[this.nbTab] = name;
        this.tabPanel.add(String.valueOf(this.nbTab), c);
        ++this.nbTab;
        if (this.selected < 0) {
            this.select(0);
        }
        this.mustRecalculate = true;
        this.repaint();
    }

    public String[] getPanelLabels() {
        return this.arrName;
    }

    public void removeAllTabPanels() {
        int i = this.nbTab - 1;
        while (i >= 0) {
            this.removeTabPanel(i);
            --i;
        }
    }

    public void removeTabPanel(Component c) {
        int i = 0;
        while (i < this.cards.length) {
            if (this.cards[i] == c) {
                this.removeTabPanel(i);
                break;
            }
            ++i;
        }
    }

    public void removeTabPanel(int i) {
        if (i < 0 || i >= this.nbTab) {
            return;
        }
        this.tabPanel.remove(this.cards[i]);
        int j = i;
        while (j < this.nbTab - 1) {
            this.arrName[j] = this.arrName[j + 1];
            this.cards[j] = this.cards[j + 1];
            ++j;
        }
        --this.nbTab;
        if (this.selected == i) {
            this.select(Math.min(this.selected + 1, this.nbTab - 1));
        }
        this.mustRecalculate = true;
        this.repaint();
    }

    public int countTabs() {
        return this.nbTab;
    }

    public void renameTab(String oldName, String newName) {
        int i = 0;
        while (i < this.nbTab) {
            if (this.arrName[i].equals(oldName)) {
                this.arrName[i] = new String(newName);
                this.mustRecalculate = true;
                this.repaint();
                break;
            }
            ++i;
        }
    }

    public void select(int num) {
        if (num < 0 || num > this.nbTab || num == this.selected) {
            return;
        }
        this.selected = num;
        this.tabLayout.show(this.tabPanel, Integer.toString(this.selected));
        this.mustRecalculate = true;
        this.repaint();
    }

    public Component getSelectedComponent() {
        if (this.selected < 0 || this.selected >= this.nbTab) {
            return null;
        }
        return this.cards[this.selected];
    }

    public synchronized void update(Graphics g) {
        this.paint(g);
    }

    public synchronized void paint(Graphics g) {
        int i;
        if (this.mustRecalculate || this.getFont() != this.plainFont) {
            this.recalculate();
        }
        Dimension d = this.getSize();
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.W, this.Z + 1);
        int curr = 0;
        while (curr < this.nbTab) {
            int upper = curr == this.selected ? 0 : 2;
            g.setFont(curr == this.selected ? this.boldFont : this.plainFont);
            g.setColor(this.shadow);
            i = 2;
            while (curr != this.selected - 1 && i > 0) {
                if (i == 1) {
                    g.setColor(Color.black);
                }
                g.drawLine(this.arrEnd[curr] - i, upper + 2, this.arrEnd[curr] - i, this.Z - 2);
                if (i == 1) {
                    g.drawLine(this.arrEnd[curr] - 2, upper + 1, this.arrEnd[curr] - 2, upper + 1);
                }
                --i;
            }
            g.setColor(Color.black);
            g.drawString(this.arrName[curr], this.arrBeg[curr] + (curr == this.selected ? 4 : 2) + 4, upper + 2 + 2 + this.fmBoldFont.getAscent());
            g.setColor(Color.white);
            int i2 = 0;
            while (i2 < 2) {
                if (i2 == 1) {
                    g.setColor(this.light);
                }
                g.drawLine(this.arrBeg[curr] + 2, upper + i2, this.arrEnd[curr] - 2 - 2 + 1, upper + i2);
                if (curr != this.selected + 1) {
                    g.drawLine(this.arrBeg[curr] + i2, upper + 2, this.arrBeg[curr] + i2, this.Z);
                    if (i2 == 0) {
                        g.drawLine(this.arrBeg[curr] + 1, upper + 1, this.arrBeg[curr] + 1, upper + 1);
                    }
                }
                ++i2;
            }
            ++curr;
        }
        g.setColor(Color.white);
        int i3 = 0;
        while (i3 < 2) {
            if (i3 == 1) {
                g.setColor(this.light);
            }
            g.drawLine(i3, this.Z, i3, this.H - 1);
            if (this.selected >= 0) {
                if (this.selected != 0) {
                    g.drawLine(0, this.Z - 2 + i3 + 1, this.arrBeg[this.selected], this.Z - 2 + i3 + 1);
                }
                g.drawLine(this.arrEnd[this.selected], this.Z - 2 + i3 + 1, this.W - 1, this.Z - 2 + i3 + 1);
            } else {
                g.drawLine(0, this.Z - 2 + i3 + 1, this.W - 1, this.Z - 2 + i3 + 1);
            }
            ++i3;
        }
        g.setColor(this.shadow);
        i = 2;
        while (i > 0) {
            if (i == 1) {
                g.setColor(Color.black);
            }
            g.drawLine(0, this.H - i, this.W, this.H - i);
            g.drawLine(this.W - i, this.Z, this.W - i, this.H - 1);
            --i;
        }
    }

    void clickTab(int x, int y) {
        int i = 0;
        while (i < this.nbTab) {
            if (x > this.arrBeg[i] && x < this.arrEnd[i]) {
                this.select(i);
            }
            ++i;
        }
    }

    static {
        MAX_TABS = 25;
        selUpper = 2;
        lineWidth = 2;
        horRound = 2;
        verRound = 2;
        internalMargin = 4;
        xTabOffset = 2;
        XTitle = 4;
        YTitle = 2;
        BUTTON_GUTTER = 2;
    }

    class MouseHandler
    extends MouseAdapter {
        MouseHandler() {
        }

        public void mousePressed(MouseEvent event) {
            if (event.getY() < TabPanel.this.Z) {
                TabPanel.this.clickTab(event.getX(), event.getY());
            }
        }
    }
}

