/*
 * Decompiled with CFR 0.152.
 */
package rcm.awt;

import java.awt.AWTError;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.Point;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import rcm.awt.BorderPanel;
import rcm.awt.MultiLineLabel;
import rcm.awt.PopupEvent;
import rcm.awt.PopupListener;
import rcm.util.Win;

public class PopupDialog
extends Dialog {
    public static final int YES = 0;
    public static final int OK = 0;
    public static final int NO = 1;
    public static final int CANCEL = 2;
    Component parent;
    int answer = -1;
    String text;
    TextField textfield;
    Button okButton;
    Button noButton;
    Button cancelButton;
    public static String currentDirectory;
    Vector listeners = new Vector();

    public static String ask(Component comp, String topic, String question, String defaultAnswer) {
        PopupDialog d = new PopupDialog(comp, topic, true, question, defaultAnswer, "OK", null, "Cancel");
        d.show();
        switch (d.getAnswer()) {
            case 0: {
                return d.getText();
            }
        }
        return null;
    }

    public static String ask(Component comp, String topic, String question) {
        return PopupDialog.ask(comp, topic, question, "");
    }

    public static boolean okcancel(Component comp, String topic, String question) {
        PopupDialog d = new PopupDialog(comp, topic, true, question, null, "OK", null, "Cancel");
        d.show();
        return d.getAnswer() == 0;
    }

    public static boolean yesno(Component comp, String topic, String question) {
        PopupDialog d = new PopupDialog(comp, topic, true, question, null, "Yes", "No", null);
        d.show();
        return d.getAnswer() == 0;
    }

    public static int yesnocancel(Component comp, String topic, String question) {
        PopupDialog d = new PopupDialog(comp, topic, true, question, null, "Yes", "No", "Cancel");
        d.show();
        return d.getAnswer();
    }

    public static void warn(Component comp, String topic, String message) {
        PopupDialog d = new PopupDialog(comp, topic, true, message, null, "OK", null, null);
        d.show();
    }

    public static String askFilename(Component comp, String topic, String defaultFilename, boolean loading) {
        try {
            FileDialog fd = new FileDialog(Win.findFrame(comp), topic, loading ? 0 : 1);
            if (currentDirectory != null) {
                fd.setDirectory(currentDirectory);
            }
            if (defaultFilename != null) {
                fd.setFile(defaultFilename);
            }
            fd.show();
            String dir = fd.getDirectory();
            String file = fd.getFile();
            if (dir == null || file == null) {
                return null;
            }
            currentDirectory = dir;
            return dir + file;
        }
        catch (AWTError e) {
            return PopupDialog.ask(comp, topic, "Filename:", defaultFilename);
        }
    }

    public static String askDirectory(Component comp, String topic, String defaultFilename, boolean loading) {
        try {
            FileDialog fd = new FileDialog(Win.findFrame(comp), topic, loading ? 0 : 1);
            if (currentDirectory != null) {
                fd.setDirectory(currentDirectory);
            }
            if (defaultFilename != null) {
                fd.setFile(defaultFilename);
            }
            fd.show();
            String dir = fd.getDirectory();
            if (dir != null) {
                currentDirectory = dir;
            }
            return dir;
        }
        catch (AWTError e) {
            return PopupDialog.ask(comp, topic, "Directory:", defaultFilename);
        }
    }

    public PopupDialog(Component parent, String title, boolean modal) {
        super(Win.findFrameOrMakeFrame(parent), title, modal);
        this.parent = parent;
    }

    public PopupDialog(Component parent, String title, boolean modal, String question, String initialEntry, String okOrYes, String no, String cancel) {
        this(parent, title, modal);
        if (parent != null) {
            this.setFont(parent.getFont());
        }
        Panel middle = new Panel();
        this.add("Center", BorderPanel.wrap(middle, 10, 10, 10, 5));
        middle.setLayout(new BorderLayout());
        MultiLineLabel questionLabel = new MultiLineLabel(question, 0);
        middle.add("Center", questionLabel);
        if (initialEntry != null) {
            this.textfield = new TextField(Math.max(40, initialEntry.length() + 1));
            middle.add("South", this.textfield);
            this.textfield.setText(initialEntry);
            this.textfield.selectAll();
            this.textfield.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    PopupDialog.this.answer = 0;
                    PopupDialog.this.close();
                }
            });
        }
        Panel bottom = new Panel();
        this.add("South", bottom);
        if (okOrYes != null) {
            this.okButton = new Button(okOrYes);
            this.okButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    PopupDialog.this.answer = 0;
                    PopupDialog.this.close();
                }
            });
            bottom.add(this.okButton);
        }
        if (no != null) {
            this.noButton = new Button(no);
            this.noButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    PopupDialog.this.answer = 1;
                    PopupDialog.this.close();
                }
            });
            bottom.add(this.noButton);
        }
        if (cancel != null) {
            this.cancelButton = new Button(cancel);
            this.cancelButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    PopupDialog.this.answer = 2;
                    PopupDialog.this.close();
                }
            });
            bottom.add(this.cancelButton);
        }
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent event) {
                if (PopupDialog.this.cancelButton != null) {
                    PopupDialog.this.answer = 2;
                    PopupDialog.this.close();
                } else if (PopupDialog.this.noButton == null && PopupDialog.this.cancelButton == null) {
                    PopupDialog.this.answer = 0;
                    PopupDialog.this.close();
                }
            }
        });
        this.pack();
    }

    public static void centerWindow(Window window, Component ref) {
        Point origin;
        Dimension size = window.getSize();
        Dimension refSize = ref != null ? ref.getSize() : Toolkit.getDefaultToolkit().getScreenSize();
        Point point = origin = ref != null ? ref.getLocationOnScreen() : new Point(0, 0);
        if (refSize != null) {
            int x = Math.max(0, origin.x + (refSize.width - size.width) / 2);
            int y = Math.max(0, origin.y + (refSize.height - size.height) / 2);
            window.setLocation(x, y);
        }
    }

    public void show() {
        PopupDialog.centerWindow(this, this.parent);
        super.show();
        if (this.textfield != null) {
            this.textfield.requestFocus();
        }
    }

    public int getAnswer() {
        return this.answer;
    }

    public void setAnswer(int answer) {
        this.answer = answer;
    }

    public String getText() {
        return this.text;
    }

    public synchronized void addPopupListener(PopupListener listener) {
        this.listeners.addElement(listener);
    }

    public synchronized void removePopupListener(PopupListener listener) {
        this.listeners.removeElement(listener);
    }

    public synchronized void close() {
        this.text = this.answer == 0 && this.textfield != null ? this.textfield.getText() : null;
        this.dispose();
        if (this.parent == null) {
            ((Frame)this.getParent()).dispose();
        } else {
            this.parent.requestFocus();
        }
        if (this.answer != -1) {
            PopupEvent e = new PopupEvent(this.answer, this.text);
            int i = 0;
            while (i < this.listeners.size()) {
                PopupListener p = (PopupListener)this.listeners.elementAt(i);
                switch (e.getID()) {
                    case 0: {
                        p.yes(e);
                        break;
                    }
                    case 1: {
                        p.no(e);
                        break;
                    }
                    case 2: {
                        p.cancel(e);
                    }
                }
                ++i;
            }
        }
        try {
            this.finalize();
        }
        catch (Throwable t) {
            throw new RuntimeException(t.toString());
        }
    }

    public static void main(String[] args) {
        String name = PopupDialog.ask(null, "Enter Name", "Enter your full name:");
        if (name != null) {
            switch (PopupDialog.yesnocancel(null, "Confirm", "Hello, " + name + ".\nIs this your name?")) {
                case 0: {
                    if (!PopupDialog.okcancel(null, "Thanks", "Great!\nDo you want to play a game?")) break;
                    PopupDialog.warn(null, "Sorry", "Too bad, my mommy won't let me out of the house.");
                    break;
                }
                case 1: {
                    PopupDialog.warn(null, "D'oh", "Oops.  My bad.");
                }
            }
        }
        System.exit(0);
    }

    static {
        YES = 0;
        OK = 0;
        NO = 1;
        CANCEL = 2;
        currentDirectory = "";
    }
}

