/*
 * Decompiled with CFR 0.152.
 */
package rcm.awt;

import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.StringTokenizer;

public class MultiLineString {
    String[] lines;

    public MultiLineString(String string) {
        StringTokenizer tok = new StringTokenizer(string, "\n");
        this.lines = new String[tok.countTokens()];
        int i = 0;
        while (i < this.lines.length) {
            this.lines[i] = tok.nextToken();
            ++i;
        }
    }

    public MultiLineString(String[] lines) {
        this.lines = lines;
    }

    public int countLines() {
        return this.lines.length;
    }

    public String getLineAt(int i) {
        return this.lines[i];
    }

    public int getWidth(FontMetrics fm) {
        int w = 0;
        int i = 0;
        while (i < this.lines.length) {
            w = Math.max(w, fm.stringWidth(this.lines[i]));
            ++i;
        }
        return w;
    }

    public int getHeight(FontMetrics fm) {
        return fm.getHeight() * this.lines.length;
    }

    public void draw(Graphics g, int x, int y, int alignment) {
        FontMetrics fm = g.getFontMetrics();
        y += fm.getAscent();
        int width = alignment != 0 ? this.getWidth(fm) : 0;
        int i = 0;
        while (i < this.lines.length) {
            int x1 = x;
            switch (alignment) {
                case 0: {
                    break;
                }
                case 2: {
                    x += width - fm.stringWidth(this.lines[i]);
                    break;
                }
                case 1: {
                    x += (width - fm.stringWidth(this.lines[i])) / 2;
                }
            }
            g.drawString(this.lines[i], x, y);
            y += fm.getHeight();
            ++i;
        }
    }
}

