/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.DumpButton;
import gui.ExploitPanel;
import gui.SpecialMouseListener;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import prog.TableRow;

public class ResultsTableModel
extends AbstractTableModel {
    Vector<TableRow> rows;
    Vector<DumpButton> dumpButtons;
    ExploitPanel parent;
    protected String[] columnNames = new String[]{"Schema Name", "Table Name", "Columns", ""};

    public ResultsTableModel(ExploitPanel parent) {
        this.parent = parent;
        this.rows = new Vector();
        this.dumpButtons = new Vector();
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public int getRowCount() {
        return this.rows.size();
    }

    public TableRow getRow(int row) {
        return this.rows.get(row);
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    public void addRow(TableRow row) {
        int r = this.findRow(row);
        if (r > -1) {
            this.rows.get(r).addColumn(row.getColNames().get(0));
        } else {
            this.rows.addElement(row);
            DumpButton button = new DumpButton(row);
            button.addMouseListener(new SpecialMouseListener(row, this.parent));
            this.dumpButtons.addElement(button);
        }
    }

    public void removeAll() {
        this.rows.removeAllElements();
        this.dumpButtons.removeAllElements();
    }

    public int findRow(TableRow c) {
        for (TableRow curr : this.rows) {
            if (!curr.getSchemaName().equals(c.getSchemaName()) || !curr.getTableName().equals(c.getTableName())) continue;
            return this.rows.indexOf(curr);
        }
        return -1;
    }

    public Class getColumnClass(int column) {
        return this.getValueAt(0, column).getClass();
    }

    @Override
    public Object getValueAt(int row, int col) {
        TableRow curr = this.rows.get(row);
        switch (col) {
            case 0: {
                return curr.getSchemaName();
            }
            case 1: {
                return curr.getTableName();
            }
            case 2: {
                return curr.getColNames();
            }
            case 3: {
                return this.dumpButtons.get(row);
            }
        }
        return 0;
    }
}

