/*
 * Decompiled with CFR 0.152.
 */
package gui;

import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import prog.Arg;

public class CustomTableModel
extends AbstractTableModel {
    Vector<Arg> rows;
    protected String[] columnNames = new String[]{"Page", "Parameter", "Rest", "Test"};

    public CustomTableModel(Vector<Arg> rows) {
        this.rows = rows;
    }

    public void clearTable() {
        this.rows = new Vector();
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public int getRowCount() {
        return this.rows.size();
    }

    public Arg getRow(int row) {
        return this.rows.get(row);
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    public void addRow(Arg row) {
        this.rows.addElement(row);
        this.setValueAt(row.getPageLink(), this.getRowCount(), 0);
        this.setValueAt(row.getName(), this.getRowCount(), 1);
        this.setValueAt(row.getRest(), this.getRowCount(), 2);
        this.setValueAt(true, this.getRowCount(), 3);
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col > 2;
    }

    public int argPos(Arg a) {
        int count = 0;
        for (Arg arg : this.rows) {
            if (a.getPageBase().equals(arg.getPageBase()) && a.getName().equals(arg.getName()) && a.getRest().equals(arg.getRest())) {
                return count;
            }
            ++count;
        }
        return -1;
    }

    public Class getColumnClass(int c) {
        return this.getValueAt(0, c).getClass();
    }

    @Override
    public Object getValueAt(int row, int col) {
        Arg curr = this.rows.get(row);
        switch (col) {
            case 0: {
                return curr.getPageLink().subSequence(0, curr.getPageLink().lastIndexOf(63));
            }
            case 1: {
                return String.valueOf(curr.getName()) + "=" + curr.getValues();
            }
            case 2: {
                return curr.getRest();
            }
            case 3: {
                return curr.getTest();
            }
        }
        return 0;
    }
}

