/*
 *(c) 2003, visigoth <visigoth@securitycentric.com>
 * This source code is distributed under a BSD license,
 * please see the LICENSE file for details
 *
 * UnifiedVersion.java
 *
 * Created on May 4, 2003, 8:03 AM
 */

import com.securitycentric.metacoretex.interfaces.*;
import com.securitycentric.metacoretex.lib.*;

import java.sql.*;

/**
 *
 * @author  visigoth
 */
public class UnifiedVersion extends AbstractDatabaseProbe {
    
    /** Creates a new instance of UnifiedVersion */
    public UnifiedVersion() {
        setName("JDBC Version Tester");
        setFamily("JDBC");
        setProbeId(9);
        setVersion("$Id: UnifiedVersion.java,v 1.5 2003/09/21 22:44:11 visigoth_6 Exp $");
        setCopyright("(c) 2003, visigoth <visigoth@securitycentric.com>");

        setReport("Found the following DB versions:\n"+
                  "--------------------------\n");
        
        addDepends("mysql/connection");
        addDepends("oracle/connection");
        addDepends("mssql/connection");

        addProvides("mysql/version","java.lang.String MySQL version string");
        addProvides("mysql/metadata","java.sql.DatabaseMetadata for MySQL");
        addProvides("mysql/Version","lib.Version object for MySQL");
        addProvides("oracle/version","java.lang.String Oracle version string");
        addProvides("oracle/metadata","java.sql.DatabaseMetadata for Oracle");
        addProvides("oracle/Version","lib.Version object for Oracle");
        addProvides("mssql/version","java.lang.String MSSQL version string");
        addProvides("mssql/metadata","java.sql.DatabaseMetadata for MSSQL");
        addProvides("mssql/Version","lib.Version object for MSSQL");

        addOption("db.types","mysql,oracle,mssql");
        
        setHelp("This probe uses the DB independant JDBC code "+
                "to enumerate the version of the underlying DB.\n"+
                "MANY probes depend on this one, it's likely you should\n"+
                "leave it enabled!\n\n"+
                "Options:\n"+
                "db.types - A list of the DB families in use. If you have "+
                "other platforms showing up in your family listing, you may "+
                "put them here\n\n");
        
    }
    
    public void probe() throws ProbeException {

        String[] dbTypes = getOption("db.types").split(",");
        
        for (int i = 0; i < dbTypes.length; i++) {

            try {
                if ( ! kbHas(dbTypes[i]+"/connection"))
                    continue;
            
            
                con = (Connection) kbGet(dbTypes[i]+"/connection");
                
                md = con.getMetaData();
                version = md.getDatabaseProductVersion();
                ver = new Version(version);
            
            } catch (SQLException se) {
                continue;
            } catch (VersionException ve) {
                throw(new ProbeException("Version Parser: "+ve.getMessage()));
            }
            
            kbPut(dbTypes[i]+"/version",version);
            kbPut(dbTypes[i]+"/metadata",md);
            kbPut(dbTypes[i]+"/Version",ver);
            setReportable(true);
            addReport(dbTypes[i]+" : "+version+"\n");
            addReport("--------------------------");
        }
    }
    
    Connection con;
    String version;
    DatabaseMetaData md;
    Version ver;
}
