/*
 * OraclePortScanner.java
 *
 * (c) 2003, visigoth <visigoth@securitycentric.com>
 */

import com.securitycentric.metacoretex.interfaces.*;
import com.securitycentric.metacoretex.lib.*;

import java.sql.*;
import java.io.*;

/**
 *
 * @author
 */
public class OraclePortScanner extends AbstractDatabaseProbe {
    
    /** Creates a new instance of OraclePortScanner */
    public OraclePortScanner() {
        
        setName("Oracle Port Scanner");
        setFamily("Oracle");
        setCopyright("(c) 2003, visigoth <visigoth@securitycentric.com>");
        setVersion("$Id: OraclePortScanner.java,v 1.4 2003/09/21 22:44:11 visigoth_6 Exp $");
        setProbeId(34);
        
        addDepends("oracle/connection");
        String luserDir = System.getProperty("user.dir");
        addOption("oracle.file",luserDir+"/conf/OraclePortScanner.sql");
        addOption("target.host","localhost");
        addOption("port.min","1");
        addOption("port.max","10000");
        
        
        setHelp("This probe uses the UTL_TCP package in oracle to portscan the target host and reports on any TCP listeners found.  Remember, the scan is ORIGINATING at the target oracle server, so portscan loopback for fun and firewall circumvention, and scan DMZ boxes for additional pleasure...");
    }
    
    public void probe() throws ProbeException {
        
        String line;
        String qryStr = new String();

        setReport("The following TCP ports between "+getOption("port.min")+
                  " and "+getOption("port.max")+" were \n"+
                  "discoverd listening on "+ getOption("target.host")+
                  " from the perspective of "+ getHost()+ " :");

        try {
            
            if (! kbHas("oracle/connection"))
                return;

            con = (Connection) kbGet("oracle/connection");


            File sqlFile = new File(getOption("oracle.file"));

            BufferedReader br = new BufferedReader(new FileReader(sqlFile));

            while((line = br.readLine()) != null) {
                qryStr = qryStr.concat(line+"\n");
            }

            qryStr = qryStr.replaceAll("TARGET",getOption("target.host"));
            qryStr = qryStr.replaceAll("MIN_PORT",getOption("port.min"));
            qryStr = qryStr.replaceAll("MAX_PORT",getOption("port.max"));

            Statement stmt = con.createStatement();
            stmt.executeUpdate("BEGIN dbms_output.enable; END;");

            stmt.executeUpdate(qryStr);

            CallableStatement cstmt = con.prepareCall("{call dbms_output.get_line(?,?)}");

            setReportable(true);
            addReport(" ");

            cstmt.registerOutParameter(1, Types.VARCHAR);
            cstmt.registerOutParameter(2, Types.INTEGER);

            cstmt.execute();
            while (cstmt.getInt(2) == 0) {
                addReport(cstmt.getString(1));
                cstmt.execute();
            }

        } catch (SQLException e) {
            throw(new ProbeException(e.getMessage()));
        } catch (IOException e) {
            throw(new ProbeException(e.getMessage()));
        }
    }

    Connection con;
    ResultSet res;
}
