/*
 *
 * (c) 2003, visigoth <visigoth@securitycentric.com>
 *
 * OraclePackagePerms.java
 *
 */

import com.securitycentric.metacoretex.interfaces.*;
import com.securitycentric.metacoretex.lib.*;

import java.sql.*;
import java.io.*;

/**
 *
 * @author  
 */
public class OraclePackagePerms extends AbstractDatabaseProbe {
    
    /** Creates a new instance of OraclePackagePerms */
    public OraclePackagePerms() {
        
        setName("Oracle Package Permissions");
        setFamily("Oracle");
        setVersion("$Id: OraclePackagePerms.java,v 1.3 2003/09/21 22:44:11 visigoth_6 Exp $");
        setProbeId(36);
        setCopyright("(c) 2003, visigoth <visigoth@securitycentric.com>");
        
        addDepends("oracle/connection");
        String confDir = System.getProperty("user.dir")+"/conf/";
        addOption("package.list",confDir+"oracle_packages.txt");
        
        setReport("The selected Oracle packages have the following permissions:");
        
        setHelp("This probe enumerates the permissions on selected packages which may pose a larger threat than most.");
    }
    
    public void probe() throws ProbeException {
        
        try {
            
            if (! kbHas("oracle/connection"))
                return;

            con = (Connection) kbGet("oracle/connection");
            
            PreparedStatement pstmt = con.prepareStatement("select ue.name, tpm.name as permission from sys.objauth$ oa, sys.obj$ o, sys.user$ ue, table_privilege_map tpm where oa.obj# = o.obj# and oa.grantee# = ue.user# and oa.privilege# = tpm.privilege and o.type# = 9 and o.name = ?",
                                                            ResultSet.TYPE_SCROLL_INSENSITIVE,ResultSet.CONCUR_READ_ONLY);

            File confFile = new File(getOption("package.list"));
            String pack = new String();

            BufferedReader br = new BufferedReader(new FileReader(confFile));

            setReportable(true);

            while ((pack = br.readLine()) != null) {

                if( pack.startsWith("#"))
                    continue;

                setReport(getReport()+"\n\nPackage "+pack+" :");
                pstmt.setString(1,pack);
                res = pstmt.executeQuery();
                addResultSet(res);
                
                res.beforeFirst();
                while (res.next()) {
                    if (res.getString("name").matches("PUBLIC"))
                        setSeverity(getSeverity()+1);
                }
            }

        } catch (SQLException e) {
            throw(new ProbeException(e.getMessage()));
        } catch (IOException e) {
            throw(new ProbeException(e.getMessage()));
        }
    }

    Connection con;
    ResultSet res;
}
