/*
 *(c) 2003, visigoth <visigoth@securitycentric.com>
 * This source code is distributed under a BSD license,
 * please see the LICENSE file for details
 *
 * OracleLinks.java
 *
 */

import com.securitycentric.metacoretex.interfaces.*;
import com.securitycentric.metacoretex.lib.*;

import java.sql.*;
import java.util.Vector;

/**
 *
 * @author  visigoth
 */
public class OracleLinks extends AbstractDatabaseProbe {
    
    /** Creates a new instance of OracleLinks */
    public OracleLinks() {
        
        setName("Oracle DB Links");
        setFamily("Oracle");
        setCopyright("(c) 2003, visigoth <visigoth@securitycentric.com>");
        setVersion("$Id: OracleLinks.java,v 1.2 2003/09/21 22:44:11 visigoth_6 Exp $");
        setProbeId(31);
        
        addDepends("oracle/connection");
        
        setReport("Found Oracle Links: \n");
        
        setHelp("This probe attemtps to enumerate links to other DB's. "+
                "It will only be capable of doing so if the JDBC Connection "+
                "stored in oracle/connection has sufficient privelages\n");
    }
    
    public void probe() throws ProbeException {
        
        try {
            
            if (! kbHas("oracle/connection"))
                return;

            con = (Connection) kbGet("oracle/connection");
            
            PreparedStatement ps = con.prepareStatement("SELECT name,host,userid,password from sys.link$");
            res = ps.executeQuery();

            addResultSet(res);
            
            setReportable(true);
            
        } catch (SQLException se) {
            throw(new ProbeException(se.getMessage()));
        }
    }

    Connection con;
    ResultSet res;
}
