/*
 *(c) 2003, visigoth <visigoth@securitycentric.com>
 * This source code is distributed under a BSD license,
 * please see the LICENSE file for details
 *
 * MssqlWeakAccounts.java
 *
 */

import com.securitycentric.metacoretex.interfaces.*;
import com.securitycentric.metacoretex.lib.*;

import java.util.*;
import java.io.*;
import java.sql.*;

/**
 *
 * @author  visigoth
 */
public class MysqlWeakAccounts extends AbstractAuthProbe {
    
    /** Creates a new instance of MssqlWeakAccounts */
    public MysqlWeakAccounts() {
        
        setName("MySQL Weak Accounts");
        setFamily("MySQL");
        setBrute(true);
        setVersion("$Id: MysqlWeakAccounts.java,v 1.2 2003/10/02 02:20:43 visigoth_6 Exp $");
        setProbeId(49);
        setTimeout(0);
        setCopyright("(c) 2003, visigoth <visigoth@securitycentric.com>");
        
        addDepends("mysql/connection");
        
        // Any weak accounts are critical
        setSeverity(3);
        
        addOption("dictionary",System.getProperty("user.dir")+"/conf/dict.txt");
        
        setReport("Found Weak Accounts:\n"+
        "USER\tPASS\n"+
        "=================================\n");
        
        setHelp("This probe attemtps to enumerate weak passwords. ");
    }
    
    public boolean shouldRun() throws ProbeException {
        if (!kbHas("mysql/connection"))
            return(false);
        
        try {
            con = (Connection)kbGet("mysql/connection");
            stmt = con.prepareStatement("SELECT User FROM mysql.user WHERE Password=Password(?)");
            
        } catch (SQLException e) {
            throw(new ProbeException(e.getMessage()));
        }
        return(true);
    }
    
    public int test(String pass) throws ProbeException {
        
        int myCount = 0;
        try {
            stmt.setString(1,pass);
            ResultSet res = stmt.executeQuery();
            
            while (res.next()) {
                addReport(res.getString("User")+" : "+pass);
                myCount++;
            }
            
        } catch (SQLException se) {
            throw(new ProbeException("SQL error: "+se.getMessage()));
        }
        return(myCount);
    }
    
    Connection con = null;
    Statement nullStmt = null;
    PreparedStatement stmt = null;
}
