/*
 *
 * (c) visigoth <visigoth@securitycentric.com>
 *
 * MysqlVariables.java
 *
 * Created on May 4, 2003, 8:03 AM
 */

import com.securitycentric.metacoretex.interfaces.*;
import com.securitycentric.metacoretex.lib.*;

import java.sql.*;
import java.util.*;

/**
 *
 * @author  
 */
public class MysqlVariables extends AbstractDatabaseProbe {
    
    /** Creates a new instance of MysqlVariables */
    public MysqlVariables() {
        
        setName("MySQL Variables");
	setFamily("MySQL");
        setVersion("$Id: MysqlVariables.java,v 1.2 2003/09/24 12:11:45 visigoth_6 Exp $");
        setProbeId(46);
        setCopyright("(c) visigoth <visigoth@securitycentric.com>");
        setSeverity(0);
        
	addProvides("mysql/Variables","Properties object of runtime vars");
        addDepends("mysql/connection");
        
        setReport("The current MySQL Variables:\n");
        
        setHelp("This probe enumerates all the run-time variables which are "+
		"accessable via the show variables SQL command.  Other "+
		"probes may use the information it provides for further "+
		"analysis");
    }
    
    public void probe() throws ProbeException {
        
	Properties prop = new Properties();

        try {
            
            if (! kbHas("mysql/connection"))
                return;

            con = (Connection) kbGet("mysql/connection");
            
            Statement stmt = con.createStatement();
            res = stmt.executeQuery("show variables");
            
            setReportable(true);

	    addResultSet(res);

	    while (res.next()) {
		prop.setProperty(res.getString(1),res.getString(2));
	    }

        } catch (SQLException se) {
            throw(new ProbeException(se.getMessage()));
        }

	kbPut("mysql/Variables",prop);
    }

    Connection con;
    ResultSet res;
}
