/*
 *(c) 2003, visigoth <visigoth@securitycentric.com>
 * This source code is distributed under a BSD license,
 * please see the LICENSE file for details
 *
 * MysqlUsers.java
 *
 * Created on May 4, 2003, 8:03 AM
 */

import com.securitycentric.metacoretex.interfaces.*;
import com.securitycentric.metacoretex.lib.*;

import java.sql.*;
import java.util.Vector;

/**
 *
 * @author  visigoth
 */
public class MysqlUsers extends AbstractDatabaseProbe {
    
    /** Creates a new instance of MysqlUsers */
    public MysqlUsers() {
        
        setName("Mysql Users");
        setFamily("MySQL");
        setCopyright("(c) 2003, visigoth <visigoth@securitycentric.com>");
        setVersion("$Id: MysqlUsers.java,v 1.4 2003/09/21 22:44:11 visigoth_6 Exp $");
        setProbeId(4);
        
        setHelp("This probe attemtps to enumerate DB users and passwords. "+
                "It will only be capable of doing so if the JDBC Connection "+
                "stored in mysql/connection has sufficient privelages\n");
        
        addDepends("mysql/connection");
        
        addProvides("mysql/users","Vector of strings of usernames");
        addProvides("mysql/hashes","Vector of strings of password hashes");
        
        setReport("Found Mysql Users: \n");
    }
    
    public void probe() throws ProbeException {
        
        try {
            
            if (! kbHas("mysql/connection"))
                return;
            
            con = (Connection) kbGet("mysql/connection");
            
            Vector users = new Vector();
            Vector hashes = new Vector();
            
            PreparedStatement ps = con.prepareStatement("SELECT User,Password from mysql.user");
            res = ps.executeQuery();
            setReportable(true);
            while (res.next()) {
                addReport(res.getString("User") + ":" + res.getString("Password"));
                users.add(res.getString("User"));
                hashes.add(res.getString("Password"));
            }
            
            kbPut("mysql/users",users);
            kbPut("mysql/hashes",hashes);
            
        } catch (SQLException se) {
            throw(new ProbeException(se.getMessage()));
        }
    }

    Connection con;
    ResultSet res;
}
