/*
 * (c) 2003, visigoth <visigoth@securitycentric.com>
 *
 */

import com.securitycentric.metacoretex.interfaces.*;
import com.securitycentric.metacoretex.lib.*;

/**
 *
 * @author  visigoth
 */
public class MssqlSp1 extends AbstractVersionProbe {
    
    /** Creates a new instance of MssqlSp1 */
    public MssqlSp1() {
        
        setName("MSSQL SP 1");
        setFamily("MS SQL");
        setVersion("$Id: MssqlSp1.java,v 1.5 2003/09/21 22:44:11 visigoth_6 Exp $");
        setProbeId(26);
        setCopyright("(c) 2003, visigoth <visigoth@securitycentric.com>");
        
        addDepends("mssql/Version");
        
        setHelp("This probe checks for MSSQL 2000 Service Pack 1");

        setReport("MSSQL Service Pack 1 is not installed.\n\n"+
                  "Service pack one addresses multiple known exploitable\n"+
                  "security vulnerabilities.  Please see MS support for\n"+
                  "details:\n\n"+
                  "http://support.microsoft.com/default.aspx?scid=kb;[LN];30608");
        setSeverity(3);

        setKbKey("mssql/Version");
        setMatchRelease(true);
        setTestVersion("8.0.384");
    }
}
