/*
 *(c) 2003, visigoth <visigoth@securitycentric.com>
 * This source code is distributed under a BSD license,
 * please see the LICENSE file for details
 *
 * MssqlC2.java
 *
 * Created on May 4, 2003, 8:03 AM
 */

import com.securitycentric.metacoretex.interfaces.*;
import com.securitycentric.metacoretex.lib.*;

import java.sql.*;

/**
 *
 * @author  visigoth
 */
public class MssqlC2 extends AbstractDatabaseProbe {
    
    /** Creates a new instance of MssqlC2 */
    public MssqlC2() {
        
        setName("MSSQL C2 Audit");
        setFamily("MS SQL");
        setVersion("$Id: MssqlC2.java,v 1.7 2003/09/21 22:44:11 visigoth_6 Exp $");
        setProbeId(16);

        setCopyright("(c) 2003, visigoth <visigoth@securitycentric.com>");
        
        addDepends("mssql/connection");
        
        setReport("MSSQL C2 Auditing is ");

        addProvides("mssql/c2","Boolean C2 Audit enabled?");
        
        setHelp("This probe attemtps to determine if C2 Auditing is enabled. "+
                "It will only be capable of doing so if the JDBC Connection "+
                "stored in mssql/connection has sufficient privelages\n");
    }
    
    public void probe() throws ProbeException {
        
        try {
            
            if (! kbHas("mssql/connection"))
                return;
            
            con = (Connection) kbGet("mssql/connection");
            
            PreparedStatement ps = con.prepareStatement("SELECT value from sysconfigures where config = 544");
            res = ps.executeQuery();
            
            setReportable(true);
            
            while (res.next()) {
                int x = res.getInt("value");
                if (x == 0) {
                    setReport(getReport() + "disabled");
                    setSeverity(1);
                    c2 = new Boolean(false);
                } else {
                    setReport(getReport() + "enabled");
                    c2 = new Boolean(true);
                }
            }

            kbPut("mssql/c2", c2);

        } catch (SQLException se) {
            throw(new ProbeException("Lack of Permission? " + se.getMessage()));
        }
    }

    Connection con;
    ResultSet res;
    Boolean c2;
}
