/*
 * JDBCTables.java
 *
 * Created on May 4, 2003, 8:03 AM
 */

import com.securitycentric.metacoretex.interfaces.*;
import com.securitycentric.metacoretex.lib.*;

import java.sql.*;
import java.util.*;

/**
 *
 * @author  visigoth
 */
public class JDBCTables extends AbstractDatabaseProbe {
    
    /** Creates a new instance of JDBCTables */
    public JDBCTables() {
        setName("JDBC Table enumeration");
        setFamily("JDBC");
        setVersion("$Id: JDBCTables.java,v 1.10 2003/09/21 22:44:11 visigoth_6 Exp $");
        setProbeId(10);
        setCopyright("(c) 2003, visigoth <visigoth@securitycentric.com>");

        setReport("Found the following:\n"+
                  "----------------------\n");

        setHelp("This probe attempts to use JDBC to enumerate DB names and Tables\n\n"+
                "Options:\n"+
                "db.types - list of database families to attempt this probe on\n\n");
        
        addProvides("mysql/dbs","Vector of Strings of DB names"); 
        addProvides("mssql/dbs","Vector of Strings of DB names");
        addProvides("mssql/tables","Vector of Strings of table names"); 
        addProvides("mssql/tables","Vector of Strings of table names");

        addDepends("mysql/metadata");
        addDepends("mssql/metadata");
        // Why does this hang on oracle?
        //addDepends("oracle/metadata");
        //addOption("db.types","mysql,oracle,mssql");

        addOption("db.types","mysql,mssql");
        
    }
    
    public void probe() throws ProbeException {

        String[] dbTypes = getOption("db.types").split(",");
        
        for (int i = 0; i < dbTypes.length; i++) {

            try {
                if ( ! kbHas(dbTypes[i]+"/metadata"))
                    continue;
            
                Vector dbs = new Vector();
                Vector tables = new Vector();
                DatabaseMetaData md = (DatabaseMetaData) kbGet(dbTypes[i]+"/metadata");
                ResultSet tabNames = md.getTables(null, null, null, null);
                ResultSet catNames = md.getCatalogs();

                setReportable(true);

                while (catNames.next()) {
                    addReport("Catalog: " + catNames.getString("TABLE_CAT"));
                    dbs.add(catNames.getString("TABLE_CAT"));
                }

                while (tabNames.next()) {
                    addReport("Table: " + tabNames.getString("TABLE_NAME"));
                    dbs.add(tabNames.getString("TABLE_NAME"));
                }

                kbPut(dbTypes[i]+"/dbs",dbs);
                kbPut(dbTypes[i]+"/tables",tables);
            
            } catch (SQLException se) {
                continue;
            }
        }
    }
}
