/*
 * 
 * PROBE_JAVA_NAME.java
 *
 */

import com.securitycentric.metacoretex.interfaces.*;
import com.securitycentric.metacoretex.lib.*;

import java.util.*;
import java.io.*;
import java.net.*;

/**
 *
 * @author  visigoth
 */
public class PROBE_JAVA_NAME extends AbstractProbe {
    
    /** Creates a new instance of PROBE_JAVA_HOME */
    public PROBE_JAVA_NAME() {
        setName("PROBE_NAME");
	setFamily("PROBE_FAMILY");
        setCopyright("PROBE_COPYRIGHT");
        setVersion("PROBE_VERSION");
        setProbeId(PROBE_ID);

        setHelp("PROBE_HELP");
        
        addDepends("tcp/ports");

        addProvides("oracle/status");//java.lang.String of TNS status response

        addOption("port","PROBE_PORT");
    }
    
    public void probe() throws ProbeException {

        /* Don't try if our port isn't open */
        if (kbHas("tcp/"+getOption("port"))) {
            Boolean bol = (Boolean)kbGet("tcp/"+getOption("port"));
            if (! bol.booleanValue()) {
                return;
            }
        }

        try {

            port = Integer.parseInt(getOption("port"));
            sleep = Integer.parseInt(getOption("wait"));

            soc = new Socket(getHost(), port);
            inStream = new BufferedInputStream( soc.getInputStream());
            outStream = new BufferedOutputStream( soc.getOutputStream());

            try {
                Thread.sleep(sleep*1000);
            } catch (InterruptedException e) {
            }

            resp = new byte[inStream.available()];
            inStream.read(resp);

            setReportable(true);

            respStr = new String(resp,"US-ASCII").trim().replaceAll("\\p{Cntrl}",".");

            setReport("The following is the entire status response:\n\n" + respStr);

            kbPut("PROBE_SERVICE/banner",respStr);

        } catch (IOException ie) {
            throw(new ProbeException(ie.getMessage()));
        } catch (InterruptedException ie) {
            throw(new ProbeException(ie.getMessage()));
        } catch (NumberFormatException ne) {
            throw(new ProbeException("Bad Number Option"));
        }
    }

    byte resp[];

    String respStr;

    int port,sleep;
    Socket soc;
    BufferedInputStream inStream;
    BufferedOutputStream outStream;
}
