/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.xjc.util;

import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JClassContainer;
import com.sun.codemodel.JDefinedClass;
import com.sun.tools.xjc.util.Messages;
import com.sun.tools.xjc.util.WrappedSAXException;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class CodeModelClassFactory {
    private ErrorHandler errorHandler;
    private int ticketMaster = 0;

    public CodeModelClassFactory(ErrorHandler _errorHandler) {
        this.errorHandler = _errorHandler;
    }

    public JDefinedClass createClass(JClassContainer parent, String name, Locator source) {
        return this.createClass(parent, 1, name, source);
    }

    public JDefinedClass createClass(JClassContainer parent, int mod, String name, Locator source) {
        return this.createClass(parent, mod, name, source, false);
    }

    public JDefinedClass createInterface(JClassContainer parent, String name, Locator source) {
        return this.createInterface(parent, 1, name, source);
    }

    public JDefinedClass createInterface(JClassContainer parent, int mod, String name, Locator source) {
        return this.createClass(parent, mod, name, source, true);
    }

    private JDefinedClass createClass(JClassContainer parent, int mod, String name, Locator source, boolean isInterface) {
        try {
            JDefinedClass r = parent._class(mod, name, isInterface);
            r.metadata = source;
            return r;
        }
        catch (JClassAlreadyExistsException e) {
            JDefinedClass cls = e.getExistingClass();
            try {
                this.errorHandler.error(new SAXParseException(Messages.format("CodeModelClassFactory.ClassNameCollision", cls.fullName()), source));
                this.errorHandler.error(new SAXParseException(Messages.format("CodeModelClassFactory.ClassNameCollision.Source"), (Locator)cls.metadata));
            }
            catch (SAXException ee) {
                throw new WrappedSAXException(ee);
            }
            try {
                return parent.owner()._class("$$$garbage$$$" + this.ticketMaster++);
            }
            catch (JClassAlreadyExistsException ee) {
                return ee.getExistingClass();
            }
        }
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }
}

