/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.xjc.reader.xmlschema.bindinfo;

import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JType;
import com.sun.tools.xjc.reader.xmlschema.bindinfo.BindInfo;
import com.sun.tools.xjc.reader.xmlschema.bindinfo.Messages;
import com.sun.tools.xjc.reader.xmlschema.bindinfo.parser.NGCCRuntime;
import javax.xml.namespace.QName;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.LocatorImpl;

public class NGCCRuntimeEx
extends NGCCRuntime {
    public final JCodeModel codeModel;
    public final ErrorHandler errorHandler;
    public BindInfo currentBindInfo;
    static final String ERR_CLASS_NOT_FOUND = "NGCCRuntimeEx.ClassNotFound";
    static final String ERR_UNIMPLEMENTED = "NGCCRuntimeEx.Unimplemented";
    static final String ERR_UNSUPPORTED = "NGCCRuntimeEx.Unsupported";
    static final String ERR_UNDEFINED_PREFIX = "NGCCRuntimeEx.UndefinedPrefix";
    static /* synthetic */ Class class$java$lang$Object;

    public NGCCRuntimeEx(JCodeModel _codeModel, ErrorHandler _errorHandler) {
        this.codeModel = _codeModel;
        this.errorHandler = _errorHandler;
    }

    public JType getType(String typeName) throws SAXException {
        try {
            return JType.parse(this.codeModel, typeName);
        }
        catch (IllegalArgumentException e) {
            try {
                return this.codeModel.ref(typeName);
            }
            catch (ClassNotFoundException ee) {
                this.errorHandler.error(new SAXParseException(Messages.format(ERR_CLASS_NOT_FOUND, typeName), this.getLocator()));
                return this.codeModel.ref(class$java$lang$Object == null ? (class$java$lang$Object = NGCCRuntimeEx.class$("java.lang.Object")) : class$java$lang$Object);
            }
        }
    }

    public Locator copyLocator() {
        return new LocatorImpl(super.getLocator());
    }

    public boolean parseBoolean(String str) {
        return (str = str.trim()).equals("true") || str.equals("1");
    }

    public QName parseQName(String str) throws SAXException {
        int idx = str.indexOf(58);
        if (idx < 0) {
            String uri = this.resolveNamespacePrefix("");
            return new QName(uri, str);
        }
        String prefix = str.substring(0, idx);
        String uri = this.resolveNamespacePrefix(prefix);
        if (uri == null) {
            this.errorHandler.error(new SAXParseException(Messages.format(ERR_UNDEFINED_PREFIX, prefix), this.getLocator()));
            uri = "undefined";
        }
        return new QName(uri, str.substring(idx + 1));
    }

    public void reportUnimplementedFeature(String name) throws SAXException {
        this.errorHandler.warning(new SAXParseException(Messages.format(ERR_UNIMPLEMENTED, name), this.getLocator()));
    }

    public void reportUnsupportedFeature(String name) throws SAXException {
        this.errorHandler.warning(new SAXParseException(Messages.format(ERR_UNSUPPORTED, name), this.getLocator()));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

