/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.xjc.reader.xmlschema;

import com.sun.tools.xjc.reader.xmlschema.Messages;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.XMLFilterImpl;

public class ProhibitedFeaturesFilter
extends XMLFilterImpl {
    private Locator locator = null;
    private ErrorHandler errorHandler = null;
    private boolean strict = true;
    private static final int REPORT_STRICT_MODE_ERROR = 1;
    private static final int REPORT_WARN = 2;
    private static final int REPORT_UNSUPPORTED_ERROR = 3;
    private static boolean debug = false;

    public ProhibitedFeaturesFilter(ErrorHandler eh, boolean strict) {
        this.errorHandler = eh;
        this.strict = strict;
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (localName.equals("any") && "skip".equals(atts.getValue("processContents"))) {
            this.report(2, "ProhibitedFeaturesFilter.ProcessContentsAttrOfAny", this.locator);
        } else if (localName.equals("anyAttribute")) {
            this.report(this.strict ? 1 : 2, "ProhibitedFeaturesFilter.AnyAttr", this.locator);
        } else if (localName.equals("complexType")) {
            if (atts.getValue("block") != null && !ProhibitedFeaturesFilter.parseComplexTypeBlockAttr(atts.getValue("block"))) {
                this.report(2, "ProhibitedFeaturesFilter.BlockAttrOfComplexType", this.locator);
            }
            if (atts.getValue("final") != null) {
                this.report(2, "ProhibitedFeaturesFilter.FinalAttrOfComplexType", this.locator);
            }
        } else if (localName.equals("element")) {
            if (atts.getValue("abstract") != null && ProhibitedFeaturesFilter.parsedBooleanTrue(atts.getValue("abstract"))) {
                this.report(3, "ProhibitedFeaturesFilter.AbstractAttrOfElement", this.locator);
            }
            if (atts.getValue("substitutionGroup") != null && !atts.getValue("substitutionGroup").trim().equals("")) {
                this.report(3, "ProhibitedFeaturesFilter.SubstitutionGroupAttrOfElement", this.locator);
            }
            if (atts.getValue("final") != null) {
                this.report(2, "ProhibitedFeaturesFilter.FinalAttrOfElement", this.locator);
            }
            if (atts.getValue("block") != null && !ProhibitedFeaturesFilter.parseElementBlockAttr(atts.getValue("block"))) {
                this.report(2, "ProhibitedFeaturesFilter.BlockAttrOfElement", this.locator);
            }
        } else if (localName.equals("key")) {
            this.report(this.strict ? 1 : 2, "ProhibitedFeaturesFilter.Key", this.locator);
        } else if (localName.equals("keyref")) {
            this.report(this.strict ? 1 : 2, "ProhibitedFeaturesFilter.Keyref", this.locator);
        } else if (localName.equals("notation")) {
            this.report(this.strict ? 1 : 2, "ProhibitedFeaturesFilter.Notation", this.locator);
        } else if (localName.equals("unique")) {
            this.report(this.strict ? 1 : 2, "ProhibitedFeaturesFilter.Unique", this.locator);
        } else if (localName.equals("redefine")) {
            this.report(3, "ProhibitedFeaturesFilter.Redefine", this.locator);
        } else if (localName.equals("schema")) {
            if (atts.getValue("blockDefault") != null && !atts.getValue("blockDefault").equals("#all")) {
                this.report(2, "ProhibitedFeaturesFilter.BlockDefaultAttrOfSchema", this.locator);
            }
            if (atts.getValue("finalDefault") != null) {
                this.report(2, "ProhibitedFeaturesFilter.FinalDefaultAttrOfSchema", this.locator);
            }
            if (this.strict && atts.getValue("http://java.sun.com/xml/ns/jaxb", "extensionBindingPrefixes") != null) {
                this.report(1, "ProhibitedFeaturesFilter.ExtensionBindingPrefixesOfSchema", this.locator);
            }
        }
        super.startElement(uri, localName, qName, atts);
    }

    public void setDocumentLocator(Locator locator) {
        super.setDocumentLocator(locator);
        this.locator = locator;
    }

    private void report(int type, String msg, Locator loc) throws SAXException {
        SAXParseException spe = null;
        switch (type) {
            case 1: {
                spe = new SAXParseException(Messages.format("ProhibitedFeaturesFilter.StrictModePrefix") + "\n\t" + Messages.format(msg), loc);
                this.errorHandler.error(spe);
                throw spe;
            }
            case 2: {
                spe = new SAXParseException(Messages.format("ProhibitedFeaturesFilter.WarningPrefix") + " " + Messages.format(msg), loc);
                this.errorHandler.warning(spe);
                break;
            }
            case 3: {
                spe = new SAXParseException(Messages.format("ProhibitedFeaturesFilter.UnsupportedPrefix") + " " + Messages.format(msg), loc);
                this.errorHandler.error(spe);
                throw spe;
            }
            default: {
                throw new InternalError();
            }
        }
    }

    private static boolean parsedBooleanTrue(String lexicalBoolean) throws SAXParseException {
        return lexicalBoolean.equals("true") || lexicalBoolean.equals("1");
    }

    private static boolean parseElementBlockAttr(String lexicalBlock) {
        return lexicalBlock.equals("#all") || lexicalBlock.indexOf("restriction") != -1 && lexicalBlock.indexOf("extension") != -1 && lexicalBlock.indexOf("substitution") != -1;
    }

    private static boolean parseComplexTypeBlockAttr(String lexicalBlock) {
        return lexicalBlock.equals("#all") || lexicalBlock.indexOf("restriction") != -1 && lexicalBlock.indexOf("extension") != -1;
    }

    static {
        try {
            debug = System.getProperty("jaxb.debug") != null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

